/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReader;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderBuilder;
import org.apache.pulsar.reactive.client.api.ReactivePulsarClient;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.PulsarTopicBuilder;
import org.springframework.pulsar.reactive.core.ReactiveMessageReaderBuilderCustomizer;
import org.springframework.pulsar.reactive.core.ReactivePulsarReaderFactory;
import org.springframework.util.CollectionUtils;

public class DefaultReactivePulsarReaderFactory<T>
implements ReactivePulsarReaderFactory<T> {
    private final ReactivePulsarClient reactivePulsarClient;
    @Nullable
    private final List<ReactiveMessageReaderBuilderCustomizer<T>> defaultConfigCustomizers;
    @Nullable
    private PulsarTopicBuilder topicBuilder;

    public DefaultReactivePulsarReaderFactory(ReactivePulsarClient reactivePulsarClient, List<ReactiveMessageReaderBuilderCustomizer<T>> defaultConfigCustomizers) {
        this.reactivePulsarClient = reactivePulsarClient;
        this.defaultConfigCustomizers = defaultConfigCustomizers;
    }

    public void setTopicBuilder(@Nullable PulsarTopicBuilder topicBuilder) {
        this.topicBuilder = topicBuilder;
    }

    @Override
    public ReactiveMessageReader<T> createReader(Schema<T> schema) {
        return this.createReader(schema, Collections.emptyList());
    }

    @Override
    public ReactiveMessageReader<T> createReader(Schema<T> schema, List<ReactiveMessageReaderBuilderCustomizer<T>> customizers) {
        ReactiveMessageReaderBuilder readerBuilder = this.reactivePulsarClient.messageReader(schema);
        if (!CollectionUtils.isEmpty(this.defaultConfigCustomizers)) {
            this.defaultConfigCustomizers.forEach(customizer -> customizer.customize(readerBuilder));
        }
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(c -> c.customize(readerBuilder));
        }
        if (this.topicBuilder != null) {
            this.ensureTopicNamesFullyQualified(readerBuilder);
        }
        return readerBuilder.build();
    }

    protected void ensureTopicNamesFullyQualified(ReactiveMessageReaderBuilder<T> readerBuilder) {
        MutableReactiveMessageReaderSpec mutableSpec = readerBuilder.getMutableSpec();
        List topics = mutableSpec.getTopicNames();
        if (!CollectionUtils.isEmpty((Collection)topics)) {
            List<String> fullyQualifiedTopics = topics.stream().map(arg_0 -> ((PulsarTopicBuilder)this.topicBuilder).getFullyQualifiedNameForTopic(arg_0)).toList();
            mutableSpec.setTopicNames(fullyQualifiedTopics);
        }
    }
}

