/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.config.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.pulsar.annotation.AbstractPulsarAnnotationsBeanPostProcessor;
import org.springframework.pulsar.annotation.PulsarHeaderObjectMapperUtils;
import org.springframework.pulsar.annotation.PulsarListenerConfigurer;
import org.springframework.pulsar.config.PulsarListenerEndpointRegistrar;
import org.springframework.pulsar.reactive.config.MethodReactivePulsarListenerEndpoint;
import org.springframework.pulsar.reactive.config.ReactivePulsarListenerContainerFactory;
import org.springframework.pulsar.reactive.config.ReactivePulsarListenerEndpointRegistry;
import org.springframework.pulsar.reactive.config.annotation.ReactivePulsarListener;
import org.springframework.pulsar.reactive.config.annotation.ReactivePulsarListenerMessageConsumerBuilderCustomizer;
import org.springframework.pulsar.reactive.config.annotation.ReactivePulsarListeners;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ReactivePulsarListenerAnnotationBeanPostProcessor<V>
extends AbstractPulsarAnnotationsBeanPostProcessor
implements SmartInitializingSingleton {
    public static final String DEFAULT_REACTIVE_PULSAR_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "reactivePulsarListenerContainerFactory";
    private static final String GENERATED_ID_PREFIX = "org.springframework.Pulsar.ReactivePulsarListenerEndpointContainer#";
    private ReactivePulsarListenerEndpointRegistry<?> endpointRegistry;
    private String defaultContainerFactoryBeanName = "reactivePulsarListenerContainerFactory";
    private final PulsarListenerEndpointRegistrar registrar = new PulsarListenerEndpointRegistrar(ReactivePulsarListenerContainerFactory.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final AtomicInteger counter = new AtomicInteger();
    private final List<MethodReactivePulsarListenerEndpoint<?>> processedEndpoints = new ArrayList();

    public void afterSingletonsInstantiated() {
        this.registrar.setBeanFactory(this.beanFactory);
        this.beanFactory.getBeanProvider(PulsarListenerConfigurer.class).forEach(c -> c.configurePulsarListeners(this.registrar));
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (ReactivePulsarListenerEndpointRegistry)((Object)this.beanFactory.getBean("org.springframework.pulsar.config.internalReactivePulsarListenerEndpointRegistry", ReactivePulsarListenerEndpointRegistry.class));
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.defaultContainerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.defaultContainerFactoryBeanName);
        }
        this.addFormatters((FormatterRegistry)this.messageHandlerMethodFactory.getDefaultFormattingConversionService());
        this.postProcessEndpointsBeforeRegistration();
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set<ReactivePulsarListener> listenerMethods = this.findListenerAnnotations(method);
                return !listenerMethods.isEmpty() ? listenerMethods : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                this.logger.trace(() -> "No @ReactivePulsarListener annotations found on bean type: " + String.valueOf(bean.getClass()));
            } else {
                for (Map.Entry entry : annotatedMethods.entrySet()) {
                    Method method2 = (Method)entry.getKey();
                    for (ReactivePulsarListener listener : (Set)entry.getValue()) {
                        this.processReactivePulsarListener(listener, method2, bean, beanName);
                    }
                }
                this.logger.debug(() -> annotatedMethods.size() + " @ReactivePulsarListener methods processed on bean '" + beanName + "': " + String.valueOf(annotatedMethods));
            }
        }
        return bean;
    }

    protected void processReactivePulsarListener(ReactivePulsarListener reactivePulsarListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodReactivePulsarListenerEndpoint endpoint = new MethodReactivePulsarListenerEndpoint();
        endpoint.setMethod(methodToUse);
        String beanRef = reactivePulsarListener.beanRef();
        this.listenerScope.addListener(beanRef, bean);
        String[] topics = this.resolveTopics(reactivePulsarListener);
        String topicPattern = this.getTopicPattern(reactivePulsarListener);
        this.processListener(endpoint, reactivePulsarListener, bean, beanName, topics, topicPattern);
        this.listenerScope.removeListener(beanRef);
    }

    protected void processListener(MethodReactivePulsarListenerEndpoint<?> endpoint, ReactivePulsarListener ReactivePulsarListener2, Object bean, String beanName, String[] topics, String topicPattern) {
        this.processReactivePulsarListenerAnnotation(endpoint, ReactivePulsarListener2, bean, topics, topicPattern);
        String containerFactory = this.resolve(ReactivePulsarListener2.containerFactory());
        ReactivePulsarListenerContainerFactory<?> listenerContainerFactory = this.resolveContainerFactory(ReactivePulsarListener2, containerFactory, beanName);
        this.registrar.registerEndpoint(endpoint, listenerContainerFactory);
    }

    @Nullable
    private ReactivePulsarListenerContainerFactory<?> resolveContainerFactory(ReactivePulsarListener ReactivePulsarListener2, Object factoryTarget, String beanName) {
        String containerFactory = ReactivePulsarListener2.containerFactory();
        if (!StringUtils.hasText((String)containerFactory)) {
            return null;
        }
        ReactivePulsarListenerContainerFactory factory = null;
        Object resolved = this.resolveExpression(containerFactory);
        if (resolved instanceof ReactivePulsarListenerContainerFactory) {
            return (ReactivePulsarListenerContainerFactory)resolved;
        }
        String containerFactoryBeanName = this.resolveExpressionAsString(containerFactory, "containerFactory");
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            this.assertBeanFactory();
            try {
                factory = (ReactivePulsarListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, ReactivePulsarListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(factoryTarget, beanName, containerFactoryBeanName, ReactivePulsarListenerContainerFactory.class), (Throwable)ex);
            }
        }
        return factory;
    }

    private void processReactivePulsarListenerAnnotation(MethodReactivePulsarListenerEndpoint<?> endpoint, ReactivePulsarListener reactivePulsarListener, Object bean, String[] topics, String topicPattern) {
        String autoStartup;
        String useKeyOrderedProcessing;
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(reactivePulsarListener));
        endpoint.setTopics(topics);
        endpoint.setTopicPattern(topicPattern);
        this.resolveSubscriptionType(endpoint, reactivePulsarListener);
        this.resolveSubscriptionName(endpoint, reactivePulsarListener);
        endpoint.setSchemaType(reactivePulsarListener.schemaType());
        String concurrency = reactivePulsarListener.concurrency();
        if (StringUtils.hasText((String)concurrency)) {
            endpoint.setConcurrency(this.resolveExpressionAsInteger(concurrency, "concurrency"));
        }
        if (StringUtils.hasText((String)(useKeyOrderedProcessing = reactivePulsarListener.useKeyOrderedProcessing()))) {
            endpoint.setUseKeyOrderedProcessing(this.resolveExpressionAsBoolean(useKeyOrderedProcessing, "useKeyOrderedProcessing"));
        }
        if (StringUtils.hasText((String)(autoStartup = reactivePulsarListener.autoStartup()))) {
            endpoint.setAutoStartup(this.resolveExpressionAsBoolean(autoStartup, "autoStartup"));
        }
        endpoint.setFluxListener(reactivePulsarListener.stream());
        endpoint.setBeanFactory(this.beanFactory);
        this.resolveDeadLetterPolicy(endpoint, reactivePulsarListener);
        this.resolveConsumerCustomizer(endpoint, reactivePulsarListener);
        this.processedEndpoints.add(endpoint);
    }

    private void resolveSubscriptionType(MethodReactivePulsarListenerEndpoint<?> endpoint, ReactivePulsarListener listener) {
        Assert.state((listener.subscriptionType().length <= 1 ? 1 : 0) != 0, () -> "ReactivePulsarListener.subscriptionType must have 0 or 1 elements");
        if (listener.subscriptionType().length == 1) {
            endpoint.setSubscriptionType(listener.subscriptionType()[0]);
        }
    }

    private void resolveSubscriptionName(MethodReactivePulsarListenerEndpoint<?> endpoint, ReactivePulsarListener listener) {
        if (StringUtils.hasText((String)listener.subscriptionName())) {
            endpoint.setSubscriptionName(this.resolveExpressionAsString(listener.subscriptionName(), "subscriptionName"));
        }
    }

    private void resolveDeadLetterPolicy(MethodReactivePulsarListenerEndpoint<?> endpoint, ReactivePulsarListener reactivePulsarListener) {
        Object deadLetterPolicy = this.resolveExpression(reactivePulsarListener.deadLetterPolicy());
        if (deadLetterPolicy instanceof DeadLetterPolicy) {
            endpoint.setDeadLetterPolicy((DeadLetterPolicy)deadLetterPolicy);
        } else {
            String deadLetterPolicyBeanName = this.resolveExpressionAsString(reactivePulsarListener.deadLetterPolicy(), "deadLetterPolicy");
            if (StringUtils.hasText((String)deadLetterPolicyBeanName)) {
                endpoint.setDeadLetterPolicy((DeadLetterPolicy)this.beanFactory.getBean(deadLetterPolicyBeanName, DeadLetterPolicy.class));
            }
        }
    }

    protected void postProcessEndpointsBeforeRegistration() {
        PulsarHeaderObjectMapperUtils.customMapper((BeanFactory)this.beanFactory).ifPresent(objectMapper -> this.processedEndpoints.forEach(endpoint -> endpoint.setObjectMapper((ObjectMapper)objectMapper)));
        if (this.processedEndpoints.size() == 1) {
            MethodReactivePulsarListenerEndpoint<?> endpoint = this.processedEndpoints.get(0);
            if (endpoint.getConsumerCustomizer() != null) {
                return;
            }
            this.beanFactory.getBeanProvider(ReactivePulsarListenerMessageConsumerBuilderCustomizer.class).ifUnique(customizer -> {
                this.logger.info(() -> String.format("Setting the only registered ReactivePulsarListenerMessageConsumerBuilderCustomizer on the only registered @ReactivePulsarListener (%s)", endpoint.getId()));
                endpoint.setConsumerCustomizer(customizer::customize);
            });
        }
    }

    private void resolveConsumerCustomizer(MethodReactivePulsarListenerEndpoint<?> endpoint, ReactivePulsarListener reactivePulsarListener) {
        if (!StringUtils.hasText((String)reactivePulsarListener.consumerCustomizer())) {
            return;
        }
        Object consumerCustomizer = this.resolveExpression(reactivePulsarListener.consumerCustomizer());
        if (consumerCustomizer instanceof ReactivePulsarListenerMessageConsumerBuilderCustomizer) {
            ReactivePulsarListenerMessageConsumerBuilderCustomizer customizer = (ReactivePulsarListenerMessageConsumerBuilderCustomizer)consumerCustomizer;
            endpoint.setConsumerCustomizer(customizer::customize);
        } else {
            String customizerBeanName = this.resolveExpressionAsString(reactivePulsarListener.consumerCustomizer(), "consumerCustomizer");
            if (StringUtils.hasText((String)customizerBeanName)) {
                ReactivePulsarListenerMessageConsumerBuilderCustomizer customizer = (ReactivePulsarListenerMessageConsumerBuilderCustomizer)this.beanFactory.getBean(customizerBeanName, ReactivePulsarListenerMessageConsumerBuilderCustomizer.class);
                endpoint.setConsumerCustomizer(customizer::customize);
            }
        }
    }

    private String getEndpointId(ReactivePulsarListener reactivePulsarListener) {
        if (StringUtils.hasText((String)reactivePulsarListener.id())) {
            return this.resolveExpressionAsString(reactivePulsarListener.id(), "id");
        }
        return GENERATED_ID_PREFIX + this.counter.getAndIncrement();
    }

    private String getTopicPattern(ReactivePulsarListener reactivePulsarListener) {
        return this.resolveExpressionAsString(reactivePulsarListener.topicPattern(), "topicPattern");
    }

    private String[] resolveTopics(ReactivePulsarListener ReactivePulsarListener2) {
        String[] topics = ReactivePulsarListener2.topics();
        ArrayList result = new ArrayList();
        if (topics.length > 0) {
            for (String topic1 : topics) {
                Object topic = this.resolveExpression(topic1);
                this.resolveAsString(topic, result);
            }
        }
        return result.toArray(new String[0]);
    }

    private Collection<ReactivePulsarListener> findListenerAnnotations(Class<?> clazz) {
        ReactivePulsarListeners anns;
        HashSet<ReactivePulsarListener> listeners = new HashSet<ReactivePulsarListener>();
        ReactivePulsarListener ann = (ReactivePulsarListener)AnnotatedElementUtils.findMergedAnnotation(clazz, ReactivePulsarListener.class);
        if (ann != null) {
            listeners.add(ann);
        }
        if ((anns = (ReactivePulsarListeners)AnnotationUtils.findAnnotation(clazz, ReactivePulsarListeners.class)) != null) {
            listeners.addAll(Arrays.stream(anns.value()).toList());
        }
        return listeners;
    }

    private Set<ReactivePulsarListener> findListenerAnnotations(Method method) {
        ReactivePulsarListeners anns;
        HashSet<ReactivePulsarListener> listeners = new HashSet<ReactivePulsarListener>();
        ReactivePulsarListener ann = (ReactivePulsarListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ReactivePulsarListener.class);
        if (ann != null) {
            listeners.add(ann);
        }
        if ((anns = (ReactivePulsarListeners)AnnotationUtils.findAnnotation((Method)method, ReactivePulsarListeners.class)) != null) {
            listeners.addAll(Arrays.stream(anns.value()).toList());
        }
        return listeners;
    }

    private void addFormatters(FormatterRegistry registry) {
        this.beanFactory.getBeanProvider(Converter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        this.beanFactory.getBeanProvider(GenericConverter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        this.beanFactory.getBeanProvider(Formatter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addFormatter(arg_0));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.setBeanFactory((BeanFactory)((ConfigurableApplicationContext)applicationContext).getBeanFactory());
        } else {
            this.setBeanFactory((BeanFactory)applicationContext);
        }
    }
}

