/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.core;

import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.reactive.client.api.MessageSendResult;
import org.apache.pulsar.reactive.client.api.MessageSpec;
import org.reactivestreams.Publisher;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.reactive.core.MessageSpecBuilderCustomizer;
import org.springframework.pulsar.reactive.core.ReactiveMessageSenderBuilderCustomizer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactivePulsarOperations<T> {
    public Mono<MessageId> send(@Nullable T var1);

    public Mono<MessageId> send(@Nullable T var1, @Nullable Schema<T> var2);

    public Mono<MessageId> send(@Nullable String var1, @Nullable T var2);

    public Mono<MessageId> send(@Nullable String var1, @Nullable T var2, @Nullable Schema<T> var3);

    public Flux<MessageSendResult<T>> send(Publisher<MessageSpec<T>> var1);

    public Flux<MessageSendResult<T>> send(Publisher<MessageSpec<T>> var1, @Nullable Schema<T> var2);

    public Flux<MessageSendResult<T>> send(@Nullable String var1, Publisher<MessageSpec<T>> var2);

    public Flux<MessageSendResult<T>> send(@Nullable String var1, Publisher<MessageSpec<T>> var2, @Nullable Schema<T> var3);

    public SendOneMessageBuilder<T> newMessage(@Nullable T var1);

    public SendManyMessageBuilder<T> newMessages(Publisher<MessageSpec<T>> var1);

    public static interface SendManyMessageBuilder<T>
    extends SendMessageBuilder<SendManyMessageBuilder<T>, T> {
        public Flux<MessageSendResult<T>> send();
    }

    public static interface SendOneMessageBuilder<T>
    extends SendMessageBuilder<SendOneMessageBuilder<T>, T> {
        public SendOneMessageBuilder<T> withMessageCustomizer(MessageSpecBuilderCustomizer<T> var1);

        public Mono<MessageId> send();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SendMessageBuilder<O, T> {
        public O withTopic(String var1);

        public O withSchema(Schema<T> var1);

        public O withSenderCustomizer(ReactiveMessageSenderBuilderCustomizer<T> var1);
    }
}

