/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.modulith.events.config.EventPublicationAutoConfiguration;
import org.springframework.modulith.events.config.EventPublicationConfigurationExtension;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.modulith.events.jdbc.DatabaseSchemaInitializer;
import org.springframework.modulith.events.jdbc.DatabaseSchemaLocator;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.modulith.events.jdbc.JdbcEventPublicationRepository;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={EventPublicationAutoConfiguration.class})
class JdbcEventPublicationAutoConfiguration
implements EventPublicationConfigurationExtension {
    JdbcEventPublicationAutoConfiguration() {
    }

    @Bean
    DatabaseType databaseType(DataSource dataSource) {
        return DatabaseType.from(JdbcEventPublicationAutoConfiguration.fromDataSource(dataSource));
    }

    @Bean
    JdbcEventPublicationRepository jdbcEventPublicationRepository(JdbcTemplate jdbcTemplate, EventSerializer serializer, DatabaseType databaseType) {
        return new JdbcEventPublicationRepository((JdbcOperations)jdbcTemplate, serializer, databaseType);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.modulith.events.jdbc.schema-initialization.enabled"}, havingValue="true")
    DatabaseSchemaInitializer databaseSchemaInitializer(DataSource dataSource, ResourceLoader resourceLoader, DatabaseType databaseType) {
        return () -> {
            DatabaseSchemaLocator locator = new DatabaseSchemaLocator(resourceLoader);
            new ResourceDatabasePopulator(new Resource[]{locator.getSchemaResource(databaseType)}).execute(dataSource);
        };
    }

    private static String fromDataSource(DataSource dataSource) {
        String name = null;
        try {
            String metadata = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName);
            name = JdbcUtils.commonDatabaseName((String)metadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name == null ? "UNKNOWN" : name;
    }
}

