/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.switcher;

import org.springframework.mobile.device.switcher.AbstractSiteUrlFactory;
import org.springframework.mobile.device.switcher.SiteUrlFactory;
import org.springframework.util.Assert;

public abstract class AbstractSitePathUrlFactory
extends AbstractSiteUrlFactory
implements SiteUrlFactory {
    private final String mobilePath;
    private final String rootPath;

    public AbstractSitePathUrlFactory(String mobilePath) {
        this(mobilePath, null);
    }

    public AbstractSitePathUrlFactory(String mobilePath, String rootPath) {
        Assert.notNull((Object)mobilePath, (String)"mobilePath is required");
        this.mobilePath = this.formatPath(mobilePath);
        this.rootPath = this.formatPath(rootPath);
    }

    public String getMobilePath() {
        return this.mobilePath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getFullMobilePath() {
        return this.rootPath == null ? this.mobilePath : this.getCleanPath(this.getRootPath()) + this.mobilePath;
    }

    protected String getCleanMobilePath() {
        return this.getCleanPath(this.getFullMobilePath());
    }

    private String formatPath(String path) {
        String formattedPath = null;
        if (path != null) {
            formattedPath = path.startsWith("/") ? path : "/" + path;
            formattedPath = path.endsWith("/") ? path : path + "/";
        }
        return formattedPath;
    }

    private String getCleanPath(String path) {
        return path.substring(0, path.length() - 1);
    }
}

