/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import javax.naming.Name;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.ldap.test.LdapTestUtils;
import org.springframework.util.Assert;

public class TestContextSourceFactoryBean
extends AbstractFactoryBean {
    private int port;
    private @Nullable String defaultPartitionSuffix;
    private @Nullable String defaultPartitionName;
    private String principal = "";
    private String password = "";
    private boolean baseOnTarget = true;
    private @Nullable Resource ldifFile;
    private Class dirObjectFactory = DefaultDirObjectFactory.class;
    private boolean pooled = true;
    private AuthenticationSource authenticationSource = new SimpleAuthenticationSource();
    private @Nullable ContextSource contextSource;

    public void setAuthenticationSource(AuthenticationSource authenticationSource) {
        this.authenticationSource = authenticationSource;
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public void setDirObjectFactory(Class dirObjectFactory) {
        this.dirObjectFactory = dirObjectFactory;
    }

    public void setLdifFile(Resource ldifFile) {
        this.ldifFile = ldifFile;
    }

    public void setBaseOnTarget(boolean baseOnTarget) {
        this.baseOnTarget = baseOnTarget;
    }

    public void setDefaultPartitionSuffix(String defaultPartitionSuffix) {
        this.defaultPartitionSuffix = defaultPartitionSuffix;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDefaultPartitionName(String defaultPartitionName) {
        this.defaultPartitionName = defaultPartitionName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setContextSource(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    protected Object createInstance() throws Exception {
        Assert.notNull((Object)this.defaultPartitionSuffix, (String)"defaultPartitionSuffix cannot be null");
        Assert.notNull((Object)this.defaultPartitionName, (String)"defaultPartitionName cannot be null");
        LdapTestUtils.startEmbeddedServer(this.port, this.defaultPartitionSuffix, this.defaultPartitionName);
        if (this.contextSource == null) {
            LdapContextSource targetContextSource = new LdapContextSource();
            if (this.baseOnTarget) {
                targetContextSource.setBase(this.defaultPartitionSuffix);
            }
            targetContextSource.setUrl("ldap://localhost:" + this.port);
            targetContextSource.setUserDn(this.principal);
            targetContextSource.setPassword(this.password);
            targetContextSource.setDirObjectFactory(this.dirObjectFactory);
            targetContextSource.setPooled(this.pooled);
            targetContextSource.setAuthenticationSource(this.authenticationSource);
            targetContextSource.afterPropertiesSet();
            this.contextSource = targetContextSource;
        }
        Thread.sleep(1000L);
        if (this.baseOnTarget) {
            LdapTestUtils.clearSubContexts(this.contextSource, (Name)LdapUtils.emptyLdapName());
        } else {
            LdapTestUtils.clearSubContexts(this.contextSource, (Name)LdapUtils.newLdapName((String)this.defaultPartitionSuffix));
        }
        if (this.ldifFile != null) {
            LdapTestUtils.loadLdif(this.contextSource, this.ldifFile);
        }
        return this.contextSource;
    }

    public Class getObjectType() {
        return ContextSource.class;
    }

    protected void destroyInstance(@Nullable Object instance) throws Exception {
        super.destroyInstance(instance);
        LdapTestUtils.shutdownEmbeddedServer();
    }

    class SimpleAuthenticationSource
    implements AuthenticationSource {
        SimpleAuthenticationSource() {
        }

        public String getPrincipal() {
            return TestContextSourceFactoryBean.this.principal;
        }

        public String getCredentials() {
            return TestContextSourceFactoryBean.this.password;
        }
    }
}

