/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public abstract class AbstractEc2InstanceLaunchingFactoryBean
extends AbstractFactoryBean {
    private static final int INSTANCE_START_SLEEP_TIME = 1000;
    private static final long DEFAULT_PREPARATION_SLEEP_TIME = 30000L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEc2InstanceLaunchingFactoryBean.class);
    private @Nullable String imageName;
    private @Nullable String awsKey;
    private @Nullable String awsSecretKey;
    private @Nullable String keypairName;
    private @Nullable String groupName;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ReservationDescription.Instance instance;
    private long preparationSleepTime = 30000L;

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setAwsKey(String awsKey) {
        this.awsKey = awsKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public void setKeypairName(String keypairName) {
        this.keypairName = keypairName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    protected final Object createInstance() throws Exception {
        Assert.hasLength((String)this.imageName, (String)"ImageName must be set");
        Assert.hasLength((String)this.awsKey, (String)"AwsKey must be set");
        Assert.hasLength((String)this.awsSecretKey, (String)"AwsSecretKey must be set");
        Assert.hasLength((String)this.keypairName, (String)"KeyName must be set");
        Assert.hasLength((String)this.groupName, (String)"GroupName must be set");
        LOG.info("Launching EC2 instance for image: " + this.imageName);
        Jec2 jec2 = new Jec2(this.awsKey, this.awsSecretKey);
        LaunchConfiguration launchConfiguration = new LaunchConfiguration(this.imageName);
        launchConfiguration.setKeyName(this.keypairName);
        launchConfiguration.setSecurityGroup(Collections.singletonList(this.groupName));
        ReservationDescription reservationDescription = jec2.runInstances(launchConfiguration);
        this.instance = (ReservationDescription.Instance)reservationDescription.getInstances().get(0);
        while (!this.instance.isRunning() && !this.instance.isTerminated()) {
            LOG.info("Instance still starting up; sleeping 1000ms");
            Thread.sleep(1000L);
            reservationDescription = (ReservationDescription)jec2.describeInstances(Collections.singletonList(this.instance.getInstanceId())).get(0);
            this.instance = (ReservationDescription.Instance)reservationDescription.getInstances().get(0);
        }
        if (this.instance.isRunning()) {
            LOG.info("EC2 instance is now running");
            if (this.preparationSleepTime > 0L) {
                LOG.info("Sleeping " + this.preparationSleepTime + "ms allowing instance services to start up properly.");
                Thread.sleep(this.preparationSleepTime);
                LOG.info("Instance prepared - proceeding");
            }
            return this.doCreateInstance(this.instance.getDnsName());
        }
        throw new IllegalStateException("Failed to start a new instance");
    }

    protected abstract Object doCreateInstance(String var1) throws Exception;

    protected void destroyInstance(@Nullable Object ignored) throws Exception {
        if (this.instance != null) {
            LOG.info("Shutting down instance");
            Jec2 jec2 = new Jec2(this.awsKey, this.awsSecretKey);
            jec2.terminateInstances(Collections.singletonList(this.instance.getInstanceId()));
        }
    }
}

