/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.naming.Name;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.ldap.test.LdapTestUtils;
import org.springframework.util.Assert;

public class LdifPopulator
implements InitializingBean {
    private Resource resource;
    private ContextSource contextSource;
    private String base = "";
    private boolean clean = false;
    private String defaultBase;

    public void setContextSource(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public void setDefaultBase(String defaultBase) {
        this.defaultBase = defaultBase;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.contextSource, (String)"ContextSource must be specified");
        Assert.notNull((Object)this.resource, (String)"Resource must be specified");
        if (!LdapUtils.newLdapName((String)this.base).equals(LdapUtils.newLdapName((String)this.defaultBase))) {
            List lines = IOUtils.readLines((InputStream)this.resource.getInputStream());
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            for (String line : lines) {
                writer.println(StringUtils.replace((String)line, (String)this.defaultBase, (String)this.base));
            }
            writer.flush();
            this.resource = new ByteArrayResource(sw.toString().getBytes("UTF8"));
        }
        if (this.clean) {
            LdapTestUtils.clearSubContexts(this.contextSource, (Name)LdapUtils.emptyLdapName());
        }
        LdapTestUtils.loadLdif(this.contextSource, this.resource);
    }
}

