/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.ldif.batch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.LdapAttributes;
import org.springframework.ldap.ldif.batch.RecordCallbackHandler;
import org.springframework.ldap.ldif.parser.LdifParser;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Deprecated
public class LdifReader
extends AbstractItemCountingItemStreamItemReader<LdapAttributes>
implements ResourceAwareItemReaderItemStream<LdapAttributes>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(LdifReader.class);
    private Resource resource;
    private LdifParser ldifParser;
    private int recordCount = 0;
    private int recordsToSkip = 0;
    private boolean strict = true;
    private RecordCallbackHandler skippedRecordsCallback;

    public LdifReader() {
        this.setName(ClassUtils.getShortName(LdifReader.class));
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSkippedRecordsCallback(RecordCallbackHandler skippedRecordsCallback) {
        this.skippedRecordsCallback = skippedRecordsCallback;
    }

    public void setRecordsToSkip(int recordsToSkip) {
        this.recordsToSkip = recordsToSkip;
    }

    protected void doClose() throws Exception {
        if (this.ldifParser != null) {
            this.ldifParser.close();
        }
        this.recordCount = 0;
    }

    protected void doOpen() throws Exception {
        if (this.resource == null) {
            throw new IllegalStateException("A resource has not been set.");
        }
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode): " + this.resource);
            }
            LOG.warn("Input resource does not exist " + this.resource.getDescription());
            return;
        }
        this.ldifParser.open();
        for (int i = 0; i < this.recordsToSkip; ++i) {
            LdapAttributes record = this.ldifParser.getRecord();
            if (this.skippedRecordsCallback == null) continue;
            this.skippedRecordsCallback.handleRecord(record);
        }
    }

    protected LdapAttributes doRead() throws Exception {
        LdapAttributes attributes = null;
        try {
            if (this.ldifParser != null) {
                while (attributes == null && this.ldifParser.hasMoreRecords()) {
                    attributes = this.ldifParser.getRecord();
                }
                ++this.recordCount;
            }
            return attributes;
        }
        catch (Exception ex) {
            LOG.error("Parsing error at record " + this.recordCount + " in resource=" + this.resource.getDescription() + ", input=[" + attributes + "]", (Throwable)ex);
            throw ex;
        }
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        this.ldifParser = new LdifParser(resource);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource, (String)"A resource is required to parse.");
        Assert.notNull((Object)this.ldifParser);
    }
}

