/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ConsumerAwareRecordRecoverer;
import org.springframework.kafka.listener.ErrorHandlingUtils;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.support.KafkaUtils;
import org.springframework.kafka.support.SendResult;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.kafka.support.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DeadLetterPublishingRecoverer
extends ExceptionClassifier
implements ConsumerAwareRecordRecoverer {
    private static final BiFunction<ConsumerRecord<?, ?>, Exception, Headers> DEFAULT_HEADERS_FUNCTION = (rec, ex) -> null;
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private static final BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> DEFAULT_DESTINATION_RESOLVER = (cr, e) -> new TopicPartition(cr.topic() + "-dlt", cr.partition());
    private static final long FIVE = 5L;
    private static final long THIRTY = 30L;
    private final boolean transactional;
    private final BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver;
    private final Function<ProducerRecord<?, ?>, KafkaOperations<?, ?>> templateResolver;
    private final EnumSet<HeaderNames.HeadersToAdd> whichHeaders = EnumSet.allOf(HeaderNames.HeadersToAdd.class);
    private HeaderNames headerNames = this.getHeaderNames();
    private boolean retainExceptionHeader;
    private BiFunction<ConsumerRecord<?, ?>, Exception, Headers> headersFunction = DEFAULT_HEADERS_FUNCTION;
    private boolean verifyPartition = true;
    private Duration partitionInfoTimeout = Duration.ofSeconds(5L);
    private Duration waitForSendResultTimeout = Duration.ofSeconds(30L);
    private boolean appendOriginalHeaders = true;
    private boolean failIfSendResultIsError = true;
    private boolean throwIfNoDestinationReturned = false;
    private long timeoutBuffer = Duration.ofSeconds(5L).toMillis();
    private boolean stripPreviousExceptionHeaders = true;
    private boolean skipSameTopicFatalExceptions = true;
    private boolean logRecoveryRecord = false;
    private ExceptionHeadersCreator exceptionHeadersCreator = this::addExceptionInfoHeaders;
    private Supplier<HeaderNames> headerNamesSupplier = () -> HeaderNames.Builder.original().offsetHeader("kafka_dlt-original-offset").timestampHeader("kafka_dlt-original-timestamp").timestampTypeHeader("kafka_dlt-original-timestamp-type").topicHeader("kafka_dlt-original-topic").partitionHeader("kafka_dlt-original-partition").consumerGroupHeader("kafka_dlt-original-consumer-group").exception().keyExceptionFqcn("kafka_dlt-key-exception-fqcn").exceptionFqcn("kafka_dlt-exception-fqcn").exceptionCauseFqcn("kafka_dlt-exception-cause-fqcn").keyExceptionMessage("kafka_dlt-key-exception-message").exceptionMessage("kafka_dlt-exception-message").keyExceptionStacktrace("kafka_dlt-key-exception-stacktrace").exceptionStacktrace("kafka_dlt-exception-stacktrace").build();

    public DeadLetterPublishingRecoverer(KafkaOperations<? extends Object, ? extends Object> template) {
        this(template, DEFAULT_DESTINATION_RESOLVER);
    }

    public DeadLetterPublishingRecoverer(KafkaOperations<? extends Object, ? extends Object> template, BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver) {
        this(Collections.singletonMap(Object.class, template), destinationResolver);
    }

    public DeadLetterPublishingRecoverer(Map<Class<?>, KafkaOperations<? extends Object, ? extends Object>> templates) {
        this(templates, DEFAULT_DESTINATION_RESOLVER);
    }

    public DeadLetterPublishingRecoverer(Map<Class<?>, KafkaOperations<? extends Object, ? extends Object>> templates, BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver) {
        Assert.isTrue((!ObjectUtils.isEmpty(templates) ? 1 : 0) != 0, (String)"At least one template is required");
        Assert.notNull(destinationResolver, (String)"The destinationResolver cannot be null");
        KafkaOperations<? extends Object, ? extends Object> firstTemplate = templates.values().iterator().next();
        this.templateResolver = templates.size() == 1 ? producerRecord -> firstTemplate : producerRecord -> this.findTemplateForValue(producerRecord.value(), templates);
        this.transactional = firstTemplate.isTransactional();
        Boolean tx = this.transactional;
        Assert.isTrue((boolean)templates.values().stream().map(t -> t.isTransactional()).allMatch(t -> t.equals(tx)), (String)"All templates must have the same setting for transactional");
        this.destinationResolver = destinationResolver;
    }

    public DeadLetterPublishingRecoverer(Function<ProducerRecord<?, ?>, KafkaOperations<?, ?>> templateResolver, BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver) {
        this(templateResolver, false, destinationResolver);
    }

    public DeadLetterPublishingRecoverer(Function<ProducerRecord<?, ?>, KafkaOperations<?, ?>> templateResolver, boolean transactional, BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver) {
        Assert.notNull(templateResolver, (String)"The templateResolver cannot be null");
        Assert.notNull(destinationResolver, (String)"The destinationResolver cannot be null");
        this.transactional = transactional;
        this.destinationResolver = destinationResolver;
        this.templateResolver = templateResolver;
    }

    public void setRetainExceptionHeader(boolean retainExceptionHeader) {
        this.retainExceptionHeader = retainExceptionHeader;
    }

    public void setHeadersFunction(BiFunction<ConsumerRecord<?, ?>, Exception, Headers> headersFunction) {
        Assert.notNull(headersFunction, (String)"'headersFunction' cannot be null");
        if (!this.headersFunction.equals(DEFAULT_HEADERS_FUNCTION)) {
            this.logger.warn(() -> "Replacing custom headers function: " + String.valueOf(this.headersFunction) + ", consider using addHeadersFunction() if you need multiple functions");
        }
        this.headersFunction = headersFunction;
    }

    public void setVerifyPartition(boolean verifyPartition) {
        this.verifyPartition = verifyPartition;
    }

    public void setPartitionInfoTimeout(Duration partitionInfoTimeout) {
        Assert.notNull((Object)partitionInfoTimeout, (String)"'partitionInfoTimeout' cannot be null");
        this.partitionInfoTimeout = partitionInfoTimeout;
    }

    public void setAppendOriginalHeaders(boolean appendOriginalHeaders) {
        this.appendOriginalHeaders = appendOriginalHeaders;
    }

    public void setThrowIfNoDestinationReturned(boolean throwIfNoDestinationReturned) {
        this.throwIfNoDestinationReturned = throwIfNoDestinationReturned;
    }

    public void setFailIfSendResultIsError(boolean failIfSendResultIsError) {
        this.failIfSendResultIsError = failIfSendResultIsError;
    }

    protected boolean isFailIfSendResultIsError() {
        return this.failIfSendResultIsError;
    }

    public void setWaitForSendResultTimeout(Duration waitForSendResultTimeout) {
        this.waitForSendResultTimeout = waitForSendResultTimeout;
    }

    public void setTimeoutBuffer(long buffer) {
        this.timeoutBuffer = buffer;
    }

    protected long getTimeoutBuffer() {
        return this.timeoutBuffer;
    }

    public void setStripPreviousExceptionHeaders(boolean stripPreviousExceptionHeaders) {
        this.stripPreviousExceptionHeaders = stripPreviousExceptionHeaders;
    }

    public void setSkipSameTopicFatalExceptions(boolean skipSameTopicFatalExceptions) {
        this.skipSameTopicFatalExceptions = skipSameTopicFatalExceptions;
    }

    public void setLogRecoveryRecord(boolean logRecoveryRecord) {
        this.logRecoveryRecord = logRecoveryRecord;
    }

    public void setExceptionHeadersCreator(ExceptionHeadersCreator headersCreator) {
        Assert.notNull((Object)headersCreator, (String)"'headersCreator' cannot be null");
        this.exceptionHeadersCreator = headersCreator;
    }

    protected boolean isTransactional() {
        return this.transactional;
    }

    public void excludeHeader(HeaderNames.HeadersToAdd ... headers) {
        Assert.notNull((Object)headers, (String)"'headers' cannot be null");
        Assert.noNullElements((Object[])headers, (String)"'headers' cannot include null elements");
        for (HeaderNames.HeadersToAdd header : headers) {
            this.whichHeaders.remove((Object)header);
        }
    }

    public void includeHeader(HeaderNames.HeadersToAdd ... headers) {
        Assert.notNull((Object)headers, (String)"'headers' cannot be null");
        Assert.noNullElements((Object[])headers, (String)"'headers' cannot include null elements");
        for (HeaderNames.HeadersToAdd header : headers) {
            this.whichHeaders.add(header);
        }
    }

    public void addHeadersFunction(BiFunction<ConsumerRecord<?, ?>, Exception, Headers> headersFunction) {
        Assert.notNull(headersFunction, (String)"'headersFunction' cannot be null");
        if (this.headersFunction.equals(DEFAULT_HEADERS_FUNCTION)) {
            this.headersFunction = headersFunction;
        } else {
            BiFunction<ConsumerRecord<?, ?>, Exception, Headers> toCompose = this.headersFunction;
            this.headersFunction = (rec, ex) -> {
                Headers headers1 = (Headers)toCompose.apply((ConsumerRecord<?, ?>)rec, (Exception)ex);
                if (headers1 == null) {
                    headers1 = new RecordHeaders();
                }
                Headers headers2 = (Headers)headersFunction.apply((ConsumerRecord<?, ?>)rec, (Exception)ex);
                try {
                    if (headers2 != null) {
                        headers2.forEach(arg_0 -> ((Headers)headers1).add(arg_0));
                    }
                }
                catch (IllegalStateException isex) {
                    headers1 = new RecordHeaders((Iterable)headers1);
                    headers2.forEach(arg_0 -> ((Headers)headers1).add(arg_0));
                }
                return headers1;
            };
        }
    }

    @Override
    public void accept(ConsumerRecord<?, ?> record, @Nullable Consumer<?, ?> consumer, Exception exception) {
        TopicPartition tp = this.destinationResolver.apply(record, exception);
        if (tp == null) {
            this.maybeThrow(record, exception);
            this.logger.debug(() -> "Recovery of " + KafkaUtils.format(record) + " skipped because destination resolver returned null");
            return;
        }
        if (this.skipSameTopicFatalExceptions && tp.topic().equals(record.topic()) && !this.getClassifier().classify((Throwable)exception).booleanValue()) {
            this.logger.error((CharSequence)("Recovery of " + KafkaUtils.format(record) + " skipped because not retryable exception " + exception.toString() + " and the destination resolver routed back to the same topic"));
            return;
        }
        if (this.logRecoveryRecord) {
            this.logger.info((Throwable)exception, () -> "Recovery record " + KafkaUtils.format(record));
        }
        if (consumer != null && this.verifyPartition) {
            tp = this.checkPartition(tp, consumer);
        }
        DeserializationException vDeserEx = SerializationUtils.getExceptionFromHeader(record, "springDeserializerExceptionValue", this.logger);
        DeserializationException kDeserEx = SerializationUtils.getExceptionFromHeader(record, "springDeserializerExceptionKey", this.logger);
        RecordHeaders headers = new RecordHeaders(record.headers().toArray());
        this.addAndEnhanceHeaders(record, exception, vDeserEx, kDeserEx, (Headers)headers);
        ProducerRecord<Object, Object> outRecord = this.createProducerRecord(record, tp, (Headers)headers, kDeserEx == null ? null : kDeserEx.getData(), vDeserEx == null ? null : vDeserEx.getData());
        KafkaOperations<Object, Object> kafkaTemplate = this.templateResolver.apply(outRecord);
        this.sendOrThrow(outRecord, kafkaTemplate, record);
    }

    private void addAndEnhanceHeaders(ConsumerRecord<?, ?> record, Exception exception, @Nullable DeserializationException vDeserEx, @Nullable DeserializationException kDeserEx, Headers headers) {
        if (this.headerNames == null) {
            this.headerNames = this.headerNamesSupplier.get();
        }
        if (kDeserEx != null) {
            if (!this.retainExceptionHeader) {
                headers.remove("springDeserializerExceptionKey");
            }
            this.exceptionHeadersCreator.create(headers, (Exception)((Object)kDeserEx), true, this.headerNames);
        }
        if (vDeserEx != null) {
            if (!this.retainExceptionHeader) {
                headers.remove("springDeserializerExceptionValue");
            }
            this.exceptionHeadersCreator.create(headers, (Exception)((Object)vDeserEx), false, this.headerNames);
        }
        if (kDeserEx == null && vDeserEx == null) {
            this.exceptionHeadersCreator.create(headers, exception, false, this.headerNames);
        }
        this.enhanceHeaders(headers, record, exception);
    }

    private void sendOrThrow(ProducerRecord<Object, Object> outRecord, @Nullable KafkaOperations<Object, Object> kafkaTemplate, ConsumerRecord<?, ?> inRecord) {
        if (kafkaTemplate == null) {
            throw new IllegalArgumentException("No kafka template returned for record " + String.valueOf(outRecord));
        }
        this.send(outRecord, kafkaTemplate, inRecord);
    }

    private void maybeThrow(ConsumerRecord<?, ?> record, Exception exception) {
        String message = String.format("No destination returned for record %s and exception %s. throwIfNoDestinationReturned: %s", KafkaUtils.format(record), exception, this.throwIfNoDestinationReturned);
        this.logger.warn((CharSequence)message);
        if (this.throwIfNoDestinationReturned) {
            throw new IllegalArgumentException(message);
        }
    }

    protected void send(ProducerRecord<Object, Object> outRecord, KafkaOperations<Object, Object> kafkaTemplate, ConsumerRecord<?, ?> inRecord) {
        if (this.transactional && !kafkaTemplate.inTransaction() && !kafkaTemplate.isAllowNonTransactional()) {
            kafkaTemplate.executeInTransaction(t -> {
                this.publish(outRecord, t, inRecord);
                return null;
            });
        } else {
            this.publish(outRecord, kafkaTemplate, inRecord);
        }
    }

    private TopicPartition checkPartition(TopicPartition tp, Consumer<?, ?> consumer) {
        if (tp.partition() < 0) {
            return tp;
        }
        try {
            List partitions = consumer.partitionsFor(tp.topic(), this.partitionInfoTimeout);
            if (partitions == null) {
                this.logger.debug(() -> "Could not obtain partition info for " + tp.topic());
                return tp;
            }
            boolean anyMatch = partitions.stream().anyMatch(pi -> pi.partition() == tp.partition());
            if (!anyMatch) {
                this.logger.warn(() -> "Destination resolver returned non-existent partition " + String.valueOf(tp) + ", KafkaProducer will determine partition to use for this topic");
                return new TopicPartition(tp.topic(), -1);
            }
            return tp;
        }
        catch (Exception ex) {
            this.logger.debug((Throwable)ex, () -> "Could not obtain partition info for " + tp.topic());
            return tp;
        }
    }

    private KafkaOperations<Object, Object> findTemplateForValue(@Nullable Object value, Map<Class<?>, KafkaOperations<?, ?>> templates) {
        if (value == null) {
            KafkaOperations<Object, Object> operations = templates.get(Void.class);
            if (operations == null) {
                return templates.values().iterator().next();
            }
            return operations;
        }
        Optional<Class> key = templates.keySet().stream().filter(k -> k.isAssignableFrom(value.getClass())).findFirst();
        if (key.isPresent()) {
            return templates.get(key.get());
        }
        this.logger.warn(() -> "Failed to find a template for " + String.valueOf(value.getClass()) + " attempting to use the last entry");
        return templates.values().stream().reduce((first, second) -> second).get();
    }

    protected ProducerRecord<Object, Object> createProducerRecord(ConsumerRecord<?, ?> record, TopicPartition topicPartition, Headers headers, @Nullable byte[] key, @Nullable byte[] value) {
        return new ProducerRecord(topicPartition.topic(), topicPartition.partition() < 0 ? null : Integer.valueOf(topicPartition.partition()), (Object)(key != null ? key : (byte[])record.key()), (Object)(value != null ? value : (byte[])record.value()), (Iterable)headers);
    }

    protected void publish(ProducerRecord<Object, Object> outRecord, KafkaOperations<Object, Object> kafkaTemplate, ConsumerRecord<?, ?> inRecord) {
        CompletableFuture<SendResult<Object, Object>> sendResult = null;
        try {
            sendResult = kafkaTemplate.send(outRecord);
            sendResult.whenComplete((result, ex) -> {
                if (ex == null) {
                    this.logger.debug(() -> "Successful dead-letter publication: " + KafkaUtils.format(inRecord) + " to " + String.valueOf(result.getRecordMetadata()));
                } else {
                    this.logger.error(ex, () -> this.pubFailMessage(outRecord, inRecord));
                }
            });
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, () -> this.pubFailMessage(outRecord, inRecord));
        }
        if (this.failIfSendResultIsError) {
            this.verifySendResult(kafkaTemplate, outRecord, sendResult, inRecord);
        }
    }

    protected void verifySendResult(KafkaOperations<Object, Object> kafkaTemplate, ProducerRecord<Object, Object> outRecord, @Nullable CompletableFuture<SendResult<Object, Object>> sendResult, ConsumerRecord<?, ?> inRecord) {
        Duration sendTimeout = this.determineSendTimeout(kafkaTemplate);
        if (sendResult == null) {
            throw new KafkaException(this.pubFailMessage(outRecord, inRecord));
        }
        try {
            sendResult.get(sendTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KafkaException(this.pubFailMessage(outRecord, inRecord), e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new KafkaException(this.pubFailMessage(outRecord, inRecord), e);
        }
    }

    private String pubFailMessage(ProducerRecord<Object, Object> outRecord, ConsumerRecord<?, ?> inRecord) {
        return "Dead-letter publication to " + outRecord.topic() + " failed for: " + KafkaUtils.format(inRecord);
    }

    protected Duration determineSendTimeout(KafkaOperations<?, ?> template) {
        ProducerFactory<?, ?> producerFactory = template.getProducerFactory();
        if (producerFactory != null) {
            Map<String, Object> props;
            try {
                props = producerFactory.getConfigurationProperties();
            }
            catch (UnsupportedOperationException ex) {
                props = Collections.emptyMap();
            }
            if (props != null) {
                return KafkaUtils.determineSendTimeout(props, this.timeoutBuffer, this.waitForSendResultTimeout.toMillis());
            }
        }
        return Duration.ofSeconds(30L);
    }

    private void enhanceHeaders(Headers kafkaHeaders, ConsumerRecord<?, ?> record, Exception exception) {
        this.maybeAddOriginalHeaders(kafkaHeaders, record, exception);
        Headers headers = this.headersFunction.apply(record, exception);
        if (headers != null) {
            headers.forEach(header -> {
                if (header instanceof SingleRecordHeader) {
                    kafkaHeaders.remove(header.key());
                }
                kafkaHeaders.add(header);
            });
        }
    }

    private void maybeAddOriginalHeaders(Headers kafkaHeaders, ConsumerRecord<?, ?> record, Exception ex) {
        String consumerGroup;
        this.maybeAddHeader(kafkaHeaders, this.headerNames.original.topicHeader, () -> record.topic().getBytes(StandardCharsets.UTF_8), HeaderNames.HeadersToAdd.TOPIC);
        this.maybeAddHeader(kafkaHeaders, this.headerNames.original.partitionHeader, () -> ByteBuffer.allocate(4).putInt(record.partition()).array(), HeaderNames.HeadersToAdd.PARTITION);
        this.maybeAddHeader(kafkaHeaders, this.headerNames.original.offsetHeader, () -> ByteBuffer.allocate(8).putLong(record.offset()).array(), HeaderNames.HeadersToAdd.OFFSET);
        this.maybeAddHeader(kafkaHeaders, this.headerNames.original.timestampHeader, () -> ByteBuffer.allocate(8).putLong(record.timestamp()).array(), HeaderNames.HeadersToAdd.TS);
        this.maybeAddHeader(kafkaHeaders, this.headerNames.original.timestampTypeHeader, () -> record.timestampType().toString().getBytes(StandardCharsets.UTF_8), HeaderNames.HeadersToAdd.TS_TYPE);
        if (ex instanceof ListenerExecutionFailedException && (consumerGroup = ((ListenerExecutionFailedException)((Object)ex)).getGroupId()) != null) {
            this.maybeAddHeader(kafkaHeaders, this.headerNames.original.consumerGroup, () -> consumerGroup.getBytes(StandardCharsets.UTF_8), HeaderNames.HeadersToAdd.GROUP);
        }
    }

    private void maybeAddHeader(Headers kafkaHeaders, String header, Supplier<byte[]> valueSupplier, HeaderNames.HeadersToAdd hta) {
        if (this.whichHeaders.contains((Object)hta) && (this.appendOriginalHeaders || kafkaHeaders.lastHeader(header) == null)) {
            kafkaHeaders.add(header, valueSupplier.get());
        }
    }

    private void addExceptionInfoHeaders(Headers kafkaHeaders, Exception exception, boolean isKey, HeaderNames names) {
        String message;
        this.appendOrReplace(kafkaHeaders, isKey ? names.exceptionInfo.keyExceptionFqcn : names.exceptionInfo.exceptionFqcn, () -> exception.getClass().getName().getBytes(StandardCharsets.UTF_8), HeaderNames.HeadersToAdd.EXCEPTION);
        Exception cause = ErrorHandlingUtils.findRootCause(exception);
        if (cause != null) {
            this.appendOrReplace(kafkaHeaders, names.exceptionInfo.exceptionCauseFqcn, () -> cause.getClass().getName().getBytes(StandardCharsets.UTF_8), HeaderNames.HeadersToAdd.EX_CAUSE);
        }
        if ((message = this.buildMessage(exception, cause)) != null) {
            this.appendOrReplace(kafkaHeaders, isKey ? names.exceptionInfo.keyExceptionMessage : names.exceptionInfo.exceptionMessage, () -> message.getBytes(StandardCharsets.UTF_8), HeaderNames.HeadersToAdd.EX_MSG);
        }
        this.appendOrReplace(kafkaHeaders, isKey ? names.exceptionInfo.keyExceptionStacktrace : names.exceptionInfo.exceptionStacktrace, () -> this.getStackTraceAsString(exception).getBytes(StandardCharsets.UTF_8), HeaderNames.HeadersToAdd.EX_STACKTRACE);
    }

    @Nullable
    private String buildMessage(Exception exception, Throwable cause) {
        Object message = exception.getMessage();
        if (!exception.equals(cause)) {
            String causeMsg;
            if (message != null) {
                message = (String)message + "; ";
            }
            if ((causeMsg = cause.getMessage()) != null) {
                message = message != null ? (String)message + causeMsg : causeMsg;
            }
        }
        return message;
    }

    private void appendOrReplace(Headers headers, String header, Supplier<byte[]> valueSupplier, HeaderNames.HeadersToAdd hta) {
        if (this.whichHeaders.contains((Object)hta)) {
            if (this.stripPreviousExceptionHeaders) {
                headers.remove(header);
            }
            headers.add(header, valueSupplier.get());
        }
    }

    private String getStackTraceAsString(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        cause.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    @Nullable
    @Deprecated(since="3.0.9", forRemoval=true)
    protected HeaderNames getHeaderNames() {
        return null;
    }

    public void setHeaderNamesSupplier(Supplier<HeaderNames> supplier) {
        Assert.notNull(supplier, (String)"'HeaderNames supplier cannot be null");
        this.headerNamesSupplier = supplier;
    }

    public static class HeaderNames {
        private final Original original;
        private final ExceptionInfo exceptionInfo;

        HeaderNames(Original original, ExceptionInfo exceptionInfo) {
            this.original = original;
            this.exceptionInfo = exceptionInfo;
        }

        public Original getOriginal() {
            return this.original;
        }

        public ExceptionInfo getExceptionInfo() {
            return this.exceptionInfo;
        }

        public static class Original {
            final String offsetHeader;
            final String timestampHeader;
            final String timestampTypeHeader;
            final String topicHeader;
            final String partitionHeader;
            final String consumerGroup;

            Original(String offsetHeader, String timestampHeader, String timestampTypeHeader, String topicHeader, String partitionHeader, String consumerGroup) {
                this.offsetHeader = offsetHeader;
                this.timestampHeader = timestampHeader;
                this.timestampTypeHeader = timestampTypeHeader;
                this.topicHeader = topicHeader;
                this.partitionHeader = partitionHeader;
                this.consumerGroup = consumerGroup;
            }

            public String getOffsetHeader() {
                return this.offsetHeader;
            }

            public String getTimestampHeader() {
                return this.timestampHeader;
            }

            public String getTimestampTypeHeader() {
                return this.timestampTypeHeader;
            }

            public String getTopicHeader() {
                return this.topicHeader;
            }

            public String getPartitionHeader() {
                return this.partitionHeader;
            }

            public String getConsumerGroup() {
                return this.consumerGroup;
            }
        }

        public static class ExceptionInfo {
            final String keyExceptionFqcn;
            final String exceptionFqcn;
            final String exceptionCauseFqcn;
            final String keyExceptionMessage;
            final String exceptionMessage;
            final String keyExceptionStacktrace;
            final String exceptionStacktrace;

            ExceptionInfo(String keyExceptionFqcn, String exceptionFqcn, String exceptionCauseFqcn, String keyExceptionMessage, String exceptionMessage, String keyExceptionStacktrace, String exceptionStacktrace) {
                this.keyExceptionFqcn = keyExceptionFqcn;
                this.exceptionFqcn = exceptionFqcn;
                this.exceptionCauseFqcn = exceptionCauseFqcn;
                this.keyExceptionMessage = keyExceptionMessage;
                this.exceptionMessage = exceptionMessage;
                this.keyExceptionStacktrace = keyExceptionStacktrace;
                this.exceptionStacktrace = exceptionStacktrace;
            }

            public String getKeyExceptionFqcn() {
                return this.keyExceptionFqcn;
            }

            public String getExceptionFqcn() {
                return this.exceptionFqcn;
            }

            public String getExceptionCauseFqcn() {
                return this.exceptionCauseFqcn;
            }

            public String getKeyExceptionMessage() {
                return this.keyExceptionMessage;
            }

            public String getExceptionMessage() {
                return this.exceptionMessage;
            }

            public String getKeyExceptionStacktrace() {
                return this.keyExceptionStacktrace;
            }

            public String getExceptionStacktrace() {
                return this.exceptionStacktrace;
            }
        }

        public static class Builder {
            private final Original original = new Original();
            private final ExceptionInfo exceptionInfo = new ExceptionInfo();

            public static Original original() {
                return new Builder().original;
            }

            public class Original {
                private String offsetHeader;
                private String timestampHeader;
                private String timestampTypeHeader;
                private String topicHeader;
                private String partitionHeader;
                private String consumerGroupHeader;

                public Original offsetHeader(String offsetHeader) {
                    this.offsetHeader = offsetHeader;
                    return this;
                }

                public Original timestampHeader(String timestampHeader) {
                    this.timestampHeader = timestampHeader;
                    return this;
                }

                public Original timestampTypeHeader(String timestampTypeHeader) {
                    this.timestampTypeHeader = timestampTypeHeader;
                    return this;
                }

                public Original topicHeader(String topicHeader) {
                    this.topicHeader = topicHeader;
                    return this;
                }

                public Original partitionHeader(String partitionHeader) {
                    this.partitionHeader = partitionHeader;
                    return this;
                }

                public Original consumerGroupHeader(String consumerGroupHeader) {
                    this.consumerGroupHeader = consumerGroupHeader;
                    return this;
                }

                public ExceptionInfo exception() {
                    return Builder.this.exceptionInfo;
                }

                private org.springframework.kafka.listener.DeadLetterPublishingRecoverer$HeaderNames$Original build() {
                    Assert.notNull((Object)this.offsetHeader, (String)"offsetHeader cannot be null");
                    Assert.notNull((Object)this.timestampHeader, (String)"timestampHeader cannot be null");
                    Assert.notNull((Object)this.timestampTypeHeader, (String)"timestampTypeHeader cannot be null");
                    Assert.notNull((Object)this.topicHeader, (String)"topicHeader cannot be null");
                    Assert.notNull((Object)this.partitionHeader, (String)"partitionHeader cannot be null");
                    Assert.notNull((Object)this.consumerGroupHeader, (String)"consumerGroupHeader cannot be null");
                    return new org.springframework.kafka.listener.DeadLetterPublishingRecoverer$HeaderNames$Original(this.offsetHeader, this.timestampHeader, this.timestampTypeHeader, this.topicHeader, this.partitionHeader, this.consumerGroupHeader);
                }
            }

            public class ExceptionInfo {
                private String keyExceptionFqcn;
                private String exceptionFqcn;
                private String exceptionCauseFqcn;
                private String keyExceptionMessage;
                private String exceptionMessage;
                private String keyExceptionStacktrace;
                private String exceptionStacktrace;

                public ExceptionInfo keyExceptionFqcn(String keyExceptionFqcn) {
                    this.keyExceptionFqcn = keyExceptionFqcn;
                    return this;
                }

                public ExceptionInfo exceptionFqcn(String exceptionFqcn) {
                    this.exceptionFqcn = exceptionFqcn;
                    return this;
                }

                public ExceptionInfo exceptionCauseFqcn(String exceptionCauseFqcn) {
                    this.exceptionCauseFqcn = exceptionCauseFqcn;
                    return this;
                }

                public ExceptionInfo keyExceptionMessage(String keyExceptionMessage) {
                    this.keyExceptionMessage = keyExceptionMessage;
                    return this;
                }

                public ExceptionInfo exceptionMessage(String exceptionMessage) {
                    this.exceptionMessage = exceptionMessage;
                    return this;
                }

                public ExceptionInfo keyExceptionStacktrace(String keyExceptionStacktrace) {
                    this.keyExceptionStacktrace = keyExceptionStacktrace;
                    return this;
                }

                public ExceptionInfo exceptionStacktrace(String exceptionStacktrace) {
                    this.exceptionStacktrace = exceptionStacktrace;
                    return this;
                }

                public HeaderNames build() {
                    Assert.notNull((Object)this.keyExceptionFqcn, (String)"keyExceptionFqcn header cannot be null");
                    Assert.notNull((Object)this.exceptionFqcn, (String)"exceptionFqcn header cannot be null");
                    Assert.notNull((Object)this.exceptionCauseFqcn, (String)"exceptionCauseFqcn header cannot be null");
                    Assert.notNull((Object)this.keyExceptionMessage, (String)"keyExceptionMessage header cannot be null");
                    Assert.notNull((Object)this.exceptionMessage, (String)"exceptionMessage header cannot be null");
                    Assert.notNull((Object)this.keyExceptionStacktrace, (String)"keyExceptionStacktrace header cannot be null");
                    Assert.notNull((Object)this.exceptionStacktrace, (String)"exceptionStacktrace header cannot be null");
                    return new HeaderNames(Builder.this.original.build(), new org.springframework.kafka.listener.DeadLetterPublishingRecoverer$HeaderNames$ExceptionInfo(this.keyExceptionFqcn, this.exceptionFqcn, this.exceptionCauseFqcn, this.keyExceptionMessage, this.exceptionMessage, this.keyExceptionStacktrace, this.exceptionStacktrace));
                }
            }
        }

        public static enum HeadersToAdd {
            OFFSET,
            TS,
            TS_TYPE,
            TOPIC,
            PARTITION,
            GROUP,
            EXCEPTION,
            EX_CAUSE,
            EX_MSG,
            EX_STACKTRACE;

        }
    }

    public static interface ExceptionHeadersCreator {
        public void create(Headers var1, Exception var2, boolean var3, HeaderNames var4);
    }

    public static class SingleRecordHeader
    extends RecordHeader {
        public SingleRecordHeader(String key, byte[] value) {
            super(key, value);
        }

        public SingleRecordHeader(ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            super(keyBuffer, valueBuffer);
        }
    }
}

