/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.KafkaListenerErrorHandler;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.converter.ProjectingMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public class RecordMessagingMessageListenerAdapter<K, V>
extends MessagingMessageListenerAdapter<K, V>
implements AcknowledgingConsumerAwareMessageListener<K, V> {
    public RecordMessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, null);
    }

    public RecordMessagingMessageListenerAdapter(Object bean, Method method, @Nullable KafkaListenerErrorHandler errorHandler) {
        super(bean, method, errorHandler);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> record, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        Message<?> message = this.isConversionNeeded() ? this.toMessagingMessage(record, acknowledgment, consumer) : NULL_MESSAGE;
        if (this.logger.isDebugEnabled() && !(this.getMessageConverter() instanceof ProjectingMessageConverter)) {
            this.logger.debug((CharSequence)("Processing [" + message + "]"));
        }
        this.invoke(record, acknowledgment, consumer, message);
    }
}

