/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.lang.Nullable;

public abstract class AbstractConsumerSeekAware
implements ConsumerSeekAware {
    private final Map<Thread, ConsumerSeekAware.ConsumerSeekCallback> callbackForThread = new ConcurrentHashMap<Thread, ConsumerSeekAware.ConsumerSeekCallback>();
    private final Map<TopicPartition, ConsumerSeekAware.ConsumerSeekCallback> callbacks = new ConcurrentHashMap<TopicPartition, ConsumerSeekAware.ConsumerSeekCallback>();
    private final Map<ConsumerSeekAware.ConsumerSeekCallback, List<TopicPartition>> callbacksToTopic = new ConcurrentHashMap<ConsumerSeekAware.ConsumerSeekCallback, List<TopicPartition>>();

    @Override
    public void registerSeekCallback(ConsumerSeekAware.ConsumerSeekCallback callback) {
        this.callbackForThread.put(Thread.currentThread(), callback);
    }

    @Override
    public void onPartitionsAssigned(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        ConsumerSeekAware.ConsumerSeekCallback threadCallback = this.callbackForThread.get(Thread.currentThread());
        if (threadCallback != null) {
            assignments.keySet().forEach(tp -> {
                this.callbacks.put((TopicPartition)tp, threadCallback);
                this.callbacksToTopic.computeIfAbsent(threadCallback, key -> new LinkedList()).add(tp);
            });
        }
    }

    @Override
    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        partitions.forEach(tp -> {
            List<TopicPartition> topics;
            ConsumerSeekAware.ConsumerSeekCallback removed = this.callbacks.remove(tp);
            if (removed != null && (topics = this.callbacksToTopic.get(removed)) != null) {
                topics.remove(tp);
                if (topics.size() == 0) {
                    this.callbacksToTopic.remove(removed);
                }
            }
        });
    }

    @Override
    public void unregisterSeekCallback() {
        this.callbackForThread.remove(Thread.currentThread());
    }

    @Nullable
    protected ConsumerSeekAware.ConsumerSeekCallback getSeekCallbackFor(TopicPartition topicPartition) {
        return this.callbacks.get(topicPartition);
    }

    protected Map<TopicPartition, ConsumerSeekAware.ConsumerSeekCallback> getSeekCallbacks() {
        return Collections.unmodifiableMap(this.callbacks);
    }

    protected Map<ConsumerSeekAware.ConsumerSeekCallback, List<TopicPartition>> getCallbacksAndTopics() {
        return Collections.unmodifiableMap(this.callbacksToTopic);
    }

    public void seekToBeginning() {
        this.getCallbacksAndTopics().forEach((cb, topics) -> cb.seekToBeginning((Collection<TopicPartition>)topics));
    }

    public void seekToEnd() {
        this.getCallbacksAndTopics().forEach((cb, topics) -> cb.seekToEnd((Collection<TopicPartition>)topics));
    }

    public void seekToTimestamp(long time) {
        this.getCallbacksAndTopics().forEach((cb, topics) -> cb.seekToTimestamp((Collection<TopicPartition>)topics, time));
    }
}

