/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.math.BigInteger;
import java.time.Instant;
import java.util.function.Consumer;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.listener.DeadLetterPublishingRecoverer;
import org.springframework.kafka.listener.SeekUtils;
import org.springframework.kafka.listener.TimestampedException;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;

public class DeadLetterPublishingRecovererFactory {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(DeadLetterPublishingRecovererFactory.class));
    private final DestinationTopicResolver destinationTopicResolver;
    private Consumer<DeadLetterPublishingRecoverer> recovererCustomizer = recoverer -> {};

    public DeadLetterPublishingRecovererFactory(DestinationTopicResolver destinationTopicResolver) {
        this.destinationTopicResolver = destinationTopicResolver;
    }

    public DeadLetterPublishingRecoverer create() {
        DeadLetterPublishingRecoverer recoverer = new DeadLetterPublishingRecoverer(this::resolveTemplate, false, this::resolveDestination){

            @Override
            protected DeadLetterPublishingRecoverer.HeaderNames getHeaderNames() {
                return DeadLetterPublishingRecoverer.HeaderNames.Builder.original().offsetHeader("kafka_original-offset").timestampHeader("kafka_original-timestamp").timestampTypeHeader("kafka_original-timestamp-type").topicHeader("kafka_original-topic").partitionHeader("kafka_original-partition").exception().keyExceptionFqcn("kafka_key-exception-fqcn").exceptionFqcn("kafka_exception-fqcn").keyExceptionMessage("kafka_key-exception-message").exceptionMessage("kafka_exception-message").keyExceptionStacktrace("kafka_key-exception-stacktrace").exceptionStacktrace("kafka_exception-stacktrace").build();
            }
        };
        recoverer.setHeadersFunction((consumerRecord, e) -> this.addHeaders((ConsumerRecord<?, ?>)consumerRecord, (Exception)e, this.getAttempts((ConsumerRecord<?, ?>)consumerRecord)));
        recoverer.setFailIfSendResultIsError(true);
        recoverer.setReplaceOriginalHeaders(false);
        recoverer.setThrowIfNoDestinationReturned(false);
        this.recovererCustomizer.accept(recoverer);
        return recoverer;
    }

    private KafkaOperations<?, ?> resolveTemplate(ProducerRecord<?, ?> outRecord) {
        return this.destinationTopicResolver.getDestinationTopicByName(outRecord.topic()).getKafkaOperations();
    }

    public void setDeadLetterPublishingRecovererCustomizer(Consumer<DeadLetterPublishingRecoverer> customizer) {
        this.recovererCustomizer = customizer;
    }

    private TopicPartition resolveDestination(ConsumerRecord<?, ?> cr, Exception e) {
        if (SeekUtils.isBackoffException(e)) {
            throw (NestedRuntimeException)e;
        }
        DestinationTopic nextDestination = this.destinationTopicResolver.resolveDestinationTopic(cr.topic(), this.getAttempts(cr), e, this.getOriginalTimestampHeaderLong(cr));
        LOGGER.debug(() -> "Resolved topic: " + (nextDestination.isNoOpsTopic() ? "none" : nextDestination.getDestinationName()));
        return nextDestination.isNoOpsTopic() ? null : this.resolveTopicPartition(cr, nextDestination);
    }

    protected TopicPartition resolveTopicPartition(ConsumerRecord<?, ?> cr, DestinationTopic nextDestination) {
        return new TopicPartition(nextDestination.getDestinationName(), cr.partition());
    }

    private int getAttempts(ConsumerRecord<?, ?> consumerRecord) {
        Header header = consumerRecord.headers().lastHeader("retry_topic-attempts");
        return header != null ? header.value()[0] : 1;
    }

    private Headers addHeaders(ConsumerRecord<?, ?> consumerRecord, Exception e, int attempts) {
        RecordHeaders headers = new RecordHeaders();
        byte[] originalTimestampHeader = this.getOriginalTimestampHeaderBytes(consumerRecord);
        headers.add("retry_topic-original-timestamp", originalTimestampHeader);
        headers.add("retry_topic-attempts", BigInteger.valueOf(attempts + 1).toByteArray());
        headers.add("retry_topic-backoff-timestamp", BigInteger.valueOf(this.getNextExecutionTimestamp(consumerRecord, e, originalTimestampHeader)).toByteArray());
        return headers;
    }

    private long getNextExecutionTimestamp(ConsumerRecord<?, ?> consumerRecord, Exception e, byte[] originalTimestampHeader) {
        long originalTimestamp = new BigInteger(originalTimestampHeader).longValue();
        long failureTimestamp = this.getFailureTimestamp(e);
        long nextExecutionTimestamp = failureTimestamp + this.destinationTopicResolver.resolveDestinationTopic(consumerRecord.topic(), this.getAttempts(consumerRecord), e, originalTimestamp).getDestinationDelay();
        LOGGER.debug(() -> String.format("FailureTimestamp: %s, Original timestamp: %s, nextExecutionTimestamp: %s", failureTimestamp, originalTimestamp, nextExecutionTimestamp));
        return nextExecutionTimestamp;
    }

    private long getFailureTimestamp(Exception e) {
        return e instanceof NestedRuntimeException && ((NestedRuntimeException)e).contains(TimestampedException.class) ? this.getTimestampedException(e).getTimestamp() : Instant.now().toEpochMilli();
    }

    private TimestampedException getTimestampedException(Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Provided exception does not contain a " + TimestampedException.class.getSimpleName() + " cause.");
        }
        return e.getClass().isAssignableFrom(TimestampedException.class) ? (TimestampedException)((Object)e) : this.getTimestampedException(e.getCause());
    }

    private byte[] getOriginalTimestampHeaderBytes(ConsumerRecord<?, ?> consumerRecord) {
        Header currentOriginalTimestampHeader = this.getOriginaTimeStampHeader(consumerRecord);
        return currentOriginalTimestampHeader != null ? currentOriginalTimestampHeader.value() : BigInteger.valueOf(consumerRecord.timestamp()).toByteArray();
    }

    private long getOriginalTimestampHeaderLong(ConsumerRecord<?, ?> consumerRecord) {
        Header currentOriginalTimestampHeader = this.getOriginaTimeStampHeader(consumerRecord);
        return currentOriginalTimestampHeader != null ? new BigInteger(currentOriginalTimestampHeader.value()).longValue() : consumerRecord.timestamp();
    }

    private Header getOriginaTimeStampHeader(ConsumerRecord<?, ?> consumerRecord) {
        return consumerRecord.headers().lastHeader("retry_topic-original-timestamp");
    }
}

