/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.utils.Bytes;
import org.springframework.kafka.support.JacksonUtils;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class JsonMessageConverter
extends MessagingMessageConverter {
    private static final JavaType OBJECT = TypeFactory.defaultInstance().constructType(Object.class);
    private final ObjectMapper objectMapper;
    private Jackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();

    public JsonMessageConverter() {
        this(JacksonUtils.enhancedObjectMapper());
    }

    public JsonMessageConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
    }

    public Jackson2JavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(Jackson2JavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    protected Headers initialRecordHeaders(Message<?> message) {
        RecordHeaders headers = new RecordHeaders();
        this.typeMapper.fromClass(message.getPayload().getClass(), (Headers)headers);
        return headers;
    }

    @Override
    protected Object convertPayload(Message<?> message) {
        throw new UnsupportedOperationException("Select a subclass that creates a ProducerRecord value corresponding to the configured Kafka Serializer");
    }

    @Override
    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        Object value = record.value();
        if (record.value() == null) {
            return KafkaNull.INSTANCE;
        }
        JavaType javaType = this.determineJavaType(record, type);
        if (value instanceof Bytes) {
            value = ((Bytes)value).get();
        }
        if (value instanceof String) {
            try {
                return this.objectMapper.readValue((String)value, javaType);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to convert from JSON", record, (Throwable)e);
            }
        }
        if (value instanceof byte[]) {
            try {
                return this.objectMapper.readValue((byte[])value, javaType);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to convert from JSON", record, (Throwable)e);
            }
        }
        throw new IllegalStateException("Only String, Bytes, or byte[] supported");
    }

    private JavaType determineJavaType(ConsumerRecord<?, ?> record, Type type) {
        JavaType javaType;
        JavaType javaType2 = javaType = this.typeMapper.getTypePrecedence().equals((Object)Jackson2JavaTypeMapper.TypePrecedence.INFERRED) && type != null ? TypeFactory.defaultInstance().constructType(type) : this.typeMapper.toJavaType(record.headers());
        if (javaType == null) {
            javaType = type != null ? TypeFactory.defaultInstance().constructType(type) : OBJECT;
        }
        return javaType;
    }
}

