/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.ContainerAwareErrorHandler;
import org.springframework.kafka.listener.FailedRecordProcessor;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.SeekUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.backoff.BackOff;

public class SeekToCurrentErrorHandler
extends FailedRecordProcessor
implements ContainerAwareErrorHandler {
    private boolean ackAfterHandle = true;

    public SeekToCurrentErrorHandler() {
        this(null, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    public SeekToCurrentErrorHandler(BackOff backOff) {
        this(null, backOff);
    }

    public SeekToCurrentErrorHandler(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    public SeekToCurrentErrorHandler(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        super(recoverer, backOff);
    }

    @Override
    public void setCommitRecovered(boolean commitRecovered) {
        super.setCommitRecovered(commitRecovered);
    }

    @Override
    public boolean isAckAfterHandle() {
        return this.ackAfterHandle;
    }

    @Override
    public void setAckAfterHandle(boolean ackAfterHandle) {
        this.ackAfterHandle = ackAfterHandle;
    }

    @Override
    public void handle(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        SeekUtils.seekOrRecover(thrownException, records, consumer, container, this.isCommitRecovered(), this.getRecoveryStrategy(records, thrownException), this.logger, this.getLogLevel());
    }
}

