/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaResourceHolder;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.core.ProducerFactoryUtils;
import org.springframework.kafka.event.ConsumerPausedEvent;
import org.springframework.kafka.event.ConsumerResumedEvent;
import org.springframework.kafka.event.ConsumerStoppedEvent;
import org.springframework.kafka.event.ConsumerStoppingEvent;
import org.springframework.kafka.event.ListenerContainerIdleEvent;
import org.springframework.kafka.event.NonResponsiveConsumerEvent;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.BatchLoggingErrorHandler;
import org.springframework.kafka.listener.BatchMessageListener;
import org.springframework.kafka.listener.ConsumerAwareRebalanceListener;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.listener.ContainerAwareBatchErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.DelegatingMessageListener;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.GenericErrorHandler;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.ListenerType;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.listener.LoggingCommitCallback;
import org.springframework.kafka.listener.LoggingErrorHandler;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.kafka.listener.RemainingRecordsErrorHandler;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.LogIfLevelEnabled;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.kafka.support.TransactionSupport;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer2;
import org.springframework.kafka.transaction.KafkaAwareTransactionManager;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class KafkaMessageListenerContainer<K, V>
extends AbstractMessageListenerContainer<K, V> {
    private static final String UNUSED = "unused";
    private static final int DEFAULT_ACK_TIME = 5000;
    private final AbstractMessageListenerContainer<K, V> container;
    private final TopicPartitionInitialOffset[] topicPartitions;
    private volatile ListenerConsumer listenerConsumer;
    private volatile ListenableFuture<?> listenerConsumerFuture;
    private String clientIdSuffix;
    private Runnable emergencyStop = () -> this.stop(() -> {});

    public KafkaMessageListenerContainer(ConsumerFactory<? super K, ? super V> consumerFactory, ContainerProperties containerProperties) {
        this(null, consumerFactory, containerProperties, (TopicPartitionInitialOffset[])null);
    }

    public KafkaMessageListenerContainer(ConsumerFactory<? super K, ? super V> consumerFactory, ContainerProperties containerProperties, TopicPartitionInitialOffset ... topicPartitions) {
        this(null, consumerFactory, containerProperties, topicPartitions);
    }

    KafkaMessageListenerContainer(AbstractMessageListenerContainer<K, V> container, ConsumerFactory<? super K, ? super V> consumerFactory, ContainerProperties containerProperties) {
        this(container, consumerFactory, containerProperties, (TopicPartitionInitialOffset[])null);
    }

    KafkaMessageListenerContainer(AbstractMessageListenerContainer<K, V> container, ConsumerFactory<? super K, ? super V> consumerFactory, ContainerProperties containerProperties, TopicPartitionInitialOffset ... topicPartitions) {
        super(consumerFactory, containerProperties);
        Assert.notNull(consumerFactory, (String)"A ConsumerFactory must be provided");
        this.container = container == null ? this : container;
        this.topicPartitions = topicPartitions != null ? Arrays.copyOf(topicPartitions, topicPartitions.length) : containerProperties.getTopicPartitions();
    }

    public void setEmergencyStop(Runnable emergencyStop) {
        Assert.notNull((Object)emergencyStop, (String)"'emergencyStop' cannot be null");
        this.emergencyStop = emergencyStop;
    }

    public void setClientIdSuffix(String clientIdSuffix) {
        this.clientIdSuffix = clientIdSuffix;
    }

    @Override
    @Nullable
    public Collection<TopicPartition> getAssignedPartitions() {
        ListenerConsumer partitionsListenerConsumer = this.listenerConsumer;
        if (partitionsListenerConsumer != null) {
            if (partitionsListenerConsumer.definedPartitions != null) {
                return Collections.unmodifiableCollection(partitionsListenerConsumer.definedPartitions.keySet());
            }
            if (partitionsListenerConsumer.assignedPartitions != null) {
                return Collections.unmodifiableCollection(partitionsListenerConsumer.assignedPartitions);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isContainerPaused() {
        return this.isPaused() && this.listenerConsumer.consumerPaused;
    }

    @Override
    public Map<String, Map<MetricName, ? extends Metric>> metrics() {
        Map metrics;
        Iterator metricIterator;
        ListenerConsumer listenerConsumerForMetrics = this.listenerConsumer;
        if (listenerConsumerForMetrics != null && (metricIterator = (metrics = listenerConsumerForMetrics.consumer.metrics()).keySet().iterator()).hasNext()) {
            String clientId = (String)((MetricName)metricIterator.next()).tags().get("client-id");
            return Collections.singletonMap(clientId, metrics);
        }
        return Collections.emptyMap();
    }

    @Override
    protected void doStart() {
        if (this.isRunning()) {
            return;
        }
        if (this.clientIdSuffix == null) {
            this.checkTopics();
        }
        ContainerProperties containerProperties = this.getContainerProperties();
        this.checkAckMode(containerProperties);
        Object messageListener = containerProperties.getMessageListener();
        Assert.state((messageListener != null ? 1 : 0) != 0, (String)"A MessageListener is required");
        if (containerProperties.getConsumerTaskExecutor() == null) {
            SimpleAsyncTaskExecutor consumerExecutor = new SimpleAsyncTaskExecutor((this.getBeanName() == null ? "" : this.getBeanName()) + "-C-");
            containerProperties.setConsumerTaskExecutor((AsyncListenableTaskExecutor)consumerExecutor);
        }
        Assert.state((boolean)(messageListener instanceof GenericMessageListener), (String)"Listener must be a GenericListener");
        GenericMessageListener listener = (GenericMessageListener)messageListener;
        ListenerType listenerType = this.deteremineListenerType(listener);
        this.listenerConsumer = new ListenerConsumer(listener, listenerType);
        this.setRunning(true);
        this.listenerConsumerFuture = containerProperties.getConsumerTaskExecutor().submitListenable((Runnable)((Object)this.listenerConsumer));
    }

    private void checkAckMode(ContainerProperties containerProperties) {
        if (!this.consumerFactory.isAutoCommit()) {
            ContainerProperties.AckMode ackMode = containerProperties.getAckMode();
            if (ackMode.equals((Object)ContainerProperties.AckMode.COUNT) || ackMode.equals((Object)ContainerProperties.AckMode.COUNT_TIME)) {
                Assert.state((containerProperties.getAckCount() > 0 ? 1 : 0) != 0, (String)"'ackCount' must be > 0");
            }
            if ((ackMode.equals((Object)ContainerProperties.AckMode.TIME) || ackMode.equals((Object)ContainerProperties.AckMode.COUNT_TIME)) && containerProperties.getAckTime() == 0L) {
                containerProperties.setAckTime(5000L);
            }
        }
    }

    private ListenerType deteremineListenerType(GenericMessageListener<?> listener) {
        ListenerType listenerType = ListenerUtils.determineListenerType(listener);
        if (listener instanceof DelegatingMessageListener) {
            GenericMessageListener<Object> delegating = listener;
            while (delegating instanceof DelegatingMessageListener) {
                delegating = ((DelegatingMessageListener)((Object)delegating)).getDelegate();
            }
            listenerType = ListenerUtils.determineListenerType(delegating);
        }
        return listenerType;
    }

    @Override
    protected void doStop(Runnable callback) {
        if (this.isRunning()) {
            this.listenerConsumerFuture.addCallback((ListenableFutureCallback)new StopCallback(callback));
            this.setRunning(false);
            this.listenerConsumer.consumer.wakeup();
        }
    }

    private void publishIdleContainerEvent(long idleTime, Consumer<?, ?> consumer, boolean paused) {
        if (this.getApplicationEventPublisher() != null) {
            this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new ListenerContainerIdleEvent(this, this.container, idleTime, this.getBeanName(), this.getAssignedPartitions(), consumer, paused));
        }
    }

    private void publishNonResponsiveConsumerEvent(long timeSinceLastPoll, Consumer<?, ?> consumer) {
        if (this.getApplicationEventPublisher() != null) {
            this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new NonResponsiveConsumerEvent(this, this.container, timeSinceLastPoll, this.getBeanName(), this.getAssignedPartitions(), consumer));
        }
    }

    private void publishConsumerPausedEvent(Collection<TopicPartition> partitions) {
        if (this.getApplicationEventPublisher() != null) {
            this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new ConsumerPausedEvent(this, this.container, Collections.unmodifiableCollection(partitions)));
        }
    }

    private void publishConsumerResumedEvent(Collection<TopicPartition> partitions) {
        if (this.getApplicationEventPublisher() != null) {
            this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new ConsumerResumedEvent(this, this.container, Collections.unmodifiableCollection(partitions)));
        }
    }

    private void publishConsumerStoppingEvent(Consumer<?, ?> consumer) {
        try {
            if (this.getApplicationEventPublisher() != null) {
                this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new ConsumerStoppingEvent(this, this.container, consumer, this.getAssignedPartitions()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to publish consumer stopping event", (Throwable)e);
        }
    }

    private void publishConsumerStoppedEvent() {
        if (this.getApplicationEventPublisher() != null) {
            this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new ConsumerStoppedEvent(this, this.container));
        }
    }

    @Override
    protected AbstractMessageListenerContainer<?, ?> parentOrThis() {
        return this.container;
    }

    public String toString() {
        return "KafkaMessageListenerContainer [id=" + this.getBeanName() + (this.clientIdSuffix != null ? ", clientIndex=" + this.clientIdSuffix : "") + ", topicPartitions=" + (this.getAssignedPartitions() == null ? "none assigned" : this.getAssignedPartitions()) + "]";
    }

    private class StopCallback
    implements ListenableFutureCallback<Object> {
        private final Runnable callback;

        StopCallback(Runnable callback) {
            this.callback = callback;
        }

        public void onFailure(Throwable e) {
            KafkaMessageListenerContainer.this.logger.error((Object)"Error while stopping the container: ", e);
            if (this.callback != null) {
                this.callback.run();
            }
        }

        public void onSuccess(Object result) {
            if (KafkaMessageListenerContainer.this.logger.isDebugEnabled()) {
                KafkaMessageListenerContainer.this.logger.debug((Object)(KafkaMessageListenerContainer.this + " stopped normally"));
            }
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }

    private static final class OffsetMetadata {
        private final Long offset;
        private final boolean relativeToCurrent;
        private final TopicPartitionInitialOffset.SeekPosition seekPosition;

        OffsetMetadata(Long offset, boolean relativeToCurrent, TopicPartitionInitialOffset.SeekPosition seekPosition) {
            this.offset = offset;
            this.relativeToCurrent = relativeToCurrent;
            this.seekPosition = seekPosition;
        }
    }

    private final class ListenerConsumer
    implements SchedulingAwareRunnable,
    ConsumerSeekAware.ConsumerSeekCallback {
        private static final String UNCHECKED = "unchecked";
        private static final String RAWTYPES = "rawtypes";
        private static final String RAW_TYPES = "rawtypes";
        private final Log logger = LogFactory.getLog(ListenerConsumer.class);
        private final ContainerProperties containerProperties = KafkaMessageListenerContainer.this.getContainerProperties();
        private final OffsetCommitCallback commitCallback = this.containerProperties.getCommitCallback() != null ? this.containerProperties.getCommitCallback() : new LoggingCommitCallback();
        private final Consumer<K, V> consumer;
        private final Map<String, Map<Integer, Long>> offsets = new HashMap<String, Map<Integer, Long>>();
        private final GenericMessageListener<?> genericListener;
        private final MessageListener<K, V> listener;
        private final BatchMessageListener<K, V> batchListener;
        private final ListenerType listenerType;
        private final boolean isConsumerAwareListener;
        private final boolean isBatchListener;
        private final boolean wantsFullRecords;
        private final boolean autoCommit;
        private final boolean isManualAck;
        private final boolean isCountAck;
        private final boolean isTimeOnlyAck;
        private final boolean isManualImmediateAck;
        private final boolean isAnyManualAck;
        private final boolean isRecordAck;
        private final BlockingQueue<ConsumerRecord<K, V>> acks;
        private final BlockingQueue<TopicPartitionInitialOffset> seeks;
        private final ErrorHandler errorHandler;
        private final BatchErrorHandler batchErrorHandler;
        private final PlatformTransactionManager transactionManager;
        private final KafkaAwareTransactionManager kafkaTxManager;
        private final TransactionTemplate transactionTemplate;
        private final String consumerGroupId;
        private final TaskScheduler taskScheduler;
        private final ScheduledFuture<?> monitorTask;
        private final LogIfLevelEnabled commitLogger;
        private final Duration pollTimeout;
        private final boolean checkNullKeyForExceptions;
        private final boolean checkNullValueForExceptions;
        private final RecordInterceptor<K, V> recordInterceptor;
        private Map<TopicPartition, OffsetMetadata> definedPartitions;
        private volatile Collection<TopicPartition> assignedPartitions;
        private volatile Thread consumerThread;
        private int count;
        private long last;
        private boolean fatalError;
        private boolean taskSchedulerExplicitlySet;
        private boolean consumerPaused;
        private long lastReceive;
        private long lastAlertAt;
        private volatile long lastPoll;

        ListenerConsumer(GenericMessageListener<?> listener, ListenerType listenerType) {
            this.autoCommit = KafkaMessageListenerContainer.this.consumerFactory.isAutoCommit();
            this.isManualAck = this.containerProperties.getAckMode().equals((Object)ContainerProperties.AckMode.MANUAL);
            this.isCountAck = this.containerProperties.getAckMode().equals((Object)ContainerProperties.AckMode.COUNT) || this.containerProperties.getAckMode().equals((Object)ContainerProperties.AckMode.COUNT_TIME);
            this.isTimeOnlyAck = this.containerProperties.getAckMode().equals((Object)ContainerProperties.AckMode.TIME);
            this.isManualImmediateAck = this.containerProperties.getAckMode().equals((Object)ContainerProperties.AckMode.MANUAL_IMMEDIATE);
            this.isAnyManualAck = this.isManualAck || this.isManualImmediateAck;
            this.isRecordAck = this.containerProperties.getAckMode().equals((Object)ContainerProperties.AckMode.RECORD);
            this.acks = new LinkedBlockingQueue();
            this.seeks = new LinkedBlockingQueue<TopicPartitionInitialOffset>();
            this.transactionManager = this.containerProperties.getTransactionManager();
            this.kafkaTxManager = this.transactionManager instanceof KafkaAwareTransactionManager ? (KafkaAwareTransactionManager)this.transactionManager : null;
            this.consumerGroupId = KafkaMessageListenerContainer.this.getGroupId();
            this.commitLogger = new LogIfLevelEnabled(this.logger, this.containerProperties.getCommitLogLevel());
            this.pollTimeout = Duration.ofMillis(this.containerProperties.getPollTimeout());
            this.recordInterceptor = KafkaMessageListenerContainer.this.getRecordInterceptor();
            this.last = System.currentTimeMillis();
            this.lastAlertAt = this.lastReceive = System.currentTimeMillis();
            this.lastPoll = System.currentTimeMillis();
            Assert.state((!this.isAnyManualAck || !this.autoCommit ? 1 : 0) != 0, () -> "Consumer cannot be configured for auto commit for ackMode " + (Object)((Object)this.containerProperties.getAckMode()));
            this.consumer = KafkaMessageListenerContainer.this.consumerFactory.createConsumer(this.consumerGroupId, this.containerProperties.getClientId(), KafkaMessageListenerContainer.this.clientIdSuffix, this.containerProperties.getConsumerProperties());
            this.transactionTemplate = this.transactionManager != null ? new TransactionTemplate(this.transactionManager) : null;
            this.subscribeOrAssignTopics(this.consumer);
            GenericErrorHandler<?> errHandler = KafkaMessageListenerContainer.this.getGenericErrorHandler();
            this.genericListener = listener;
            if (listener instanceof BatchMessageListener) {
                this.listener = null;
                this.batchListener = (BatchMessageListener)listener;
                this.isBatchListener = true;
                this.wantsFullRecords = this.batchListener.wantsPollResult();
            } else if (listener instanceof MessageListener) {
                this.listener = (MessageListener)listener;
                this.batchListener = null;
                this.isBatchListener = false;
                this.wantsFullRecords = false;
            } else {
                throw new IllegalArgumentException("Listener must be one of 'MessageListener', 'BatchMessageListener', or the variants that are consumer aware and/or Acknowledging not " + listener.getClass().getName());
            }
            this.listenerType = listenerType;
            boolean bl = this.isConsumerAwareListener = listenerType.equals((Object)ListenerType.ACKNOWLEDGING_CONSUMER_AWARE) || listenerType.equals((Object)ListenerType.CONSUMER_AWARE);
            if (this.isBatchListener) {
                this.validateErrorHandler(true);
                this.errorHandler = new LoggingErrorHandler();
                this.batchErrorHandler = this.determineBatchErrorHandler(errHandler);
            } else {
                this.validateErrorHandler(false);
                this.errorHandler = this.determineErrorHandler(errHandler);
                this.batchErrorHandler = new BatchLoggingErrorHandler();
            }
            Assert.state((!this.isBatchListener || !this.isRecordAck ? 1 : 0) != 0, (String)"Cannot use AckMode.RECORD with a batch listener");
            if (this.containerProperties.getScheduler() != null) {
                this.taskScheduler = this.containerProperties.getScheduler();
                this.taskSchedulerExplicitlySet = true;
            } else {
                ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
                threadPoolTaskScheduler.initialize();
                this.taskScheduler = threadPoolTaskScheduler;
            }
            this.monitorTask = this.taskScheduler.scheduleAtFixedRate(this::checkConsumer, (long)(this.containerProperties.getMonitorInterval() * 1000));
            if (this.containerProperties.isLogContainerConfig()) {
                this.logger.info((Object)this);
            }
            Map<String, Object> props = KafkaMessageListenerContainer.this.consumerFactory.getConfigurationProperties();
            this.checkNullKeyForExceptions = this.checkDeserializer(this.findDeserializerClass(props, false));
            this.checkNullValueForExceptions = this.checkDeserializer(this.findDeserializerClass(props, true));
        }

        private Object findDeserializerClass(Map<String, Object> props, boolean isValue) {
            Object configuredDeserializer;
            Object object = configuredDeserializer = isValue ? KafkaMessageListenerContainer.this.consumerFactory.getValueDeserializer() : KafkaMessageListenerContainer.this.consumerFactory.getKeyDeserializer();
            if (configuredDeserializer == null) {
                return props.get(isValue ? "value.deserializer" : "key.deserializer");
            }
            return configuredDeserializer.getClass();
        }

        private void subscribeOrAssignTopics(Consumer<? super K, ? super V> subscribingConsumer) {
            if (KafkaMessageListenerContainer.this.topicPartitions == null) {
                ListenerConsumerRebalanceListener rebalanceListener = new ListenerConsumerRebalanceListener();
                if (this.containerProperties.getTopicPattern() != null) {
                    subscribingConsumer.subscribe(this.containerProperties.getTopicPattern(), (ConsumerRebalanceListener)rebalanceListener);
                } else {
                    subscribingConsumer.subscribe(Arrays.asList(this.containerProperties.getTopics()), (ConsumerRebalanceListener)rebalanceListener);
                }
            } else {
                List<TopicPartitionInitialOffset> topicPartitionsToAssign = Arrays.asList(KafkaMessageListenerContainer.this.topicPartitions);
                this.definedPartitions = new HashMap<TopicPartition, OffsetMetadata>(topicPartitionsToAssign.size());
                for (TopicPartitionInitialOffset topicPartition : topicPartitionsToAssign) {
                    this.definedPartitions.put(topicPartition.topicPartition(), new OffsetMetadata(topicPartition.initialOffset(), topicPartition.isRelativeToCurrent(), topicPartition.getPosition()));
                }
                subscribingConsumer.assign(new ArrayList<TopicPartition>(this.definedPartitions.keySet()));
            }
        }

        private boolean checkDeserializer(Object deser) {
            return deser instanceof Class ? ErrorHandlingDeserializer2.class.isAssignableFrom((Class)deser) : deser instanceof String && deser.equals(ErrorHandlingDeserializer2.class.getName());
        }

        protected void checkConsumer() {
            long timeSinceLastPoll = System.currentTimeMillis() - this.lastPoll;
            if ((float)timeSinceLastPoll / (float)this.containerProperties.getPollTimeout() > this.containerProperties.getNoPollThreshold()) {
                KafkaMessageListenerContainer.this.publishNonResponsiveConsumerEvent(timeSinceLastPoll, this.consumer);
            }
        }

        protected BatchErrorHandler determineBatchErrorHandler(GenericErrorHandler<?> errHandler) {
            return errHandler != null ? (BatchErrorHandler)errHandler : (this.transactionManager != null ? null : new BatchLoggingErrorHandler());
        }

        protected ErrorHandler determineErrorHandler(GenericErrorHandler<?> errHandler) {
            return errHandler != null ? (ErrorHandler)errHandler : (this.transactionManager != null ? null : new LoggingErrorHandler());
        }

        private void seekPartitions(Collection<TopicPartition> partitions, boolean idle) {
            HashMap<TopicPartition, Long> current = new HashMap<TopicPartition, Long>();
            for (TopicPartition topicPartition : partitions) {
                current.put(topicPartition, this.consumer.position(topicPartition));
            }
            ConsumerSeekAware.ConsumerSeekCallback callback = new ConsumerSeekAware.ConsumerSeekCallback(){

                @Override
                public void seek(String topic, int partition, long offset) {
                    ListenerConsumer.this.consumer.seek(new TopicPartition(topic, partition), offset);
                }

                @Override
                public void seekToBeginning(String topic, int partition) {
                    ListenerConsumer.this.consumer.seekToBeginning(Collections.singletonList(new TopicPartition(topic, partition)));
                }

                @Override
                public void seekToEnd(String topic, int partition) {
                    ListenerConsumer.this.consumer.seekToEnd(Collections.singletonList(new TopicPartition(topic, partition)));
                }
            };
            if (idle) {
                ((ConsumerSeekAware)((Object)this.genericListener)).onIdleContainer(current, callback);
            } else {
                ((ConsumerSeekAware)((Object)this.genericListener)).onPartitionsAssigned(current, callback);
            }
        }

        private void validateErrorHandler(boolean batch) {
            GenericErrorHandler<?> errHandler = KafkaMessageListenerContainer.this.getGenericErrorHandler();
            if (this.errorHandler == null) {
                return;
            }
            Type[] genericInterfaces = errHandler.getClass().getGenericInterfaces();
            boolean ok = false;
            for (Type t : genericInterfaces) {
                if (t.equals(ErrorHandler.class)) {
                    ok = !batch;
                    break;
                }
                if (!t.equals(BatchErrorHandler.class)) continue;
                ok = batch;
                break;
            }
            Assert.state((boolean)ok, (String)("Error handler is not compatible with the message listener, expecting an instance of " + (batch ? "BatchErrorHandler" : "ErrorHandler") + " not " + errHandler.getClass().getName()));
        }

        public boolean isLongLived() {
            return true;
        }

        public void run() {
            this.consumerThread = Thread.currentThread();
            if (this.genericListener instanceof ConsumerSeekAware) {
                ((ConsumerSeekAware)((Object)this.genericListener)).registerSeekCallback(this);
            }
            if (this.transactionManager != null) {
                ProducerFactoryUtils.setConsumerGroupId(this.consumerGroupId);
            }
            this.count = 0;
            this.last = System.currentTimeMillis();
            this.initAsignedPartitions();
            while (KafkaMessageListenerContainer.this.isRunning()) {
                try {
                    this.pollAndInvoke();
                }
                catch (WakeupException wakeupException) {
                }
                catch (NoOffsetForPartitionException nofpe) {
                    this.fatalError = true;
                    this.logger.error((Object)"No offset and no reset policy", (Throwable)nofpe);
                    break;
                }
                catch (Exception e) {
                    this.handleConsumerException(e);
                }
                catch (Error e) {
                    Runnable runnable = KafkaMessageListenerContainer.this.emergencyStop;
                    if (runnable != null) {
                        runnable.run();
                    }
                    this.logger.error((Object)"Stopping container due to an Error", (Throwable)e);
                    this.wrapUp();
                    throw e;
                }
            }
            this.wrapUp();
        }

        private void initAsignedPartitions() {
            if (KafkaMessageListenerContainer.this.isRunning() && this.definedPartitions != null) {
                try {
                    this.initPartitionsIfNeeded();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to set initial offsets", (Throwable)e);
                }
            }
        }

        protected void pollAndInvoke() {
            if (!this.autoCommit && !this.isRecordAck) {
                this.processCommits();
            }
            this.processSeeks();
            this.checkPaused();
            ConsumerRecords records = this.consumer.poll(this.pollTimeout);
            this.lastPoll = System.currentTimeMillis();
            this.checkResumed();
            this.debugRecords(records);
            if (records != null && records.count() > 0) {
                if (this.containerProperties.getIdleEventInterval() != null) {
                    this.lastReceive = System.currentTimeMillis();
                }
                this.invokeListener(records);
            } else {
                this.checkIdle();
            }
        }

        private void debugRecords(ConsumerRecords<K, V> records) {
            if (records != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received: " + records.count() + " records"));
                if (records.count() > 0 && this.logger.isTraceEnabled()) {
                    this.logger.trace(records.partitions().stream().flatMap(p -> records.records(p).stream()).map(r -> r.topic() + "-" + r.partition() + "@" + r.offset()).collect(Collectors.toList()));
                }
            }
        }

        private void checkPaused() {
            if (!this.consumerPaused && KafkaMessageListenerContainer.this.isPaused()) {
                this.consumer.pause((Collection)this.consumer.assignment());
                this.consumerPaused = true;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Paused consumption from: " + this.consumer.paused()));
                }
                KafkaMessageListenerContainer.this.publishConsumerPausedEvent(this.consumer.assignment());
            }
        }

        private void checkResumed() {
            if (this.consumerPaused && !KafkaMessageListenerContainer.this.isPaused()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Resuming consumption from: " + this.consumer.paused()));
                }
                Set paused = this.consumer.paused();
                this.consumer.resume((Collection)paused);
                this.consumerPaused = false;
                KafkaMessageListenerContainer.this.publishConsumerResumedEvent(paused);
            }
        }

        private void checkIdle() {
            long now;
            if (this.containerProperties.getIdleEventInterval() != null && (now = System.currentTimeMillis()) > this.lastReceive + this.containerProperties.getIdleEventInterval() && now > this.lastAlertAt + this.containerProperties.getIdleEventInterval()) {
                Collection<TopicPartition> partitions;
                KafkaMessageListenerContainer.this.publishIdleContainerEvent(now - this.lastReceive, this.isConsumerAwareListener ? this.consumer : null, this.consumerPaused);
                this.lastAlertAt = now;
                if (this.genericListener instanceof ConsumerSeekAware && (partitions = KafkaMessageListenerContainer.this.getAssignedPartitions()) != null) {
                    this.seekPartitions(partitions, true);
                }
            }
        }

        public void wrapUp() {
            ProducerFactoryUtils.clearConsumerGroupId();
            KafkaMessageListenerContainer.this.publishConsumerStoppingEvent(this.consumer);
            if (!this.fatalError) {
                if (this.kafkaTxManager == null) {
                    this.commitPendingAcks();
                    try {
                        this.consumer.unsubscribe();
                    }
                    catch (WakeupException wakeupException) {}
                } else {
                    this.closeProducers(KafkaMessageListenerContainer.this.getAssignedPartitions());
                }
            } else {
                this.logger.error((Object)"No offset and no reset policy; stopping container");
                KafkaMessageListenerContainer.this.stop();
            }
            this.monitorTask.cancel(true);
            if (!this.taskSchedulerExplicitlySet) {
                ((ThreadPoolTaskScheduler)this.taskScheduler).destroy();
            }
            this.consumer.close();
            KafkaMessageListenerContainer.this.getAfterRollbackProcessor().clearThreadState();
            if (this.errorHandler != null) {
                this.errorHandler.clearThreadState();
            }
            this.logger.info((Object)"Consumer stopped");
            KafkaMessageListenerContainer.this.publishConsumerStoppedEvent();
        }

        protected void handleConsumerException(Exception e) {
            try {
                if (!this.isBatchListener && this.errorHandler != null) {
                    this.errorHandler.handle(e, Collections.emptyList(), this.consumer, KafkaMessageListenerContainer.this.container);
                } else if (this.isBatchListener && this.batchErrorHandler != null) {
                    this.batchErrorHandler.handle(e, new ConsumerRecords(Collections.emptyMap()), this.consumer, KafkaMessageListenerContainer.this);
                } else {
                    this.logger.error((Object)"Consumer exception", (Throwable)e);
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)"Consumer exception", (Throwable)ex);
            }
        }

        private void commitPendingAcks() {
            this.processCommits();
            if (this.offsets.size() > 0) {
                this.commitIfNecessary();
            }
        }

        private void handleAcks() {
            ConsumerRecord record = (ConsumerRecord)this.acks.poll();
            while (record != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Ack: " + record));
                }
                this.processAck(record);
                record = (ConsumerRecord)this.acks.poll();
            }
        }

        private void processAck(ConsumerRecord<K, V> record) {
            if (!Thread.currentThread().equals(this.consumerThread)) {
                try {
                    this.acks.put(record);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new KafkaException("Interrupted while storing ack", e);
                }
            } else if (this.isManualImmediateAck) {
                try {
                    this.ackImmediate(record);
                }
                catch (WakeupException wakeupException) {}
            } else {
                this.addOffset(record);
            }
        }

        private void ackImmediate(ConsumerRecord<K, V> record) {
            Map<TopicPartition, OffsetAndMetadata> commits = Collections.singletonMap(new TopicPartition(record.topic(), record.partition()), new OffsetAndMetadata(record.offset() + 1L));
            this.commitLogger.log(() -> "Committing: " + commits);
            if (this.containerProperties.isSyncCommits()) {
                this.consumer.commitSync(commits);
            } else {
                this.consumer.commitAsync(commits, this.commitCallback);
            }
        }

        private void invokeListener(ConsumerRecords<K, V> records) {
            if (this.isBatchListener) {
                this.invokeBatchListener(records);
            } else {
                this.invokeRecordListener(records);
            }
        }

        private void invokeBatchListener(ConsumerRecords<K, V> records) {
            List recordList = null;
            if (!this.wantsFullRecords) {
                recordList = this.createRecordList(records);
            }
            if (this.wantsFullRecords || recordList.size() > 0) {
                if (this.transactionTemplate != null) {
                    this.invokeBatchListenerInTx(records, recordList);
                } else {
                    this.doInvokeBatchListener(records, recordList, null);
                }
            }
        }

        private void invokeBatchListenerInTx(final ConsumerRecords<K, V> records, final List<ConsumerRecord<K, V>> recordList) {
            try {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    public void doInTransactionWithoutResult(TransactionStatus s) {
                        RuntimeException aborted;
                        Producer producer = null;
                        if (ListenerConsumer.this.kafkaTxManager != null) {
                            producer = ((KafkaResourceHolder)((Object)TransactionSynchronizationManager.getResource(ListenerConsumer.this.kafkaTxManager.getProducerFactory()))).getProducer();
                        }
                        if ((aborted = ListenerConsumer.this.doInvokeBatchListener(records, recordList, producer)) != null) {
                            throw aborted;
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"Transaction rolled back", (Throwable)e);
                final AfterRollbackProcessor afterRollbackProcessorToUse = KafkaMessageListenerContainer.this.getAfterRollbackProcessor();
                if (afterRollbackProcessorToUse.isProcessInTransaction() && this.transactionTemplate != null) {
                    this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            ListenerConsumer.this.batchAfterRollback(records, recordList, e, afterRollbackProcessorToUse);
                        }
                    });
                }
                this.batchAfterRollback(records, recordList, e, afterRollbackProcessorToUse);
            }
        }

        private void batchAfterRollback(ConsumerRecords<K, V> records, List<ConsumerRecord<K, V>> recordList, RuntimeException e, AfterRollbackProcessor<K, V> afterRollbackProcessorToUse) {
            if (recordList == null) {
                afterRollbackProcessorToUse.process(this.createRecordList(records), this.consumer, e, false);
            } else {
                afterRollbackProcessorToUse.process(recordList, this.consumer, e, false);
            }
        }

        private List<ConsumerRecord<K, V>> createRecordList(ConsumerRecords<K, V> records) {
            return StreamSupport.stream(records.spliterator(), false).collect(Collectors.toList());
        }

        private RuntimeException doInvokeBatchListener(ConsumerRecords<K, V> records, List<ConsumerRecord<K, V>> recordList, Producer producer) {
            try {
                this.invokeBatchOnMessage(records, recordList, producer);
            }
            catch (RuntimeException e) {
                if (this.containerProperties.isAckOnError() && !this.autoCommit && producer == null) {
                    this.acks.addAll(this.getHighestOffsetRecords(records));
                }
                if (this.batchErrorHandler == null) {
                    throw e;
                }
                try {
                    this.invokeBatchErrorHandler(records, producer, e);
                }
                catch (RuntimeException ee) {
                    this.logger.error((Object)"Error handler threw an exception", (Throwable)ee);
                    return ee;
                }
                catch (Error er) {
                    this.logger.error((Object)"Error handler threw an error", (Throwable)er);
                    throw er;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return null;
        }

        private void invokeBatchOnMessage(ConsumerRecords<K, V> records, List<ConsumerRecord<K, V>> recordList, Producer producer) throws InterruptedException {
            if (this.wantsFullRecords) {
                this.batchListener.onMessage(records, (Acknowledgment)(this.isAnyManualAck ? new ConsumerBatchAcknowledgment(records) : null), this.consumer);
            } else {
                this.doInvokeBatchOnMessage(records, recordList);
            }
            if (!this.isAnyManualAck && !this.autoCommit) {
                for (ConsumerRecord record : this.getHighestOffsetRecords(records)) {
                    this.acks.put(record);
                }
                if (producer != null) {
                    this.sendOffsetsToTransaction(producer);
                }
            }
        }

        private void doInvokeBatchOnMessage(ConsumerRecords<K, V> records, List<ConsumerRecord<K, V>> recordList) {
            switch (this.listenerType) {
                case ACKNOWLEDGING_CONSUMER_AWARE: {
                    this.batchListener.onMessage(recordList, (Acknowledgment)(this.isAnyManualAck ? new ConsumerBatchAcknowledgment(records) : null), this.consumer);
                    break;
                }
                case ACKNOWLEDGING: {
                    this.batchListener.onMessage(recordList, this.isAnyManualAck ? new ConsumerBatchAcknowledgment(records) : null);
                    break;
                }
                case CONSUMER_AWARE: {
                    this.batchListener.onMessage(recordList, this.consumer);
                    break;
                }
                case SIMPLE: {
                    this.batchListener.onMessage(recordList);
                }
            }
        }

        private void invokeBatchErrorHandler(ConsumerRecords<K, V> records, @Nullable Producer producer, RuntimeException e) {
            if (this.batchErrorHandler instanceof ContainerAwareBatchErrorHandler) {
                this.batchErrorHandler.handle(this.decorateException(e), records, this.consumer, KafkaMessageListenerContainer.this.container);
            } else {
                this.batchErrorHandler.handle(this.decorateException(e), records, this.consumer);
            }
            if (producer != null) {
                this.acks.addAll(this.getHighestOffsetRecords(records));
                this.sendOffsetsToTransaction(producer);
            }
        }

        private void invokeRecordListener(ConsumerRecords<K, V> records) {
            if (this.transactionTemplate != null) {
                this.invokeRecordListenerInTx(records);
            } else {
                this.doInvokeWithRecords(records);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeRecordListenerInTx(ConsumerRecords<K, V> records) {
            final Iterator iterator = records.iterator();
            while (iterator.hasNext()) {
                final ConsumerRecord record = (ConsumerRecord)iterator.next();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Processing " + record));
                }
                try {
                    TransactionSupport.setTransactionIdSuffix(this.zombieFenceTxIdSuffix(record.topic(), record.partition()));
                    this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        public void doInTransactionWithoutResult(TransactionStatus s) {
                            RuntimeException aborted;
                            Producer producer = null;
                            if (ListenerConsumer.this.kafkaTxManager != null) {
                                producer = ((KafkaResourceHolder)((Object)TransactionSynchronizationManager.getResource(ListenerConsumer.this.kafkaTxManager.getProducerFactory()))).getProducer();
                            }
                            if ((aborted = ListenerConsumer.this.doInvokeRecordListener(record, producer, iterator)) != null) {
                                throw aborted;
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)"Transaction rolled back", (Throwable)e);
                    this.recordAfterRollback(iterator, record, e);
                }
                finally {
                    TransactionSupport.clearTransactionIdSuffix();
                }
            }
        }

        private void recordAfterRollback(Iterator<ConsumerRecord<K, V>> iterator, ConsumerRecord<K, V> record, final RuntimeException e) {
            final ArrayList unprocessed = new ArrayList();
            unprocessed.add(record);
            while (iterator.hasNext()) {
                unprocessed.add(iterator.next());
            }
            final AfterRollbackProcessor afterRollbackProcessorToUse = KafkaMessageListenerContainer.this.getAfterRollbackProcessor();
            if (afterRollbackProcessorToUse.isProcessInTransaction() && this.transactionTemplate != null) {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        afterRollbackProcessorToUse.process(unprocessed, ListenerConsumer.this.consumer, e, true);
                    }
                });
            } else {
                afterRollbackProcessorToUse.process(unprocessed, this.consumer, e, true);
            }
        }

        private void doInvokeWithRecords(ConsumerRecords<K, V> records) {
            Iterator iterator = records.iterator();
            while (iterator.hasNext()) {
                ConsumerRecord record = (ConsumerRecord)iterator.next();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Processing " + record));
                }
                this.doInvokeRecordListener(record, null, iterator);
            }
        }

        private RuntimeException doInvokeRecordListener(ConsumerRecord<K, V> record, Producer producer, Iterator<ConsumerRecord<K, V>> iterator) {
            try {
                this.invokeOnMessage(record, producer);
            }
            catch (RuntimeException e) {
                if (this.containerProperties.isAckOnError() && !this.autoCommit && producer == null) {
                    this.ackCurrent(record);
                }
                if (this.errorHandler == null) {
                    throw e;
                }
                try {
                    this.invokeErrorHandler(record, producer, iterator, e);
                }
                catch (RuntimeException ee) {
                    this.logger.error((Object)"Error handler threw an exception", (Throwable)ee);
                    return ee;
                }
                catch (Error er) {
                    this.logger.error((Object)"Error handler threw an error", (Throwable)er);
                    throw er;
                }
            }
            return null;
        }

        private void invokeOnMessage(ConsumerRecord<K, V> record, @Nullable Producer producer) {
            if (record.value() instanceof DeserializationException) {
                throw (DeserializationException)((Object)record.value());
            }
            if (record.key() instanceof DeserializationException) {
                throw (DeserializationException)((Object)record.key());
            }
            if (record.value() == null && this.checkNullValueForExceptions) {
                this.checkDeser(record, "springDeserializerExceptionValue");
            }
            if (record.key() == null && this.checkNullKeyForExceptions) {
                this.checkDeser(record, "springDeserializerExceptionKey");
            }
            this.doInvokeOnMessage(record);
            this.ackCurrent(record, producer);
        }

        private void doInvokeOnMessage(ConsumerRecord<K, V> recordArg) {
            ConsumerRecord record = recordArg;
            if (this.recordInterceptor != null) {
                record = this.recordInterceptor.intercept(record);
            }
            if (record == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("RecordInterceptor returned null, skipping: " + recordArg));
                }
            } else {
                switch (this.listenerType) {
                    case ACKNOWLEDGING_CONSUMER_AWARE: {
                        this.listener.onMessage(record, this.isAnyManualAck ? new ConsumerAcknowledgment(record) : null, this.consumer);
                        break;
                    }
                    case CONSUMER_AWARE: {
                        this.listener.onMessage(record, this.consumer);
                        break;
                    }
                    case ACKNOWLEDGING: {
                        this.listener.onMessage(record, this.isAnyManualAck ? new ConsumerAcknowledgment(record) : null);
                        break;
                    }
                    case SIMPLE: {
                        this.listener.onMessage(record);
                    }
                }
            }
        }

        private void invokeErrorHandler(ConsumerRecord<K, V> record, @Nullable Producer producer, Iterator<ConsumerRecord<K, V>> iterator, RuntimeException e) {
            if (this.errorHandler instanceof RemainingRecordsErrorHandler) {
                if (producer == null) {
                    this.processCommits();
                }
                ArrayList records = new ArrayList();
                records.add(record);
                while (iterator.hasNext()) {
                    records.add(iterator.next());
                }
                ((RemainingRecordsErrorHandler)this.errorHandler).handle(this.decorateException(e), records, this.consumer, KafkaMessageListenerContainer.this.container);
            } else {
                this.errorHandler.handle(this.decorateException(e), record, this.consumer);
            }
            if (producer != null) {
                this.ackCurrent(record, producer);
            }
        }

        private Exception decorateException(RuntimeException e) {
            Object toHandle = e;
            if (toHandle instanceof ListenerExecutionFailedException) {
                toHandle = new ListenerExecutionFailedException(toHandle.getMessage(), this.consumerGroupId, toHandle.getCause());
            }
            return toHandle;
        }

        public void checkDeser(ConsumerRecord<K, V> record, String headerName) {
            Header header = record.headers().lastHeader(headerName);
            if (header != null) {
                try {
                    DeserializationException ex = (DeserializationException)((Object)new ObjectInputStream(new ByteArrayInputStream(header.value())).readObject());
                    RecordHeaders headers = new RecordHeaders((Iterable)Arrays.stream(record.headers().toArray()).filter(h -> !h.key().startsWith("springDeserializerException")).collect(Collectors.toList()));
                    ex.setHeaders((Headers)headers);
                    throw ex;
                }
                catch (IOException | ClassCastException | ClassNotFoundException e) {
                    this.logger.error((Object)"Failed to deserialize a deserialization exception", (Throwable)e);
                }
            }
        }

        public void ackCurrent(ConsumerRecord<K, V> record) {
            this.ackCurrent(record, null);
        }

        public void ackCurrent(ConsumerRecord<K, V> record, @Nullable Producer producer) {
            if (this.isRecordAck) {
                Map<TopicPartition, OffsetAndMetadata> offsetsToCommit = Collections.singletonMap(new TopicPartition(record.topic(), record.partition()), new OffsetAndMetadata(record.offset() + 1L));
                if (producer == null) {
                    this.commitLogger.log(() -> "Committing: " + offsetsToCommit);
                    if (this.containerProperties.isSyncCommits()) {
                        this.consumer.commitSync(offsetsToCommit);
                    } else {
                        this.consumer.commitAsync(offsetsToCommit, this.commitCallback);
                    }
                } else {
                    this.acks.add(record);
                }
            } else if (!this.isAnyManualAck && !this.autoCommit) {
                this.acks.add(record);
            }
            if (producer != null) {
                try {
                    this.sendOffsetsToTransaction(producer);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Send offsets to transaction failed", (Throwable)e);
                }
            }
        }

        private void sendOffsetsToTransaction(Producer producer) {
            this.handleAcks();
            Map<TopicPartition, OffsetAndMetadata> commits = this.buildCommits();
            this.commitLogger.log(() -> "Sending offsets to transaction: " + commits);
            producer.sendOffsetsToTransaction(commits, this.consumerGroupId);
        }

        private void processCommits() {
            this.count += this.acks.size();
            this.handleAcks();
            ContainerProperties.AckMode ackMode = this.containerProperties.getAckMode();
            if (!this.isManualImmediateAck) {
                boolean countExceeded;
                if (!this.isManualAck) {
                    this.updatePendingOffsets();
                }
                boolean bl = countExceeded = this.isCountAck && this.count >= this.containerProperties.getAckCount();
                if (!this.isTimeOnlyAck && !this.isCountAck || countExceeded) {
                    if (this.logger.isDebugEnabled() && this.isCountAck) {
                        this.logger.debug((Object)("Committing in " + ackMode.name() + " because count " + this.count + " exceeds configured limit of " + this.containerProperties.getAckCount()));
                    }
                    this.commitIfNecessary();
                    this.count = 0;
                } else {
                    this.timedAcks(ackMode);
                }
            }
        }

        private void timedAcks(ContainerProperties.AckMode ackMode) {
            boolean elapsed;
            long now = System.currentTimeMillis();
            boolean bl = elapsed = now - this.last > this.containerProperties.getAckTime();
            if (ackMode.equals((Object)ContainerProperties.AckMode.TIME) && elapsed) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Committing in AckMode.TIME because time elapsed exceeds configured limit of " + this.containerProperties.getAckTime()));
                }
                this.commitIfNecessary();
                this.last = now;
            } else if (ackMode.equals((Object)ContainerProperties.AckMode.COUNT_TIME) && elapsed) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Committing in AckMode.COUNT_TIME because time elapsed exceeds configured limit of " + this.containerProperties.getAckTime()));
                }
                this.commitIfNecessary();
                this.last = now;
                this.count = 0;
            }
        }

        private void processSeeks() {
            TopicPartitionInitialOffset offset = (TopicPartitionInitialOffset)this.seeks.poll();
            while (offset != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Seek: " + offset));
                }
                try {
                    TopicPartitionInitialOffset.SeekPosition position = offset.getPosition();
                    if (position == null) {
                        this.consumer.seek(offset.topicPartition(), offset.initialOffset().longValue());
                    } else if (position.equals((Object)TopicPartitionInitialOffset.SeekPosition.BEGINNING)) {
                        this.consumer.seekToBeginning(Collections.singletonList(offset.topicPartition()));
                    } else {
                        this.consumer.seekToEnd(Collections.singletonList(offset.topicPartition()));
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception while seeking " + offset), (Throwable)e);
                }
                offset = (TopicPartitionInitialOffset)this.seeks.poll();
            }
        }

        private void initPartitionsIfNeeded() {
            HashMap<TopicPartition, OffsetMetadata> partitions = new HashMap<TopicPartition, OffsetMetadata>(this.definedPartitions);
            Set<TopicPartition> beginnings = partitions.entrySet().stream().filter(e -> TopicPartitionInitialOffset.SeekPosition.BEGINNING.equals((Object)((OffsetMetadata)e.getValue()).seekPosition)).map(Map.Entry::getKey).collect(Collectors.toSet());
            beginnings.forEach(partitions::remove);
            Set<TopicPartition> ends = partitions.entrySet().stream().filter(e -> TopicPartitionInitialOffset.SeekPosition.END.equals((Object)((OffsetMetadata)e.getValue()).seekPosition)).map(Map.Entry::getKey).collect(Collectors.toSet());
            ends.forEach(partitions::remove);
            if (beginnings.size() > 0) {
                this.consumer.seekToBeginning(beginnings);
            }
            if (ends.size() > 0) {
                this.consumer.seekToEnd(ends);
            }
            for (Map.Entry entry : partitions.entrySet()) {
                TopicPartition topicPartition = (TopicPartition)entry.getKey();
                OffsetMetadata metadata = (OffsetMetadata)entry.getValue();
                Long offset = metadata.offset;
                if (offset == null) continue;
                long newOffset = offset;
                if (offset < 0L) {
                    if (!metadata.relativeToCurrent) {
                        this.consumer.seekToEnd(Collections.singletonList(topicPartition));
                    }
                    newOffset = Math.max(0L, this.consumer.position(topicPartition) + offset);
                } else if (metadata.relativeToCurrent) {
                    newOffset = this.consumer.position(topicPartition) + offset;
                }
                try {
                    this.consumer.seek(topicPartition, newOffset);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Reset " + topicPartition + " to offset " + newOffset));
                }
                catch (Exception e2) {
                    this.logger.error((Object)("Failed to set initial offset for " + topicPartition + " at " + newOffset + ". Position is " + this.consumer.position(topicPartition)), (Throwable)e2);
                }
            }
        }

        private void updatePendingOffsets() {
            ConsumerRecord record = (ConsumerRecord)this.acks.poll();
            while (record != null) {
                this.addOffset(record);
                record = (ConsumerRecord)this.acks.poll();
            }
        }

        private void addOffset(ConsumerRecord<K, V> record) {
            this.offsets.computeIfAbsent(record.topic(), v -> new ConcurrentHashMap()).compute(record.partition(), (k, v) -> v == null ? record.offset() : Math.max(v, record.offset()));
        }

        private void commitIfNecessary() {
            Map<TopicPartition, OffsetAndMetadata> commits = this.buildCommits();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Commit list: " + commits));
            }
            if (!commits.isEmpty()) {
                this.commitLogger.log(() -> "Committing: " + commits);
                try {
                    if (this.containerProperties.isSyncCommits()) {
                        this.consumer.commitSync(commits);
                    } else {
                        this.consumer.commitAsync(commits, this.commitCallback);
                    }
                }
                catch (WakeupException e) {
                    this.logger.debug((Object)"Woken up during commit");
                }
            }
        }

        private Map<TopicPartition, OffsetAndMetadata> buildCommits() {
            HashMap<TopicPartition, OffsetAndMetadata> commits = new HashMap<TopicPartition, OffsetAndMetadata>();
            for (Map.Entry<String, Map<Integer, Long>> entry : this.offsets.entrySet()) {
                for (Map.Entry<Integer, Long> offset : entry.getValue().entrySet()) {
                    commits.put(new TopicPartition(entry.getKey(), offset.getKey().intValue()), new OffsetAndMetadata(offset.getValue() + 1L));
                }
            }
            this.offsets.clear();
            return commits;
        }

        private Collection<ConsumerRecord<K, V>> getHighestOffsetRecords(ConsumerRecords<K, V> records) {
            return records.partitions().stream().collect(Collectors.toMap(tp -> tp, tp -> {
                List recordList = records.records(tp);
                return (ConsumerRecord)recordList.get(recordList.size() - 1);
            })).values();
        }

        @Override
        public void seek(String topic, int partition, long offset) {
            this.seeks.add(new TopicPartitionInitialOffset(topic, partition, offset));
        }

        @Override
        public void seekToBeginning(String topic, int partition) {
            this.seeks.add(new TopicPartitionInitialOffset(topic, partition, TopicPartitionInitialOffset.SeekPosition.BEGINNING));
        }

        @Override
        public void seekToEnd(String topic, int partition) {
            this.seeks.add(new TopicPartitionInitialOffset(topic, partition, TopicPartitionInitialOffset.SeekPosition.END));
        }

        public String toString() {
            return "KafkaMessageListenerContainer.ListenerConsumer [containerProperties=" + this.containerProperties + ", listenerType=" + (Object)((Object)this.listenerType) + ", isConsumerAwareListener=" + this.isConsumerAwareListener + ", isBatchListener=" + this.isBatchListener + ", autoCommit=" + this.autoCommit + ", consumerGroupId=" + this.consumerGroupId + ", clientIdSuffix=" + KafkaMessageListenerContainer.this.clientIdSuffix + "]";
        }

        private void closeProducers(@Nullable Collection<TopicPartition> partitions) {
            if (partitions != null) {
                ProducerFactory producerFactory = this.kafkaTxManager.getProducerFactory();
                partitions.forEach(tp -> {
                    try {
                        producerFactory.closeProducerFor(this.zombieFenceTxIdSuffix(tp.topic(), tp.partition()));
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Failed to close producer with transaction id suffix: " + this.zombieFenceTxIdSuffix(tp.topic(), tp.partition())), (Throwable)e);
                    }
                });
            }
        }

        private String zombieFenceTxIdSuffix(String topic, int partition) {
            return this.consumerGroupId + "." + topic + "." + partition;
        }

        private class ListenerConsumerRebalanceListener
        implements ConsumerRebalanceListener {
            private final ConsumerRebalanceListener userListener;
            private final ConsumerAwareRebalanceListener consumerAwareListener;

            ListenerConsumerRebalanceListener() {
                this.userListener = KafkaMessageListenerContainer.this.getContainerProperties().getConsumerRebalanceListener();
                this.consumerAwareListener = this.userListener instanceof ConsumerAwareRebalanceListener ? (ConsumerAwareRebalanceListener)this.userListener : null;
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                try {
                    if (this.consumerAwareListener != null) {
                        this.consumerAwareListener.onPartitionsRevokedBeforeCommit(ListenerConsumer.this.consumer, partitions);
                    } else {
                        this.userListener.onPartitionsRevoked(partitions);
                    }
                    ListenerConsumer.this.commitPendingAcks();
                    if (this.consumerAwareListener != null) {
                        this.consumerAwareListener.onPartitionsRevokedAfterCommit(ListenerConsumer.this.consumer, partitions);
                    }
                }
                finally {
                    if (ListenerConsumer.this.kafkaTxManager != null) {
                        ListenerConsumer.this.closeProducers(partitions);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (ListenerConsumer.this.consumerPaused) {
                    ListenerConsumer.this.consumer.pause(partitions);
                    ListenerConsumer.this.logger.warn((Object)"Paused consumer resumed by Kafka due to rebalance; consumer paused again, so the initial poll() will never return any records");
                }
                ListenerConsumer.this.assignedPartitions = partitions;
                if (!ListenerConsumer.this.autoCommit) {
                    HashMap<TopicPartition, OffsetAndMetadata> offsetsToCommit = new HashMap<TopicPartition, OffsetAndMetadata>();
                    for (TopicPartition partition2 : partitions) {
                        try {
                            offsetsToCommit.put(partition2, new OffsetAndMetadata(ListenerConsumer.this.consumer.position(partition2)));
                        }
                        catch (NoOffsetForPartitionException e) {
                            ListenerConsumer.this.fatalError = true;
                            ListenerConsumer.this.logger.error((Object)"No offset and no reset policy", (Throwable)e);
                            return;
                        }
                    }
                    ListenerConsumer.this.commitLogger.log(() -> "Committing on assignment: " + offsetsToCommit);
                    if (ListenerConsumer.this.transactionTemplate != null && ListenerConsumer.this.kafkaTxManager != null) {
                        try {
                            offsetsToCommit.forEach((partition, offsetAndMetadata) -> {
                                TransactionSupport.setTransactionIdSuffix(ListenerConsumer.this.zombieFenceTxIdSuffix(partition.topic(), partition.partition()));
                                ListenerConsumer.this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult((TopicPartition)partition, (OffsetAndMetadata)offsetAndMetadata){
                                    final /* synthetic */ TopicPartition val$partition;
                                    final /* synthetic */ OffsetAndMetadata val$offsetAndMetadata;
                                    {
                                        this.val$partition = topicPartition;
                                        this.val$offsetAndMetadata = offsetAndMetadata;
                                    }

                                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                                        KafkaResourceHolder holder = (KafkaResourceHolder)((Object)TransactionSynchronizationManager.getResource(ListenerConsumer.this.kafkaTxManager.getProducerFactory()));
                                        if (holder != null) {
                                            holder.getProducer().sendOffsetsToTransaction(Collections.singletonMap(this.val$partition, this.val$offsetAndMetadata), ListenerConsumer.this.consumerGroupId);
                                        }
                                    }
                                });
                            });
                        }
                        finally {
                            TransactionSupport.clearTransactionIdSuffix();
                        }
                    } else if (KafkaMessageListenerContainer.this.getContainerProperties().isSyncCommits()) {
                        ListenerConsumer.this.consumer.commitSync(offsetsToCommit);
                    } else {
                        ListenerConsumer.this.consumer.commitAsync(offsetsToCommit, KafkaMessageListenerContainer.this.getContainerProperties().getCommitCallback());
                    }
                }
                if (ListenerConsumer.this.genericListener instanceof ConsumerSeekAware) {
                    ListenerConsumer.this.seekPartitions(partitions, false);
                }
                if (this.consumerAwareListener != null) {
                    this.consumerAwareListener.onPartitionsAssigned(ListenerConsumer.this.consumer, partitions);
                } else {
                    this.userListener.onPartitionsAssigned(partitions);
                }
            }
        }

        private final class ConsumerBatchAcknowledgment
        implements Acknowledgment {
            private final ConsumerRecords<K, V> records;

            ConsumerBatchAcknowledgment(ConsumerRecords<K, V> records) {
                this.records = records;
            }

            @Override
            public void acknowledge() {
                Assert.state((boolean)ListenerConsumer.this.isAnyManualAck, (String)"A manual ackmode is required for an acknowledging listener");
                for (ConsumerRecord record : ListenerConsumer.this.getHighestOffsetRecords(this.records)) {
                    ListenerConsumer.this.processAck(record);
                }
            }

            public String toString() {
                return "Acknowledgment for " + this.records;
            }
        }

        private final class ConsumerAcknowledgment
        implements Acknowledgment {
            private final ConsumerRecord<K, V> record;

            ConsumerAcknowledgment(ConsumerRecord<K, V> record) {
                this.record = record;
            }

            @Override
            public void acknowledge() {
                Assert.state((boolean)ListenerConsumer.this.isAnyManualAck, (String)"A manual ackmode is required for an acknowledging listener");
                ListenerConsumer.this.processAck(this.record);
            }

            public String toString() {
                return "Acknowledgment for " + this.record;
            }
        }
    }
}

