/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.concurrent.Executor;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareBatchErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.Assert;

public class ContainerStoppingBatchErrorHandler
implements ContainerAwareBatchErrorHandler {
    private final Executor executor;

    public ContainerStoppingBatchErrorHandler() {
        this.executor = new SimpleAsyncTaskExecutor();
    }

    public ContainerStoppingBatchErrorHandler(Executor executor) {
        Assert.notNull((Object)executor, (String)"'executor' cannot be null");
        this.executor = executor;
    }

    @Override
    public void handle(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container) {
        this.executor.execute(() -> container.stop());
        int n = 0;
        while (container.isRunning() && n++ < 100) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new KafkaException("Stopped container", thrownException);
    }
}

