/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import org.apache.kafka.clients.producer.Producer;
import org.springframework.kafka.core.KafkaResourceHolder;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class ProducerFactoryUtils {
    private static ThreadLocal<String> groupIds = new ThreadLocal();

    private ProducerFactoryUtils() {
    }

    public static <K, V> KafkaResourceHolder<K, V> getTransactionalResourceHolder(ProducerFactory<K, V> producerFactory) {
        Assert.notNull(producerFactory, (String)"ProducerFactory must not be null");
        KafkaResourceHolder<K, V> resourceHolder = (KafkaResourceHolder<K, V>)((Object)TransactionSynchronizationManager.getResource(producerFactory));
        if (resourceHolder == null) {
            Producer<K, V> producer = producerFactory.createProducer();
            try {
                producer.beginTransaction();
            }
            catch (RuntimeException e) {
                producer.close();
                throw e;
            }
            resourceHolder = new KafkaResourceHolder<K, V>(producer);
            ProducerFactoryUtils.bindResourceToTransaction(resourceHolder, producerFactory);
        }
        return resourceHolder;
    }

    public static <K, V> void releaseResources(@Nullable KafkaResourceHolder<K, V> resourceHolder) {
        if (resourceHolder != null) {
            resourceHolder.getProducer().close();
        }
    }

    public static void setConsumerGroupId(String groupId) {
        groupIds.set(groupId);
    }

    public static String getConsumerGroupId() {
        return groupIds.get();
    }

    public static void clearConsumerGroupId() {
        groupIds.remove();
    }

    private static <K, V> void bindResourceToTransaction(KafkaResourceHolder<K, V> resourceHolder, ProducerFactory<K, V> producerFactory) {
        TransactionSynchronizationManager.bindResource(producerFactory, resourceHolder);
        resourceHolder.setSynchronizedWithTransaction(true);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization(new KafkaResourceSynchronization<K, V>(resourceHolder, producerFactory));
        }
    }

    private static final class KafkaResourceSynchronization<K, V>
    extends ResourceHolderSynchronization<KafkaResourceHolder<K, V>, Object> {
        private final KafkaResourceHolder<K, V> resourceHolder;

        KafkaResourceSynchronization(KafkaResourceHolder<K, V> resourceHolder, Object resourceKey) {
            super(resourceHolder, resourceKey);
            this.resourceHolder = resourceHolder;
        }

        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        public void afterCompletion(int status) {
            try {
                if (status == 0) {
                    this.resourceHolder.commit();
                } else {
                    this.resourceHolder.rollback();
                }
            }
            finally {
                super.afterCompletion(status);
            }
        }

        protected void releaseResource(KafkaResourceHolder<K, V> resourceHolder, Object resourceKey) {
            ProducerFactoryUtils.releaseResources(resourceHolder);
        }
    }
}

