/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public interface ProducerListener<K, V> {
    default public void onSuccess(ProducerRecord<K, V> producerRecord, RecordMetadata recordMetadata) {
        this.onSuccess(producerRecord.topic(), producerRecord.partition(), producerRecord.key(), producerRecord.value(), recordMetadata);
    }

    default public void onSuccess(String topic, Integer partition, K key, V value, RecordMetadata recordMetadata) {
    }

    default public void onError(ProducerRecord<K, V> producerRecord, Exception exception) {
        this.onError(producerRecord.topic(), producerRecord.partition(), producerRecord.key(), producerRecord.value(), exception);
    }

    default public void onError(String topic, Integer partition, K key, V value, Exception exception) {
    }

    @Deprecated
    default public boolean isInterestedInSuccess() {
        return false;
    }
}

