/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.kafka.KafkaException;

public class KafkaAdmin
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final int DEFAULT_CLOSE_TIMEOUT = 10;
    private static final int DEFAULT_OPERATION_TIMEOUT = 30;
    private static final Log logger = LogFactory.getLog(KafkaAdmin.class);
    private final Map<String, Object> config;
    private ApplicationContext applicationContext;
    private int closeTimeout = 10;
    private int operationTimeout = 30;
    private boolean fatalIfBrokerNotAvailable;
    private boolean autoCreate = true;
    private boolean initializingContext;

    public KafkaAdmin(Map<String, Object> config) {
        this.config = new HashMap<String, Object>(config);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public void setFatalIfBrokerNotAvailable(boolean fatalIfBrokerNotAvailable) {
        this.fatalIfBrokerNotAvailable = fatalIfBrokerNotAvailable;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public Map<String, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public void afterSingletonsInstantiated() {
        this.initializingContext = true;
        if (this.autoCreate) {
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initialize() {
        Collection<NewTopic> newTopics = this.applicationContext.getBeansOfType(NewTopic.class, false, false).values();
        if (newTopics.size() > 0) {
            AdminClient adminClient = null;
            try {
                adminClient = AdminClient.create(this.config);
            }
            catch (Exception e) {
                if (!this.initializingContext || this.fatalIfBrokerNotAvailable) {
                    throw new IllegalStateException("Could not create admin", e);
                }
                logger.error((Object)"Could not create admin", (Throwable)e);
            }
            if (adminClient != null) {
                try {
                    this.addTopicsIfNeeded(adminClient, newTopics);
                    boolean e = true;
                    return e;
                }
                catch (Exception e) {
                    if (!this.initializingContext || this.fatalIfBrokerNotAvailable) {
                        throw new IllegalStateException("Could not configure topics", e);
                    }
                    logger.error((Object)"Could not configure topics", (Throwable)e);
                }
                finally {
                    this.initializingContext = false;
                    adminClient.close((long)this.closeTimeout, TimeUnit.SECONDS);
                }
            }
        }
        this.initializingContext = false;
        return false;
    }

    private void addTopicsIfNeeded(AdminClient adminClient, Collection<NewTopic> topics) {
        if (topics.size() > 0) {
            HashMap<String, NewTopic> topicNameToTopic = new HashMap<String, NewTopic>();
            topics.forEach(t -> topicNameToTopic.compute(t.name(), (k, v) -> {
                v = t;
                return v;
            }));
            DescribeTopicsResult topicInfo = adminClient.describeTopics((Collection)topics.stream().map(NewTopic::name).collect(Collectors.toList()));
            ArrayList<NewTopic> topicsToAdd = new ArrayList<NewTopic>();
            Map<String, NewPartitions> topicsToModify = this.checkPartitions(topicNameToTopic, topicInfo, topicsToAdd);
            if (topicsToAdd.size() > 0) {
                this.addTopics(adminClient, topicsToAdd);
            }
            if (topicsToModify.size() > 0) {
                this.modifyTopics(adminClient, topicsToModify);
            }
        }
    }

    private Map<String, NewPartitions> checkPartitions(Map<String, NewTopic> topicNameToTopic, DescribeTopicsResult topicInfo, List<NewTopic> topicsToAdd) {
        HashMap<String, NewPartitions> topicsToModify = new HashMap<String, NewPartitions>();
        topicInfo.values().forEach((n, f) -> {
            NewTopic topic = (NewTopic)topicNameToTopic.get(n);
            try {
                TopicDescription topicDescription = (TopicDescription)f.get((long)this.operationTimeout, TimeUnit.SECONDS);
                if (topic.numPartitions() < topicDescription.partitions().size()) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)String.format("Topic '%s' exists but has a different partition count: %d not %d", n, topicDescription.partitions().size(), topic.numPartitions()));
                    }
                } else if (topic.numPartitions() > topicDescription.partitions().size()) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)String.format("Topic '%s' exists but has a different partition count: %d not %d, increasing if the broker supports it", n, topicDescription.partitions().size(), topic.numPartitions()));
                    }
                    topicsToModify.put((String)n, NewPartitions.increaseTo((int)topic.numPartitions()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                throw new KafkaException("Timed out waiting to get existing topics", e);
            }
            catch (ExecutionException e) {
                topicsToAdd.add(topic);
            }
        });
        return topicsToModify;
    }

    private void addTopics(AdminClient adminClient, List<NewTopic> topicsToAdd) {
        CreateTopicsResult topicResults = adminClient.createTopics(topicsToAdd);
        try {
            topicResults.all().get((long)this.operationTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Interrupted while waiting for topic creation results", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new KafkaException("Timed out waiting for create topics results", e);
        }
        catch (ExecutionException e) {
            logger.error((Object)"Failed to create topics", e.getCause());
            throw new KafkaException("Failed to create topics", e.getCause());
        }
    }

    private void modifyTopics(AdminClient adminClient, Map<String, NewPartitions> topicsToModify) {
        block4: {
            CreatePartitionsResult partitionsResult = adminClient.createPartitions(topicsToModify);
            try {
                partitionsResult.all().get((long)this.operationTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Interrupted while waiting for partition creation results", (Throwable)e);
            }
            catch (TimeoutException e) {
                throw new KafkaException("Timed out waiting for create partitions results", e);
            }
            catch (ExecutionException e) {
                logger.error((Object)"Failed to create partitions", e.getCause());
                if (e.getCause() instanceof UnsupportedVersionException) break block4;
                throw new KafkaException("Failed to create partitions", e.getCause());
            }
        }
    }
}

