/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import org.springframework.config.java.annotation.Import;
import org.springframework.config.java.process.ConfigurationListenerSupport;
import org.springframework.config.java.process.ConfigurationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportConfigurationListener
extends ConfigurationListenerSupport {
    ImportConfigurationListener() {
    }

    @Override
    public boolean understands(Class<?> configurationClass) {
        return configurationClass.isAnnotationPresent(Import.class);
    }

    @Override
    public void configurationClass(ConfigurationProcessor configurationProcessor, String configurerBeanName, Class<?> configurationClass) {
        Class<?>[] configurationClassesToImport;
        Import importAnnotation = configurationClass.getAnnotation(Import.class);
        for (Class<?> configurationClassToImport : configurationClassesToImport = ImportConfigurationListener.reverse(importAnnotation.value())) {
            if (configurationProcessor.owningBeanFactory.containsBeanDefinition(configurationClassToImport.getName())) continue;
            configurationProcessor.beanDefsGenerated += configurationProcessor.processClass(configurationClassToImport);
        }
    }

    private static Class<?>[] reverse(Class<?>[] array) {
        if (array == null) {
            return array;
        }
        int size = array.length;
        Class[] reversed = new Class[size];
        for (int i = 0; i < size; ++i) {
            reversed[size - i - 1] = array[i];
        }
        return reversed;
    }
}

