/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.core.AutoBeanMethodProcessor;
import org.springframework.config.java.core.BeanMethodReturnValueProcessor;
import org.springframework.config.java.core.BeanNameTrackingDefaultListableBeanFactory;
import org.springframework.config.java.core.ExternalBeanMethodProcessor;
import org.springframework.config.java.core.ExternalValueMethodProcessor;
import org.springframework.config.java.core.StandardBeanMethodProcessor;
import org.springframework.config.java.enhancement.ConfigurationEnhancer;
import org.springframework.config.java.enhancement.cglib.CglibConfigurationEnhancer;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.config.java.naming.MethodNameStrategy;
import org.springframework.config.java.process.ConfigurationListener;
import org.springframework.config.java.process.ConfigurationListenerRegistry;
import org.springframework.config.java.process.ConfigurationPostProcessor;
import org.springframework.config.java.process.ProcessUtils;
import org.springframework.config.java.valuesource.CompositeValueSource;
import org.springframework.config.java.valuesource.ValueSource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationProcessor
implements InitializingBean,
ResourceLoaderAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    final ConfigurableListableBeanFactory owningBeanFactory;
    private final BeanNameTrackingDefaultListableBeanFactory childFactory;
    private AbstractApplicationContext owningApplicationContext;
    private ConfigurableApplicationContext childApplicationContext;
    private ConfigurationListenerRegistry configurationListenerRegistry = new ConfigurationListenerRegistry();
    private ConfigurationEnhancer configurationEnhancer;
    private BeanNamingStrategy beanNamingStrategy = new MethodNameStrategy();
    private CompositeValueSource valueSource = new CompositeValueSource();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private boolean initialized = false;
    int beanDefsGenerated = -1;

    public ConfigurationProcessor(ConfigurableApplicationContext ac) {
        this(ac.getBeanFactory());
        if (ac instanceof AbstractApplicationContext) {
            this.owningApplicationContext = (AbstractApplicationContext)ac;
            this.childApplicationContext = this.createChildApplicationContext();
            this.copyBeanPostProcessors(this.owningApplicationContext, this.childApplicationContext);
        }
    }

    private ConfigurableApplicationContext createChildApplicationContext() {
        GenericApplicationContext child = new GenericApplicationContext(this.childFactory, (ApplicationContext)this.owningApplicationContext){

            public void publishEvent(ApplicationEvent event) {
                if (event instanceof ContextRefreshedEvent) {
                    ConfigurationProcessor.this.log.debug((Object)("suppressed " + event));
                }
            }
        };
        this.owningApplicationContext.addApplicationListener(new ApplicationListener(){

            public void onApplicationEvent(ApplicationEvent event) {
                if (event instanceof ContextRefreshedEvent) {
                    ConfigurationProcessor.this.childApplicationContext.refresh();
                }
            }
        });
        return child;
    }

    private void copyBeanPostProcessors(AbstractApplicationContext source, ConfigurableApplicationContext dest) {
        LinkedList<BeanFactoryPostProcessor> bfpps = new LinkedList<BeanFactoryPostProcessor>();
        for (Object o : source.getBeansOfType(BeanFactoryPostProcessor.class).values()) {
            if (o instanceof ConfigurationPostProcessor) continue;
            bfpps.add((BeanFactoryPostProcessor)o);
        }
        for (Object o : source.getBeanFactoryPostProcessors()) {
            if (o instanceof ConfigurationPostProcessor) continue;
            bfpps.add((BeanFactoryPostProcessor)o);
        }
        for (BeanFactoryPostProcessor bfpp : bfpps) {
            dest.addBeanFactoryPostProcessor(bfpp);
        }
    }

    public ConfigurationProcessor(ConfigurableListableBeanFactory clbf) {
        this.owningBeanFactory = clbf;
        this.childFactory = new BeanNameTrackingDefaultListableBeanFactory(this.owningBeanFactory);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setBeanNamingStrategy(BeanNamingStrategy beanNamingStrategy) {
        this.beanNamingStrategy = beanNamingStrategy;
    }

    public void setConfigurationListenerRegistry(ConfigurationListenerRegistry configurationListenerRegistry) {
        this.configurationListenerRegistry = configurationListenerRegistry;
    }

    public void addValueSource(ValueSource vs) {
        this.valueSource.add(vs);
    }

    public BeanFactory getChildBeanFactory() {
        return this.childApplicationContext != null ? this.childApplicationContext : this.childFactory;
    }

    public void registerBeanDefinition(String name, BeanDefinition bd, boolean hide) {
        if (hide) {
            this.childFactory.registerBeanDefinition(name, bd);
        } else {
            ((BeanDefinitionRegistry)this.owningBeanFactory).registerBeanDefinition(name, bd);
        }
    }

    public void registerSingleton(String name, Object o, boolean hide) {
        if (hide) {
            this.childFactory.registerSingleton(name, o);
        } else {
            this.owningBeanFactory.registerSingleton(name, o);
        }
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.owningBeanFactory, (String)"an owning factory bean is required");
        ArrayList<BeanMethodReturnValueProcessor> a = new ArrayList<BeanMethodReturnValueProcessor>();
        for (ConfigurationListener c : this.configurationListenerRegistry.getConfigurationListeners()) {
            a.add(c);
        }
        this.configurationEnhancer = new CglibConfigurationEnhancer(this.owningBeanFactory, this.childFactory, this.beanNamingStrategy, a, this.valueSource);
        this.initialized = true;
    }

    private void checkInit() {
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processClass(Class<?> configurationClass) throws BeanDefinitionStoreException {
        boolean isEntryPoint = false;
        if (this.beanDefsGenerated == -1) {
            isEntryPoint = true;
            this.beanDefsGenerated = 0;
        }
        this.checkInit();
        if (!ConfigurationProcessor.isConfigurationClass(configurationClass, this.configurationListenerRegistry)) {
            return 0;
        }
        String configBeanName = configurationClass.getName();
        RootBeanDefinition configurationBeanDefinition = new RootBeanDefinition();
        configurationBeanDefinition.setBeanClass(configurationClass);
        configurationBeanDefinition.setResourceDescription("class-based configuration bean definition");
        Assert.isInstanceOf(DefaultListableBeanFactory.class, (Object)this.owningBeanFactory);
        ((DefaultListableBeanFactory)this.owningBeanFactory).registerBeanDefinition(configBeanName, (BeanDefinition)configurationBeanDefinition);
        try {
            this.processConfigurationBean(configBeanName, configurationClass);
            int n = ++this.beanDefsGenerated;
            return n;
        }
        finally {
            if (isEntryPoint) {
                this.beanDefsGenerated = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processConfigurationBean(String configurationBeanName, Class<?> configurationClass) {
        boolean isEntryPoint = false;
        if (this.beanDefsGenerated == -1) {
            isEntryPoint = true;
            this.beanDefsGenerated = 0;
        }
        try {
            this.checkInit();
            Assert.notNull((Object)configurationBeanName, (String)"beanName is required");
            Assert.notNull(configurationClass, (String)"configurationClass is required");
            this.enhanceConfigurationClassAndUpdateBeanDefinition(configurationClass, configurationBeanName);
            this.generateBeanDefinitions(configurationBeanName, configurationClass);
            return;
        }
        finally {
            if (isEntryPoint) {
                this.beanDefsGenerated = -1;
            }
        }
    }

    protected void generateBeanDefinitions(String configurationBeanName, Class<?> configurationClass) {
        this.processAnyConfigurationListeners(configurationBeanName, configurationClass);
        this.processAnyLocalBeanDefinitions(configurationBeanName, configurationClass);
    }

    private void processAnyLocalBeanDefinitions(final String configurationBeanName, final Class<?> configurationClass) {
        final HashSet noArgMethodsSeen = new HashSet();
        ReflectionUtils.doWithMethods(configurationClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method m) throws IllegalArgumentException, IllegalAccessException {
                Bean beanAnnotation = (Bean)AnnotationUtils.findAnnotation((Method)m, Bean.class);
                String beanName = ConfigurationProcessor.this.beanNamingStrategy.getBeanName(m);
                if (beanAnnotation != null) {
                    if (!noArgMethodsSeen.contains(beanName)) {
                        if (ConfigurationProcessor.this.owningBeanFactory.containsLocalBean(beanName)) {
                            if (!beanAnnotation.allowOverriding()) {
                                String message = String.format("A bean named '%s' already exists. Consider using @Bean(allowOverriding=true)", beanName);
                                throw new IllegalStateException(message);
                            }
                            return;
                        }
                        noArgMethodsSeen.add(beanName);
                        ConfigurationProcessor.this.generateBeanDefinitionFromBeanCreationMethod(ConfigurationProcessor.this.owningBeanFactory, configurationBeanName, configurationClass, beanName, m, beanAnnotation);
                    }
                } else {
                    for (ConfigurationListener cml : ConfigurationProcessor.this.configurationListenerRegistry.getConfigurationListeners()) {
                        cml.otherMethod(ConfigurationProcessor.this, configurationBeanName, configurationClass, m);
                    }
                }
            }
        });
    }

    private void processAnyConfigurationListeners(String configurationBeanName, Class<?> configurationClass) {
        for (ConfigurationListener cl : this.configurationListenerRegistry.getConfigurationListeners()) {
            if (!cl.understands(configurationClass)) continue;
            cl.configurationClass(this, configurationBeanName, configurationClass);
        }
    }

    private void enhanceConfigurationClassAndUpdateBeanDefinition(Class<?> configurationClass, String configurationBeanName) {
        AbstractBeanDefinition definition = (AbstractBeanDefinition)this.owningBeanFactory.getBeanDefinition(configurationBeanName);
        Class<?> enhancedClass = this.configurationEnhancer.enhanceConfiguration(configurationClass);
        definition.setBeanClass(enhancedClass);
        for (PropertyValue pv : definition.getPropertyValues().getPropertyValues()) {
            if (!(pv.getValue() instanceof RuntimeBeanReference)) continue;
            RuntimeBeanReference rbref = (RuntimeBeanReference)pv.getValue();
            String beanName = rbref.getBeanName();
            if (definition.getDependsOn() == null) {
                definition.setDependsOn(new String[]{beanName});
                continue;
            }
            String[] added = (String[])ObjectUtils.addObjectToArray((Object[])definition.getDependsOn(), (Object)beanName);
            definition.setDependsOn(added);
        }
    }

    protected void generateBeanDefinitionFromBeanCreationMethod(ConfigurableListableBeanFactory beanFactory, String configurerBeanName, Class<?> configurerClass, String beanName, Method beanCreationMethod, Bean beanAnnotation) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found bean creation method " + beanCreationMethod));
        }
        ProcessUtils.validateBeanCreationMethod(beanCreationMethod);
        RootBeanDefinition rbd = new RootBeanDefinition(beanCreationMethod.getReturnType());
        rbd.setFactoryMethodName(beanCreationMethod.getName());
        rbd.setFactoryBeanName(configurerBeanName);
        rbd.setAttribute("org.springframework.config.java", (Object)Boolean.TRUE);
        Configuration config = configurerClass.getAnnotation(Configuration.class);
        ProcessUtils.copyAttributes(beanName, beanAnnotation, config, rbd, beanFactory);
        StringBuilder builder = new StringBuilder("Bean creation method ");
        builder.append(beanCreationMethod.getName());
        builder.append(" in class ");
        builder.append(beanCreationMethod.getDeclaringClass().getName());
        rbd.setResourceDescription(builder.toString());
        ConfigurationListener.BeanDefinitionRegistration beanDefinitionRegistration = new ConfigurationListener.BeanDefinitionRegistration(rbd, beanName);
        beanDefinitionRegistration.hide = !Modifier.isPublic(beanCreationMethod.getModifiers());
        for (ConfigurationListener cml : this.configurationListenerRegistry.getConfigurationListeners()) {
            cml.beanCreationMethod(beanDefinitionRegistration, this, configurerBeanName, configurerClass, beanCreationMethod, beanAnnotation);
        }
        if (beanDefinitionRegistration.rbd == null) {
            return;
        }
        if (beanDefinitionRegistration.hide) {
            this.childFactory.registerBeanDefinition(beanDefinitionRegistration.name, (BeanDefinition)beanDefinitionRegistration.rbd);
        } else {
            ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(beanDefinitionRegistration.name, (BeanDefinition)beanDefinitionRegistration.rbd);
        }
        ++this.beanDefsGenerated;
    }

    public static boolean isConfigurationClass(Class<?> candidateConfigurationClass) {
        Assert.notNull(candidateConfigurationClass);
        if (Modifier.isAbstract(candidateConfigurationClass.getModifiers()) && AutoBeanMethodProcessor.findAutoBeanCreationMethods(candidateConfigurationClass).isEmpty() && ExternalBeanMethodProcessor.findExternalBeanCreationMethods(candidateConfigurationClass).isEmpty() && ExternalValueMethodProcessor.findExternalValueCreationMethods(candidateConfigurationClass).isEmpty()) {
            return false;
        }
        return candidateConfigurationClass.isAnnotationPresent(Configuration.class) || !StandardBeanMethodProcessor.findBeanCreationMethods(candidateConfigurationClass).isEmpty();
    }

    static boolean isConfigurationClass(Class<?> candidateConfigurationClass, ConfigurationListenerRegistry registry) {
        if (ConfigurationProcessor.isConfigurationClass(candidateConfigurationClass)) {
            CglibConfigurationEnhancer.validateSuitabilityForEnhancement(candidateConfigurationClass);
            return true;
        }
        if (registry != null) {
            for (ConfigurationListener cl : registry.getConfigurationListeners()) {
                if (!cl.understands(candidateConfigurationClass)) continue;
                return true;
            }
        }
        return false;
    }
}

