/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.context.ClassPathScanningConfigurationProviderFactory;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.context.JavaConfigBeanFactoryPostProcessorRegistry;
import org.springframework.config.java.context.TypeSafeBeanFactory;
import org.springframework.config.java.context.TypeSafeBeanFactoryUtils;
import org.springframework.config.java.process.ConfigurationProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConfigWebApplicationContext
extends AbstractRefreshableWebApplicationContext
implements TypeSafeBeanFactory {
    private Log log = LogFactory.getLog(this.getClass());
    private final ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningConfigurationProviderFactory().getProvider((ResourceLoader)this);
    private ArrayList<Class<?>> configClasses = new ArrayList();
    private ArrayList<String> basePackages = new ArrayList();

    protected void prepareRefresh() {
        super.prepareRefresh();
        this.initConfigLocations();
        this.processAnyOuterClasses();
        this.registerDefaultPostProcessors();
    }

    protected void initConfigLocations() {
        Assert.notEmpty((Object[])this.getConfigLocations(), (String)"configLocations property has not been set");
        for (String location : this.getConfigLocations()) {
            try {
                Class<?> cz = Class.forName(location);
                if (ConfigurationProcessor.isConfigurationClass(cz)) {
                    this.configClasses.add(cz);
                    continue;
                }
                String message = "[%s] is not a valid configuration class. Perhaps you forgot to annotate your bean creation methods with @Bean?";
                this.log.warn((Object)String.format(message, cz));
            }
            catch (ClassNotFoundException ex) {
                this.basePackages.add(location);
            }
        }
    }

    private void processAnyOuterClasses() {
        Class<?> outerConfig = null;
        if (this.configClasses != null && this.configClasses.size() > 0) {
            for (Class<?> configClass : this.configClasses) {
                Class<?> candidate = configClass.getDeclaringClass();
                if (candidate == null || !ConfigurationProcessor.isConfigurationClass(candidate)) continue;
                if (outerConfig != null) {
                    throw new RuntimeException("cannot specify more than one inner configuration class");
                }
                outerConfig = candidate;
            }
        }
        if (outerConfig != null) {
            this.setParent((ApplicationContext)new JavaConfigApplicationContext(outerConfig));
        }
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        for (Class<?> cz : this.configClasses) {
            beanFactory.registerBeanDefinition(cz.getName(), (BeanDefinition)new RootBeanDefinition(cz, true));
        }
        for (String basePackage : this.basePackages) {
            Set beandefs = this.scanner.findCandidateComponents(basePackage);
            if (beandefs.size() > 0) {
                for (BeanDefinition bd : beandefs) {
                    beanFactory.registerBeanDefinition(bd.getBeanClassName(), bd);
                }
                continue;
            }
            String message = "[%s] is either specifying a configuration class that does not exist or is a base package pattern that does not match any configuration classes. No bean definitions were found as a result of processing this configLocation";
            this.log.warn((Object)String.format(message, basePackage));
        }
    }

    protected void registerDefaultPostProcessors() {
        new JavaConfigBeanFactoryPostProcessorRegistry().addAllPostProcessors((ConfigurableApplicationContext)this);
    }

    @Override
    public <T> T getBean(Class<T> type) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.getBeanFactory(), type);
    }

    @Override
    public <T> T getBean(Class<T> type, String beanName) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.getBeanFactory(), type, beanName);
    }
}

