/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zip.splitter;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;

public class UnZipResultSplitter
extends AbstractMessageSplitter {
    protected Object splitMessage(Message<?> message) {
        Assert.state((boolean)(message.getPayload() instanceof Map), (String)"The UnZipResultSplitter supports only Map<String, Object> payload");
        Map unzippedEntries = (Map)message.getPayload();
        MessageHeaders headers = message.getHeaders();
        ArrayList<MessageBuilder> messageBuilders = new ArrayList<MessageBuilder>(unzippedEntries.size());
        for (Map.Entry entry : unzippedEntries.entrySet()) {
            String path = FilenameUtils.getPath((String)((String)entry.getKey()));
            String filename = FilenameUtils.getName((String)((String)entry.getKey()));
            MessageBuilder messageBuilder = (MessageBuilder)((MessageBuilder)((MessageBuilder)MessageBuilder.withPayload(entry.getValue()).setHeader("file_name", (Object)filename)).setHeader("zip_entryPath", (Object)path)).copyHeadersIfAbsent((Map)headers);
            messageBuilders.add(messageBuilder);
        }
        return messageBuilders;
    }
}

