/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zip.transformer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.zip.transformer.AbstractZipTransformer;
import org.springframework.integration.zip.transformer.SpringZipUtils;
import org.springframework.integration.zip.transformer.ZipResultType;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipException;
import org.zeroturnaround.zip.ZipUtil;

public class UnZipTransformer
extends AbstractZipTransformer {
    private static final Log logger = LogFactory.getLog(UnZipTransformer.class);
    private volatile boolean expectSingleResult = false;

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object doZipTransform(final Message<?> message) {
        try {
            void var3_9;
            Object payload = message.getPayload();
            InputStream inputStream = null;
            try {
                File filePayload;
                if (payload instanceof File) {
                    File filePayload2 = (File)payload;
                    if (filePayload2.isDirectory()) {
                        throw new UnsupportedOperationException(String.format("Cannot unzip a directory: '%s'", filePayload2.getAbsolutePath()));
                    }
                    if (!SpringZipUtils.isValid(filePayload2)) {
                        throw new IllegalStateException(String.format("Not a zip file: '%s'.", filePayload2.getAbsolutePath()));
                    }
                    inputStream = new FileInputStream(filePayload2);
                } else if (payload instanceof InputStream) {
                    inputStream = (InputStream)payload;
                } else {
                    if (!(payload instanceof byte[])) throw new IllegalArgumentException(String.format("Unsupported payload type '%s'. The only supported payload types are java.io.File, byte[] and java.io.InputStream", payload.getClass().getSimpleName()));
                    inputStream = new ByteArrayInputStream((byte[])payload);
                }
                final TreeMap uncompressedData = new TreeMap();
                ZipUtil.iterate((InputStream)inputStream, (ZipEntryCallback)new ZipEntryCallback(){

                    public void process(InputStream zipEntryInputStream, ZipEntry zipEntry) throws IOException {
                        String type;
                        String zipEntryName = zipEntry.getName();
                        long zipEntryTime = zipEntry.getTime();
                        long zipEntryCompressedSize = zipEntry.getCompressedSize();
                        String string = type = zipEntry.isDirectory() ? "directory" : "file";
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)String.format("Unpacking Zip Entry - Name: '%s',Time: '%s', Compressed Size: '%s', Type: '%s'", zipEntryName, zipEntryTime, zipEntryCompressedSize, type));
                        }
                        if (ZipResultType.FILE.equals((Object)UnZipTransformer.this.zipResultType)) {
                            File destinationFile = this.checkPath(message, zipEntryName);
                            if (zipEntry.isDirectory()) {
                                destinationFile.mkdirs();
                            } else {
                                UnZipTransformer.mkDirOfAncestorDirectories(destinationFile);
                                SpringZipUtils.copy(zipEntryInputStream, destinationFile);
                                uncompressedData.put(zipEntryName, destinationFile);
                            }
                        } else if (ZipResultType.BYTE_ARRAY.equals((Object)UnZipTransformer.this.zipResultType)) {
                            if (!zipEntry.isDirectory()) {
                                this.checkPath(message, zipEntryName);
                                byte[] data = IOUtils.toByteArray((InputStream)zipEntryInputStream);
                                uncompressedData.put(zipEntryName, data);
                            }
                        } else {
                            throw new IllegalStateException("Unsupported zipResultType: " + (Object)((Object)UnZipTransformer.this.zipResultType));
                        }
                    }

                    public File checkPath(Message<?> message2, String zipEntryName) throws IOException {
                        File tempDir = new File(UnZipTransformer.this.workDirectory, message2.getHeaders().getId().toString());
                        tempDir.mkdirs();
                        File destinationFile = new File(tempDir, zipEntryName);
                        if (!destinationFile.getCanonicalPath().startsWith(tempDir.getCanonicalPath() + File.separator)) {
                            throw new ZipException("The file " + zipEntryName + " is trying to leave the target output directory of " + UnZipTransformer.this.workDirectory);
                        }
                        return destinationFile;
                    }
                });
                if (uncompressedData.isEmpty()) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("No data unzipped from payload with message Id " + message.getHeaders().getId()));
                    }
                    Object var3_6 = null;
                } else if (this.expectSingleResult) {
                    if (uncompressedData.size() != 1) throw new MessagingException(message, String.format("The UnZip operation extracted %s result objects but expectSingleResult was 'true'.", uncompressedData.size()));
                    Object v = uncompressedData.values().iterator().next();
                } else {
                    TreeMap treeMap = uncompressedData;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                if (payload instanceof File && this.deleteFiles && !(filePayload = (File)payload).delete() && logger.isWarnEnabled() && logger.isWarnEnabled()) {
                    logger.warn((Object)("failed to delete File '" + filePayload + "'"));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return var3_9;
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, "Failed to apply Zip transformation.", (Throwable)e);
        }
    }

    private static void mkDirOfAncestorDirectories(File destinationFile) {
        File parentDirectory = destinationFile.getParentFile();
        if (parentDirectory != null) {
            parentDirectory.mkdirs();
        }
    }
}

