/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zip.transformer;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipException;

public class SpringZipUtils {
    private static final Log logger = LogFactory.getLog(SpringZipUtils.class);

    public static byte[] pack(Collection<ZipEntrySource> entries, int compressionLevel) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Creating byte array from '%s'.", entries));
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SpringZipUtils.pack(entries, outputStream, compressionLevel);
        return outputStream.toByteArray();
    }

    public static void pack(Collection<ZipEntrySource> entries, File zip, int compressionLevel) {
        FileOutputStream outputStream;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating '" + zip + "' from " + entries + "."));
        }
        try {
            outputStream = new FileOutputStream(zip);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(String.format("File '%s' not found.", zip.getAbsolutePath()), e);
        }
        SpringZipUtils.pack(entries, outputStream, compressionLevel);
    }

    private static void pack(Collection<ZipEntrySource> entries, OutputStream outputStream, int compressionLevel) {
        ZipOutputStream out = null;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            out = new ZipOutputStream(bufferedOutputStream);
            out.setLevel(compressionLevel);
            for (ZipEntrySource entry : entries) {
                SpringZipUtils.addEntry(entry, out);
            }
        }
        catch (IOException e) {
            try {
                throw SpringZipUtils.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static void addEntry(ZipEntrySource entry, ZipOutputStream out) throws IOException {
        out.putNextEntry(entry.getEntry());
        InputStream in = entry.getInputStream();
        if (in != null) {
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        out.closeEntry();
    }

    private static ZipException rethrow(IOException e) {
        throw new ZipException((Exception)e);
    }

    public static void copy(InputStream in, File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public byte[] copy(InputStream in) throws IOException {
        return IOUtils.toByteArray((InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isValid(File file) {
        boolean bl;
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(file);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipfile);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)zipfile);
            return bl2;
        }
        IOUtils.closeQuietly((Closeable)zipfile);
        return bl;
    }
}

