/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.xpath;

import org.jspecify.annotations.Nullable;
import org.springframework.xml.xpath.XPathExpression;
import org.w3c.dom.Node;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum XPathEvaluationType {
    BOOLEAN_RESULT{

        @Override
        public Object evaluateXPath(XPathExpression expression, Node node) {
            return expression.evaluateAsBoolean(node);
        }
    }
    ,
    STRING_RESULT{

        @Override
        public @Nullable Object evaluateXPath(XPathExpression expression, Node node) {
            return expression.evaluateAsString(node);
        }
    }
    ,
    NUMBER_RESULT{

        @Override
        public Object evaluateXPath(XPathExpression expression, Node node) {
            return expression.evaluateAsNumber(node);
        }
    }
    ,
    NODE_RESULT{

        @Override
        public @Nullable Object evaluateXPath(XPathExpression expression, Node node) {
            return expression.evaluateAsNode(node);
        }
    }
    ,
    NODE_LIST_RESULT{

        @Override
        public Object evaluateXPath(XPathExpression expression, Node node) {
            return expression.evaluateAsNodeList(node);
        }
    };


    public abstract @Nullable Object evaluateXPath(XPathExpression var1, Node var2);
}

