/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.selector;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.integration.MessageRejectedException;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.xml.AggregatedXmlMessageValidationException;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;

public class XmlValidatingMessageSelector
implements MessageSelector {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final XmlValidator xmlValidator;
    private volatile boolean throwExceptionOnRejection;
    private volatile XmlPayloadConverter converter = new DefaultXmlPayloadConverter();

    public XmlValidatingMessageSelector(XmlValidator xmlValidator) {
        Assert.notNull((Object)xmlValidator, (String)"XmlValidator must not be null");
        this.xmlValidator = xmlValidator;
    }

    public XmlValidatingMessageSelector(Resource schema, SchemaType schemaType) throws IOException {
        Assert.notNull((Object)schema, (String)"You must provide XML schema location to perform validation");
        if (schemaType == null) {
            schemaType = SchemaType.XML_SCHEMA;
        }
        this.xmlValidator = XmlValidatorFactory.createValidator((Resource)schema, (String)schemaType.getUrl());
    }

    public XmlValidatingMessageSelector(Resource schema, String schemaType) throws IOException {
        this(schema, StringUtils.isEmpty((Object)schemaType) ? null : SchemaType.valueOf(schemaType.toUpperCase().replaceFirst("-", "_")));
    }

    public void setThrowExceptionOnRejection(boolean throwExceptionOnRejection) {
        this.throwExceptionOnRejection = throwExceptionOnRejection;
    }

    public void setConverter(XmlPayloadConverter converter) {
        Assert.notNull((Object)converter, (String)"'converter' must not be null");
        this.converter = converter;
    }

    public boolean accept(Message<?> message) {
        Object[] validationExceptions = null;
        try {
            validationExceptions = this.xmlValidator.validate(this.converter.convertToSource(message.getPayload()));
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, (Throwable)e);
        }
        boolean validationSuccess = ObjectUtils.isEmpty((Object[])validationExceptions);
        if (!validationSuccess) {
            if (this.throwExceptionOnRejection) {
                throw new MessageRejectedException(message, "Message was rejected due to XML Validation errors", (Throwable)new AggregatedXmlMessageValidationException(Arrays.asList(validationExceptions)));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Message was rejected due to XML Validation errors");
            }
        }
        return validationSuccess;
    }

    public static enum SchemaType {
        XML_SCHEMA("http://www.w3.org/2001/XMLSchema"),
        RELAX_NG("http://relaxng.org/ns/structure/1.0");

        private final String url;

        private SchemaType(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

