/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractTransformerParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.xml.transformer.XPathHeaderEnricher;
import org.springframework.integration.xml.transformer.support.XPathExpressionEvaluatingHeaderValueMessageProcessor;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathHeaderEnricherParser
extends AbstractTransformerParser {
    protected final String getTransformerClassName() {
        return XPathHeaderEnricher.class.getName();
    }

    protected void parseTransformer(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedMap headers = new ManagedMap();
        this.processHeaders(element, (ManagedMap<String, Object>)headers, parserContext);
        builder.addConstructorArgValue((Object)headers);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"default-overwrite");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"should-skip-nulls");
    }

    protected void processHeaders(Element element, ManagedMap<String, Object> headers, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            boolean isExpressionRef;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element headerElement = (Element)node;
            String elementName = node.getLocalName();
            if (!"header".equals(elementName)) continue;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XPathExpressionEvaluatingHeaderValueMessageProcessor.class);
            String expressionString = headerElement.getAttribute("xpath-expression");
            String expressionRef = headerElement.getAttribute("xpath-expression-ref");
            boolean isExpressionString = StringUtils.hasText((String)expressionString);
            if (!(isExpressionString ^ (isExpressionRef = StringUtils.hasText((String)expressionRef)))) {
                parserContext.getReaderContext().error("Exactly one of the 'xpath-expression' or 'xpath-expression-ref' attributes is required.", source);
            }
            if (isExpressionString) {
                builder.addConstructorArgValue((Object)expressionString);
            } else {
                builder.addConstructorArgReference(expressionRef);
            }
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)headerElement, (String)"evaluation-type");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)headerElement, (String)"overwrite");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)headerElement, (String)"header-type");
            String headerName = headerElement.getAttribute("name");
            headers.put((Object)headerName, (Object)builder.getBeanDefinition());
        }
    }
}

