/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.selector;

import java.util.Map;
import org.springframework.integration.xml.selector.AbstractXPathMessageSelector;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.xpath.XPathExpression;
import org.w3c.dom.Node;

public class RegexTestXPathMessageSelector
extends AbstractXPathMessageSelector {
    private final String regex;

    public RegexTestXPathMessageSelector(String expression, Map<String, String> namespaces, String regex) {
        super(expression, namespaces);
        Assert.notNull((Object)regex, (String)"regex must not be null");
        this.regex = regex;
    }

    public RegexTestXPathMessageSelector(String expression, String prefix, String namespace, String regex) {
        super(expression, prefix, namespace);
        Assert.notNull((Object)regex, (String)"regex must not be null");
        this.regex = regex;
    }

    public RegexTestXPathMessageSelector(String expression, String regex) {
        super(expression);
        Assert.notNull((Object)regex, (String)"regex must not be null");
        this.regex = regex;
    }

    public RegexTestXPathMessageSelector(XPathExpression expression, String regex) {
        super(expression);
        Assert.notNull((Object)regex, (String)"regex must not be null");
        this.regex = regex;
    }

    public boolean accept(Message<?> message) {
        Node nodeToTest = this.getConverter().convertToNode(message.getPayload());
        String xPathResult = this.getXPathExpresion().evaluateAsString(nodeToTest);
        return StringUtils.hasText((String)xPathResult) ? xPathResult.matches(this.regex) : false;
    }
}

