/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.outbound;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.transform.TransformerException;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionEvalMap;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.ws.DefaultSoapHeaderMapper;
import org.springframework.integration.ws.SoapHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.transform.TransformerObjectSupport;

public abstract class AbstractWebServiceOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final Lock lock = new ReentrantLock();
    protected final DefaultUriBuilderFactory uriFactory = new DefaultUriBuilderFactory();
    private final @Nullable String uri;
    private final @Nullable DestinationProvider destinationProvider;
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private StandardEvaluationContext evaluationContext;
    private @Nullable WebServiceMessageCallback requestCallback;
    private WebServiceTemplate webServiceTemplate;
    private boolean ignoreEmptyResponses = true;
    private SoapHeaderMapper headerMapper = new DefaultSoapHeaderMapper();
    private boolean webServiceTemplateExplicitlySet;

    public AbstractWebServiceOutboundGateway(@Nullable String uri, @Nullable WebServiceMessageFactory messageFactory) {
        Assert.hasText((String)uri, (String)"URI must not be empty");
        this.webServiceTemplate = messageFactory != null ? new WebServiceTemplate(messageFactory) : new WebServiceTemplate();
        this.destinationProvider = null;
        this.uri = uri;
    }

    public AbstractWebServiceOutboundGateway(DestinationProvider destinationProvider, @Nullable WebServiceMessageFactory messageFactory) {
        Assert.notNull((Object)destinationProvider, (String)"DestinationProvider must not be null");
        this.webServiceTemplate = messageFactory != null ? new WebServiceTemplate(messageFactory) : new WebServiceTemplate();
        this.destinationProvider = destinationProvider;
        this.webServiceTemplate.setDestinationProvider(destinationProvider);
        this.uri = null;
    }

    public void setHeaderMapper(SoapHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"'headerMapper' must not be null");
        this.headerMapper = headerMapper;
    }

    public void setUriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        this.lock.lock();
        try {
            this.uriVariableExpressions.clear();
            this.uriVariableExpressions.putAll(uriVariableExpressions);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setEncodingMode(DefaultUriBuilderFactory.EncodingMode encodingMode) {
        Assert.notNull((Object)encodingMode, (String)"'encodingMode' must not be null");
        this.uriFactory.setEncodingMode(encodingMode);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public void setIgnoreEmptyResponses(boolean ignoreEmptyResponses) {
        this.ignoreEmptyResponses = ignoreEmptyResponses;
    }

    public void setWebServiceTemplate(WebServiceTemplate webServiceTemplate) {
        this.doSetWebServiceTemplate(webServiceTemplate);
    }

    protected final void doSetWebServiceTemplate(WebServiceTemplate template) {
        Assert.notNull((Object)template, (String)"'webServiceTemplate' must not be null");
        this.webServiceTemplate = template;
        this.webServiceTemplateExplicitlySet = true;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        Assert.state((!this.webServiceTemplateExplicitlySet ? 1 : 0) != 0, () -> "'messageFactory' must be specified on the provided: " + String.valueOf(this.webServiceTemplate));
        this.webServiceTemplate.setMessageFactory(messageFactory);
    }

    public void setRequestCallback(@Nullable WebServiceMessageCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public void setFaultMessageResolver(FaultMessageResolver faultMessageResolver) {
        Assert.state((!this.webServiceTemplateExplicitlySet ? 1 : 0) != 0, () -> "'faultMessageResolver' must be specified on the provided: " + String.valueOf(this.webServiceTemplate));
        this.webServiceTemplate.setFaultMessageResolver(faultMessageResolver);
    }

    public void setMessageSenders(WebServiceMessageSender ... messageSenders) {
        Assert.state((!this.webServiceTemplateExplicitlySet ? 1 : 0) != 0, () -> "'messageSenders' must be specified on the provided: " + String.valueOf(this.webServiceTemplate));
        this.webServiceTemplate.setMessageSenders(messageSenders);
    }

    public void setInterceptors(ClientInterceptor ... interceptors) {
        Assert.state((!this.webServiceTemplateExplicitlySet ? 1 : 0) != 0, () -> "'interceptors' must be specified on the provided: " + String.valueOf(this.webServiceTemplate));
        this.webServiceTemplate.setInterceptors(interceptors);
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        Assert.state((this.destinationProvider == null || CollectionUtils.isEmpty(this.uriVariableExpressions) ? 1 : 0) != 0, (String)"uri variables are not supported when a DestinationProvider is supplied.");
    }

    protected WebServiceTemplate getWebServiceTemplate() {
        return this.webServiceTemplate;
    }

    public final @Nullable Object handleRequestMessage(Message<?> requestMessage) {
        String string;
        URI uriWithVariables = this.prepareUri(requestMessage);
        if (uriWithVariables == null) {
            throw new MessageDeliveryException(requestMessage, "Failed to determine URI for Web Service request in outbound gateway: " + this.getComponentName());
        }
        Object responsePayload = this.doHandle(uriWithVariables.toString(), requestMessage, this.requestCallback);
        if (!(responsePayload == null || this.ignoreEmptyResponses && responsePayload instanceof String && !StringUtils.hasText((String)(string = (String)responsePayload)))) {
            return responsePayload;
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable URI prepareUri(Message<?> requestMessage) {
        if (this.destinationProvider != null) {
            return this.destinationProvider.getDestination();
        }
        @Nullable ExpressionEvalMap uriVariables = ExpressionEvalMap.from(this.uriVariableExpressions).usingEvaluationContext((EvaluationContext)this.evaluationContext).withRoot(requestMessage).build();
        Assert.notNull((Object)this.uri, (String)"'uri' must not be null");
        return this.uriFactory.expand(this.uri, (Map)uriVariables);
    }

    protected abstract @Nullable Object doHandle(String var1, Message<?> var2, @Nullable WebServiceMessageCallback var3);

    protected abstract class ResponseMessageExtractor
    extends TransformerObjectSupport
    implements WebServiceMessageExtractor<Object> {
        protected ResponseMessageExtractor() {
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable Object extractData(WebServiceMessage message) throws IOException, TransformerException {
            Object resultObject = this.doExtractData(message);
            if (resultObject != null && message instanceof SoapMessage) {
                SoapMessage soapMessage = (SoapMessage)message;
                @Nullable Map mappedMessageHeaders = AbstractWebServiceOutboundGateway.this.headerMapper.toHeadersFromReply(soapMessage);
                return AbstractWebServiceOutboundGateway.this.getMessageBuilderFactory().withPayload(resultObject).copyHeaders(mappedMessageHeaders).build();
            }
            return resultObject;
        }

        public abstract @Nullable Object doExtractData(WebServiceMessage var1) throws IOException, TransformerException;
    }

    protected abstract class RequestMessageCallback
    extends TransformerObjectSupport
    implements WebServiceMessageCallback {
        private final @Nullable WebServiceMessageCallback reqCallback;
        private final Message<?> requestMessage;

        public RequestMessageCallback(WebServiceMessageCallback requestCallback, Message<?> requestMessage) {
            this.reqCallback = requestCallback;
            this.requestMessage = requestMessage;
        }

        public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
            Object payload = this.requestMessage.getPayload();
            this.doWithMessageInternal(message, payload);
            if (message instanceof SoapMessage) {
                SoapMessage soapMessage = (SoapMessage)message;
                AbstractWebServiceOutboundGateway.this.headerMapper.fromHeadersToRequest(this.requestMessage.getHeaders(), soapMessage);
            }
            if (this.reqCallback != null) {
                this.reqCallback.doWithMessage(message);
            }
        }

        public abstract void doWithMessageInternal(WebServiceMessage var1, Object var2) throws IOException, TransformerException;
    }
}

