/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.dsl;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.ws.dsl.BaseWsOutboundGatewaySpec;
import org.springframework.integration.ws.outbound.SimpleWebServiceOutboundGateway;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.SourceExtractor;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class SimpleWsOutboundGatewaySpec
extends BaseWsOutboundGatewaySpec<SimpleWsOutboundGatewaySpec, SimpleWebServiceOutboundGateway> {
    protected @Nullable SourceExtractor<?> sourceExtractor;

    protected SimpleWsOutboundGatewaySpec(WebServiceTemplate template) {
        this.template = template;
    }

    public SimpleWsOutboundGatewaySpec sourceExtractor(SourceExtractor<?> extractor) {
        this.sourceExtractor = extractor;
        return this;
    }

    public SimpleWsOutboundGatewaySpec extractPayload(boolean extract) {
        this.extractPayload = extract;
        return this;
    }

    @Override
    protected SimpleWebServiceOutboundGateway assemble(SimpleWebServiceOutboundGateway gateway) {
        SimpleWebServiceOutboundGateway assembled = super.assemble(gateway);
        assembled.setExtractPayload(this.extractPayload);
        return assembled;
    }

    @Override
    protected SimpleWebServiceOutboundGateway create() {
        SimpleWebServiceOutboundGateway gateway = this.destinationProvider != null ? new SimpleWebServiceOutboundGateway(this.destinationProvider, this.sourceExtractor, this.webServiceMessageFactory) : new SimpleWebServiceOutboundGateway(this.uri, this.sourceExtractor, this.webServiceMessageFactory);
        gateway.setWebServiceTemplate(this.template);
        return gateway;
    }

    public static class SimpleWsOutboundGatewayNoTemplateSpec
    extends BaseWsOutboundGatewaySpec<SimpleWsOutboundGatewayNoTemplateSpec, SimpleWebServiceOutboundGateway> {
        protected @Nullable SourceExtractor<?> sourceExtractor;
        private boolean extractPayload = true;

        public SimpleWsOutboundGatewayNoTemplateSpec sourceExtractor(SourceExtractor<?> extractor) {
            this.sourceExtractor = extractor;
            return this;
        }

        public SimpleWsOutboundGatewayNoTemplateSpec messageFactory(WebServiceMessageFactory messageFactory) {
            this.webServiceMessageFactory = messageFactory;
            return this;
        }

        public SimpleWsOutboundGatewayNoTemplateSpec faultMessageResolver(FaultMessageResolver resolver) {
            this.faultMessageResolver = resolver;
            return this;
        }

        public SimpleWsOutboundGatewayNoTemplateSpec messageSenders(WebServiceMessageSender ... senders) {
            this.messageSenders = Arrays.copyOf(senders, senders.length);
            return this;
        }

        public SimpleWsOutboundGatewayNoTemplateSpec interceptors(ClientInterceptor ... interceptors) {
            this.gatewayInterceptors = Arrays.copyOf(interceptors, interceptors.length);
            return this;
        }

        public SimpleWsOutboundGatewayNoTemplateSpec extractPayload(boolean extract) {
            this.extractPayload = extract;
            return this;
        }

        @Override
        protected SimpleWebServiceOutboundGateway create() {
            if (this.destinationProvider != null) {
                return new SimpleWebServiceOutboundGateway(this.destinationProvider, this.sourceExtractor, this.webServiceMessageFactory);
            }
            return new SimpleWebServiceOutboundGateway(this.uri, this.sourceExtractor, this.webServiceMessageFactory);
        }

        @Override
        protected SimpleWebServiceOutboundGateway assemble(SimpleWebServiceOutboundGateway gateway) {
            SimpleWebServiceOutboundGateway assembled = super.assemble(gateway);
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.faultMessageResolver, assembled::setFaultMessageResolver).acceptIfNotNull((Object)this.messageSenders, assembled::setMessageSenders).acceptIfNotNull((Object)this.gatewayInterceptors, assembled::setInterceptors);
            assembled.setExtractPayload(this.extractPayload);
            return assembled;
        }
    }
}

