/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionEvalMap;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.ws.DefaultSoapHeaderMapper;
import org.springframework.integration.ws.SoapHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.transform.TransformerObjectSupport;

public abstract class AbstractWebServiceOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final WebServiceTemplate webServiceTemplate;
    private final String uri;
    private final DestinationProvider destinationProvider;
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private volatile StandardEvaluationContext evaluationContext;
    private volatile WebServiceMessageCallback requestCallback;
    private volatile boolean ignoreEmptyResponses = true;
    private volatile boolean encodeUri = true;
    protected volatile SoapHeaderMapper headerMapper = new DefaultSoapHeaderMapper();

    public AbstractWebServiceOutboundGateway(String uri, WebServiceMessageFactory messageFactory) {
        Assert.hasText((String)uri, (String)"URI must not be empty");
        this.webServiceTemplate = new WebServiceTemplate(messageFactory);
        this.destinationProvider = null;
        this.uri = uri;
    }

    public AbstractWebServiceOutboundGateway(DestinationProvider destinationProvider, WebServiceMessageFactory messageFactory) {
        Assert.notNull((Object)destinationProvider, (String)"DestinationProvider must not be null");
        this.webServiceTemplate = new WebServiceTemplate(messageFactory);
        this.destinationProvider = destinationProvider;
        this.webServiceTemplate.setDestinationProvider(destinationProvider);
        this.uri = null;
    }

    public void setHeaderMapper(SoapHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        Map<String, Expression> map = this.uriVariableExpressions;
        synchronized (map) {
            this.uriVariableExpressions.clear();
            this.uriVariableExpressions.putAll(uriVariableExpressions);
        }
    }

    public void setEncodeUri(boolean encodeUri) {
        this.encodeUri = encodeUri;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public void setIgnoreEmptyResponses(boolean ignoreEmptyResponses) {
        this.ignoreEmptyResponses = ignoreEmptyResponses;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.webServiceTemplate.setMessageFactory(messageFactory);
    }

    public void setRequestCallback(WebServiceMessageCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public void setFaultMessageResolver(FaultMessageResolver faultMessageResolver) {
        this.webServiceTemplate.setFaultMessageResolver(faultMessageResolver);
    }

    public void setMessageSender(WebServiceMessageSender messageSender) {
        this.webServiceTemplate.setMessageSender(messageSender);
    }

    public void setMessageSenders(WebServiceMessageSender ... messageSenders) {
        this.webServiceTemplate.setMessageSenders(messageSenders);
    }

    public void setInterceptors(ClientInterceptor ... interceptors) {
        this.webServiceTemplate.setInterceptors(interceptors);
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        Assert.state((this.destinationProvider == null || CollectionUtils.isEmpty(this.uriVariableExpressions) ? 1 : 0) != 0, (String)"uri variables are not supported when a DestinationProvider is supplied.");
    }

    protected WebServiceTemplate getWebServiceTemplate() {
        return this.webServiceTemplate;
    }

    public final Object handleRequestMessage(Message<?> requestMessage) {
        URI uri = null;
        try {
            uri = this.prepareUri(requestMessage);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (uri == null) {
            throw new MessageDeliveryException(requestMessage, "Failed to determine URI for Web Service request in outbound gateway: " + this.getComponentName());
        }
        Object responsePayload = this.doHandle(uri.toString(), requestMessage, this.requestCallback);
        if (responsePayload != null) {
            boolean shouldIgnore;
            boolean bl = shouldIgnore = this.ignoreEmptyResponses && responsePayload instanceof String && !StringUtils.hasText((String)((String)responsePayload));
            if (!shouldIgnore) {
                return responsePayload;
            }
        }
        return null;
    }

    private URI prepareUri(Message<?> requestMessage) throws URISyntaxException {
        if (this.destinationProvider != null) {
            return this.destinationProvider.getDestination();
        }
        ExpressionEvalMap uriVariables = ExpressionEvalMap.from(this.uriVariableExpressions).usingEvaluationContext((EvaluationContext)this.evaluationContext).withRoot(requestMessage).build();
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)this.uri).buildAndExpand((Map)uriVariables);
        return this.encodeUri ? uriComponents.toUri() : new URI(uriComponents.toUriString());
    }

    protected abstract Object doHandle(String var1, Message<?> var2, WebServiceMessageCallback var3);

    protected abstract class ResponseMessageExtractor
    extends TransformerObjectSupport
    implements WebServiceMessageExtractor<Object> {
        protected ResponseMessageExtractor() {
        }

        public Object extractData(WebServiceMessage message) throws IOException, TransformerException {
            Object resultObject = this.doExtractData(message);
            if (resultObject != null && message instanceof SoapMessage) {
                Map mappedMessageHeaders = AbstractWebServiceOutboundGateway.this.headerMapper.toHeadersFromReply((SoapMessage)message);
                return AbstractWebServiceOutboundGateway.this.getMessageBuilderFactory().withPayload(resultObject).copyHeaders(mappedMessageHeaders).build();
            }
            return resultObject;
        }

        public abstract Object doExtractData(WebServiceMessage var1) throws IOException, TransformerException;
    }

    protected abstract class RequestMessageCallback
    extends TransformerObjectSupport
    implements WebServiceMessageCallback {
        private final WebServiceMessageCallback requestCallback;
        private final Message<?> requestMessage;

        public RequestMessageCallback(WebServiceMessageCallback requestCallback, Message<?> requestMessage) {
            this.requestCallback = requestCallback;
            this.requestMessage = requestMessage;
        }

        public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
            Object payload = this.requestMessage.getPayload();
            this.doWithMessageInternal(message, payload);
            if (message instanceof SoapMessage) {
                AbstractWebServiceOutboundGateway.this.headerMapper.fromHeadersToRequest(this.requestMessage.getHeaders(), (SoapMessage)message);
            }
            if (this.requestCallback != null) {
                this.requestCallback.doWithMessage(message);
            }
        }

        public abstract void doWithMessageInternal(WebServiceMessage var1, Object var2) throws IOException, TransformerException;
    }
}

