/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractInboundGatewayParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.ws.DefaultSoapHeaderMapper;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class WebServiceInboundGatewayParser
extends AbstractInboundGatewayParser {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected String getBeanClassName(Element element) {
        String simpleClassName = StringUtils.hasText((String)element.getAttribute("marshaller")) ? "MarshallingWebServiceInboundGateway" : "SimpleWebServiceInboundGateway";
        return "org.springframework.integration.ws." + simpleClassName;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !attributeName.endsWith("marshaller") && super.isEligibleAttribute(attributeName);
    }

    protected void doPostProcess(BeanDefinitionBuilder builder, Element element) {
        String extractPayload;
        String marshallerRef = element.getAttribute("marshaller");
        String unmarshallerRef = element.getAttribute("unmarshaller");
        if (StringUtils.hasText((String)marshallerRef)) {
            builder.addConstructorArgReference(marshallerRef);
            if (StringUtils.hasText((String)unmarshallerRef)) {
                builder.addConstructorArgReference(unmarshallerRef);
            }
        } else if (StringUtils.hasText((String)unmarshallerRef)) {
            throw new IllegalArgumentException("An 'unmarshaller' is not allowed without 'marshaller'.");
        }
        if ((StringUtils.hasText((String)marshallerRef) || StringUtils.hasText((String)unmarshallerRef)) && StringUtils.hasText((String)(extractPayload = element.getAttribute("extract-payload")))) {
            this.logger.warn((Object)"Setting 'extract-payload' attribute has no effect when used with a marshalling Web Service Inbound Gateway.");
        }
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        IntegrationNamespaceUtils.configureHeaderMapper((Element)element, (BeanDefinitionBuilder)builder, (ParserContext)parserContext, DefaultSoapHeaderMapper.class, null);
    }
}

