/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.ws.DefaultSoapHeaderMapper;
import org.springframework.integration.ws.SoapHeaderMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriTemplate;
import org.springframework.web.util.UriUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.transform.TransformerObjectSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebServiceOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final WebServiceTemplate webServiceTemplate;
    private final UriTemplate uriTemplate;
    private final DestinationProvider destinationProvider;
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private volatile WebServiceMessageCallback requestCallback;
    private volatile boolean ignoreEmptyResponses = true;
    protected volatile SoapHeaderMapper headerMapper = new DefaultSoapHeaderMapper();

    public AbstractWebServiceOutboundGateway(String uri, WebServiceMessageFactory messageFactory) {
        Assert.hasText((String)uri, (String)"URI must not be empty");
        this.webServiceTemplate = messageFactory != null ? new WebServiceTemplate(messageFactory) : new WebServiceTemplate();
        this.destinationProvider = null;
        this.uriTemplate = new HttpUrlTemplate(uri);
    }

    public AbstractWebServiceOutboundGateway(DestinationProvider destinationProvider, WebServiceMessageFactory messageFactory) {
        Assert.notNull((Object)destinationProvider, (String)"DestinationProvider must not be null");
        this.webServiceTemplate = messageFactory != null ? new WebServiceTemplate(messageFactory) : new WebServiceTemplate();
        this.destinationProvider = destinationProvider;
        this.webServiceTemplate.setDestinationProvider(destinationProvider);
        this.uriTemplate = null;
    }

    public void setHeaderMapper(SoapHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        Map<String, Expression> map = this.uriVariableExpressions;
        synchronized (map) {
            this.uriVariableExpressions.clear();
            this.uriVariableExpressions.putAll(uriVariableExpressions);
        }
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public void setIgnoreEmptyResponses(boolean ignoreEmptyResponses) {
        this.ignoreEmptyResponses = ignoreEmptyResponses;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.webServiceTemplate.setMessageFactory(messageFactory);
    }

    public void setRequestCallback(WebServiceMessageCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public void setFaultMessageResolver(FaultMessageResolver faultMessageResolver) {
        this.webServiceTemplate.setFaultMessageResolver(faultMessageResolver);
    }

    public void setMessageSender(WebServiceMessageSender messageSender) {
        this.webServiceTemplate.setMessageSender(messageSender);
    }

    public void setMessageSenders(WebServiceMessageSender[] messageSenders) {
        this.webServiceTemplate.setMessageSenders(messageSenders);
    }

    public void setInterceptors(ClientInterceptor[] interceptors) {
        this.webServiceTemplate.setInterceptors(interceptors);
    }

    public void onInit() {
        ConversionService conversionService;
        super.onInit();
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        if ((conversionService = this.getConversionService()) != null) {
            this.evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        this.evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    protected WebServiceTemplate getWebServiceTemplate() {
        return this.webServiceTemplate;
    }

    public final Object handleRequestMessage(Message<?> requestMessage) {
        URI uri = this.prepareUri(requestMessage);
        if (uri == null) {
            throw new MessageDeliveryException(requestMessage, "Failed to determine URI for Web Service request in outbound gateway: " + this.getComponentName());
        }
        Object responsePayload = this.doHandle(uri.toString(), requestMessage, this.requestCallback);
        if (responsePayload != null) {
            boolean shouldIgnore;
            boolean bl = shouldIgnore = this.ignoreEmptyResponses && responsePayload instanceof String && !StringUtils.hasText((String)((String)responsePayload));
            if (!shouldIgnore) {
                return responsePayload;
            }
        }
        return null;
    }

    protected abstract Object doHandle(String var1, Message<?> var2, WebServiceMessageCallback var3);

    private URI prepareUri(Message<?> requestMessage) {
        if (this.destinationProvider != null) {
            return this.destinationProvider.getDestination();
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        for (Map.Entry<String, Expression> entry : this.uriVariableExpressions.entrySet()) {
            Object value = entry.getValue().getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
            uriVariables.put(entry.getKey(), value);
        }
        return this.uriTemplate.expand(uriVariables);
    }

    private static class HttpUrlTemplate
    extends UriTemplate {
        public HttpUrlTemplate(String uriTemplate) {
            super(uriTemplate);
        }

        protected URI encodeUri(String uri) {
            try {
                String encoded = UriUtils.encodeHttpUrl((String)uri, (String)"UTF-8");
                return new URI(encoded);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Could not create HTTP URL from [" + uri + "]: " + ex, ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ResponseMessageExtractor
    extends TransformerObjectSupport
    implements WebServiceMessageExtractor<Object> {
        protected ResponseMessageExtractor() {
        }

        public Object extractData(WebServiceMessage message) throws IOException, TransformerException {
            Object resultObject = this.doExtractData(message);
            if (message instanceof SoapMessage) {
                Map mappedMessageHeaders = AbstractWebServiceOutboundGateway.this.headerMapper.toHeadersFromReply((SoapMessage)message);
                Message siMessage = MessageBuilder.withPayload((Object)resultObject).copyHeaders(mappedMessageHeaders).build();
                return siMessage;
            }
            return message.getPayloadSource();
        }

        public abstract Object doExtractData(WebServiceMessage var1) throws IOException, TransformerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class RequestMessageCallback
    extends TransformerObjectSupport
    implements WebServiceMessageCallback {
        private final WebServiceMessageCallback requestCallback;
        private final Message<?> requestMessage;

        public RequestMessageCallback(WebServiceMessageCallback requestCallback, Message<?> requestMessage) {
            this.requestCallback = requestCallback;
            this.requestMessage = requestMessage;
        }

        public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
            Object payload = this.requestMessage.getPayload();
            if (message instanceof SoapMessage) {
                this.doWithMessageInternal(message, payload);
                AbstractWebServiceOutboundGateway.this.headerMapper.fromHeadersToRequest(this.requestMessage.getHeaders(), (SoapMessage)message);
                if (this.requestCallback != null) {
                    this.requestCallback.doWithMessage(message);
                }
            }
        }

        public abstract void doWithMessageInternal(WebServiceMessage var1, Object var2) throws IOException, TransformerException;
    }
}

