/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.websocket.config.IntegrationDynamicWebSocketHandlerMapping;
import org.springframework.integration.websocket.config.IntegrationServletWebSocketHandlerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketConfiguration;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.util.pattern.PathPatternParser;

public class WebSocketIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final Log LOGGER = LogFactory.getLog(WebSocketIntegrationConfigurationInitializer.class);
    private static final boolean SERVLET_PRESENT = ClassUtils.isPresent((String)"javax.servlet.Servlet", null);
    private static final String WEB_SOCKET_HANDLER_MAPPING_BEAN_NAME = "integrationWebSocketHandlerMapping";

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerEnableWebSocketIfNecessary((BeanDefinitionRegistry)beanFactory);
        } else {
            LOGGER.warn((Object)"'DelegatingWebSocketConfiguration' isn't registered because 'beanFactory' isn't an instance of `BeanDefinitionRegistry`.");
        }
    }

    private void registerEnableWebSocketIfNecessary(BeanDefinitionRegistry registry) {
        if (SERVLET_PRESENT) {
            BeanDefinitionBuilder beanDefinitionBuilder;
            if (!registry.containsBeanDefinition("defaultSockJsTaskScheduler")) {
                beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ThreadPoolTaskScheduler.class, ThreadPoolTaskScheduler::new).addPropertyValue("threadNamePrefix", (Object)"SockJS-").addPropertyValue("poolSize", (Object)Runtime.getRuntime().availableProcessors()).addPropertyValue("removeOnCancelPolicy", (Object)true);
                registry.registerBeanDefinition("defaultSockJsTaskScheduler", (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
            }
            if (!registry.containsBeanDefinition(DelegatingWebSocketConfiguration.class.getName()) && !registry.containsBeanDefinition(WEB_SOCKET_HANDLER_MAPPING_BEAN_NAME)) {
                registry.registerBeanDefinition("integrationServletWebSocketHandlerRegistry", (BeanDefinition)new RootBeanDefinition(IntegrationServletWebSocketHandlerRegistry.class, IntegrationServletWebSocketHandlerRegistry::new));
                beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationDynamicWebSocketHandlerMapping.class, IntegrationDynamicWebSocketHandlerMapping::new).addPropertyValue("patternParser", (Object)new PathPatternParser()).addPropertyValue("order", (Object)0);
                BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinitionBuilder.getBeanDefinition(), (BeanDefinitionRegistry)registry);
                BeanDefinitionBuilder enableWebSocketBuilder = BeanDefinitionBuilder.genericBeanDefinition(WebSocketHandlerMappingFactoryBean.class, WebSocketHandlerMappingFactoryBean::new).addPropertyReference("registry", "integrationServletWebSocketHandlerRegistry").addPropertyReference("sockJsTaskScheduler", "defaultSockJsTaskScheduler").setRole(2);
                registry.registerBeanDefinition(WEB_SOCKET_HANDLER_MAPPING_BEAN_NAME, (BeanDefinition)enableWebSocketBuilder.getBeanDefinition());
            }
        }
    }

    static class WebSocketHandlerMappingFactoryBean
    extends AbstractFactoryBean<HandlerMapping> {
        private IntegrationServletWebSocketHandlerRegistry registry;
        private ThreadPoolTaskScheduler sockJsTaskScheduler;

        WebSocketHandlerMappingFactoryBean() {
        }

        public void setRegistry(IntegrationServletWebSocketHandlerRegistry registry) {
            this.registry = registry;
        }

        public void setSockJsTaskScheduler(ThreadPoolTaskScheduler sockJsTaskScheduler) {
            this.sockJsTaskScheduler = sockJsTaskScheduler;
        }

        protected HandlerMapping createInstance() {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                ((ListableBeanFactory)beanFactory).getBeansOfType(WebSocketConfigurer.class).values().forEach(configurer -> configurer.registerWebSocketHandlers((WebSocketHandlerRegistry)this.registry));
            }
            this.registry.setTaskScheduler((TaskScheduler)this.sockJsTaskScheduler);
            return this.registry.getHandlerMapping();
        }

        public Class<?> getObjectType() {
            return HandlerMapping.class;
        }
    }
}

