/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.outbound;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.json.JacksonPresent;
import org.springframework.integration.websocket.ClientWebSocketContainer;
import org.springframework.integration.websocket.IntegrationWebSocketContainer;
import org.springframework.integration.websocket.support.PassThruSubProtocolHandler;
import org.springframework.integration.websocket.support.SubProtocolHandlerRegistry;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.SessionLimitExceededException;

public class WebSocketOutboundMessageHandler
extends AbstractMessageHandler {
    private final List<MessageConverter> defaultConverters = new ArrayList<MessageConverter>(3);
    private final CompositeMessageConverter messageConverter;
    private final IntegrationWebSocketContainer webSocketContainer;
    private final SubProtocolHandlerRegistry subProtocolHandlerRegistry;
    private final boolean client;
    private List<MessageConverter> messageConverters;
    private boolean mergeWithDefaultConverters;

    public WebSocketOutboundMessageHandler(IntegrationWebSocketContainer webSocketContainer) {
        this(webSocketContainer, new SubProtocolHandlerRegistry(new PassThruSubProtocolHandler()));
    }

    public WebSocketOutboundMessageHandler(IntegrationWebSocketContainer webSocketContainer, SubProtocolHandlerRegistry protocolHandlerRegistry) {
        this.defaultConverters.add((MessageConverter)new StringMessageConverter());
        this.defaultConverters.add((MessageConverter)new ByteArrayMessageConverter());
        if (JacksonPresent.isJackson2Present()) {
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            this.defaultConverters.add((MessageConverter)converter);
        }
        this.messageConverter = new CompositeMessageConverter(this.defaultConverters);
        this.mergeWithDefaultConverters = false;
        Assert.notNull((Object)webSocketContainer, (String)"'webSocketContainer' must not be null");
        Assert.notNull((Object)protocolHandlerRegistry, (String)"'protocolHandlerRegistry' must not be null");
        this.webSocketContainer = webSocketContainer;
        this.client = webSocketContainer instanceof ClientWebSocketContainer;
        this.subProtocolHandlerRegistry = protocolHandlerRegistry;
        List<String> subProtocols = protocolHandlerRegistry.getSubProtocols();
        this.webSocketContainer.addSupportedProtocols(subProtocols.toArray(new String[0]));
    }

    public void setMessageConverters(List<MessageConverter> messageConverters) {
        Assert.noNullElements((Object[])messageConverters.toArray(), (String)"'messageConverters' must not contain null entries");
        this.messageConverters = new ArrayList<MessageConverter>(messageConverters);
    }

    public void setMergeWithDefaultConverters(boolean mergeWithDefaultConverters) {
        this.mergeWithDefaultConverters = mergeWithDefaultConverters;
    }

    public String getComponentType() {
        return "websocket:outbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        if (!CollectionUtils.isEmpty(this.messageConverters)) {
            List converters = this.messageConverter.getConverters();
            if (this.mergeWithDefaultConverters) {
                ListIterator<MessageConverter> iterator = this.messageConverters.listIterator(this.messageConverters.size());
                while (iterator.hasPrevious()) {
                    MessageConverter converter = iterator.previous();
                    converters.add(0, converter);
                }
            } else {
                converters.clear();
                converters.addAll(this.messageConverters);
            }
        }
    }

    protected void handleMessageInternal(Message<?> message) {
        String sessionId;
        if (!this.client) {
            sessionId = this.subProtocolHandlerRegistry.resolveSessionId(message);
            if (sessionId == null) {
                throw new IllegalArgumentException("The WebSocket 'sessionId' is required in the MessageHeaders");
            }
        } else {
            sessionId = null;
        }
        WebSocketSession session = this.webSocketContainer.getSession(sessionId);
        try {
            SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
            headers.setLeaveMutable(true);
            headers.setMessageTypeIfNotSet(SimpMessageType.MESSAGE);
            Object payload = message.getPayload();
            Message messageToSend = this.messageConverter.toMessage(payload, headers.getMessageHeaders());
            Assert.state((messageToSend != null ? 1 : 0) != 0, () -> "The message converter '" + this.messageConverter + "' produced no message to send based on the request message: '" + message + "'");
            this.subProtocolHandlerRegistry.findProtocolHandler(session).handleMessageToClient(session, messageToSend);
        }
        catch (SessionLimitExceededException ex) {
            try {
                this.logger.error((Throwable)ex, () -> "Terminating session id '" + sessionId + "'");
                this.webSocketContainer.closeSession(session, ex.getStatus());
            }
            catch (Exception secondException) {
                this.logger.error((Throwable)secondException, () -> "Exception terminating session id '" + sessionId + "'");
            }
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, "Failed to handle message in the [" + (Object)((Object)this) + ']', (Throwable)e);
        }
    }
}

