/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.integration.websocket.IntegrationWebSocketContainer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.client.WebSocketClient;

public final class ClientWebSocketContainer
extends IntegrationWebSocketContainer
implements SmartLifecycle {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10;
    private final WebSocketHttpHeaders headers = new WebSocketHttpHeaders();
    private final IntegrationWebSocketConnectionManager connectionManager;
    private volatile CountDownLatch connectionLatch;
    private volatile WebSocketSession clientSession;
    private volatile Throwable openConnectionException;
    private volatile int connectionTimeout = 10;
    private volatile boolean connecting;

    public ClientWebSocketContainer(WebSocketClient client, String uriTemplate, Object ... uriVariables) {
        Assert.notNull((Object)client, (String)"'client' must not be null");
        this.connectionManager = new IntegrationWebSocketConnectionManager(client, uriTemplate, uriVariables);
    }

    public void setOrigin(String origin) {
        this.headers.setOrigin(origin);
    }

    public void setHeadersMap(Map<String, String> headers) {
        Assert.notNull(headers, (String)"'headers' must not be null");
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String[] values;
            for (String v : values = StringUtils.commaDelimitedListToStringArray((String)entry.getValue())) {
                httpHeaders.add(entry.getKey(), v);
            }
        }
        this.setHeaders(httpHeaders);
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers.putAll((Map)headers);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public WebSocketSession getSession(String sessionId) {
        if (this.isRunning()) {
            if (!this.isConnected() && !this.connecting) {
                this.stop();
                this.start();
            }
            try {
                this.connectionLatch.await(this.connectionTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"'clientSession' has not been established during 'openConnection'");
            }
            this.connecting = false;
        }
        try {
            if (this.openConnectionException != null) {
                throw new IllegalStateException(this.openConnectionException);
            }
            Assert.state((this.clientSession != null ? 1 : 0) != 0, (String)"'clientSession' has not been established. Consider to 'start' this container.");
        }
        catch (IllegalStateException e) {
            this.stop();
            throw e;
        }
        return this.clientSession;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.connectionManager.setAutoStartup(autoStartup);
    }

    public void setPhase(int phase) {
        this.connectionManager.setPhase(phase);
    }

    public boolean isConnected() {
        return this.connectionManager.isConnected();
    }

    public boolean isAutoStartup() {
        return this.connectionManager.isAutoStartup();
    }

    public int getPhase() {
        return this.connectionManager.getPhase();
    }

    public boolean isRunning() {
        return this.connectionManager.isRunning();
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            this.clientSession = null;
            this.openConnectionException = null;
            this.connectionLatch = new CountDownLatch(1);
            this.connectionManager.start();
        }
    }

    public void stop() {
        this.connectionManager.stop();
    }

    public void stop(Runnable callback) {
        this.connectionManager.stop(callback);
    }

    private final class IntegrationWebSocketConnectionManager
    extends ConnectionManagerSupport {
        private final WebSocketClient client;
        private final boolean syncClientLifecycle;

        IntegrationWebSocketConnectionManager(WebSocketClient client, String uriTemplate, Object ... uriVariables) {
            super(uriTemplate, uriVariables);
            this.client = client;
            this.syncClientLifecycle = client instanceof Lifecycle && !((Lifecycle)client).isRunning();
        }

        public void startInternal() {
            if (this.syncClientLifecycle) {
                ((Lifecycle)this.client).start();
            }
            ClientWebSocketContainer.this.connecting = true;
            super.startInternal();
        }

        public void stopInternal() throws Exception {
            if (this.syncClientLifecycle) {
                ((Lifecycle)this.client).stop();
            }
            try {
                super.stopInternal();
            }
            finally {
                ClientWebSocketContainer.this.clientSession = null;
                ClientWebSocketContainer.this.openConnectionException = null;
            }
        }

        protected void openConnection() {
            this.logger.info((Object)("Connecting to WebSocket at " + this.getUri()));
            ClientWebSocketContainer.this.headers.setSecWebSocketProtocol(ClientWebSocketContainer.this.getSubProtocols());
            ListenableFuture future = this.client.doHandshake(ClientWebSocketContainer.this.webSocketHandler, ClientWebSocketContainer.this.headers, this.getUri());
            future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<WebSocketSession>(){

                public void onSuccess(WebSocketSession session) {
                    ClientWebSocketContainer.this.clientSession = session;
                    IntegrationWebSocketConnectionManager.this.logger.info((Object)"Successfully connected");
                    ClientWebSocketContainer.this.connectionLatch.countDown();
                }

                public void onFailure(Throwable t) {
                    IntegrationWebSocketConnectionManager.this.logger.error((Object)"Failed to connect", t);
                    ClientWebSocketContainer.this.openConnectionException = t;
                    ClientWebSocketContainer.this.connectionLatch.countDown();
                }
            });
        }

        protected void closeConnection() throws Exception {
            if (ClientWebSocketContainer.this.clientSession != null) {
                ClientWebSocketContainer.this.closeSession(ClientWebSocketContainer.this.clientSession, CloseStatus.NORMAL);
            }
        }

        protected boolean isConnected() {
            return ClientWebSocketContainer.this.clientSession != null && ClientWebSocketContainer.this.clientSession.isOpen();
        }
    }
}

