/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket;

import org.springframework.integration.websocket.IntegrationWebSocketContainer;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.config.annotation.SockJsServiceRegistration;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.TransportHandler;

public class ServerWebSocketContainer
extends IntegrationWebSocketContainer
implements WebSocketConfigurer {
    private final String[] paths;
    private volatile HandshakeHandler handshakeHandler;
    private volatile HandshakeInterceptor[] interceptors;
    private SockJsServiceOptions sockJsServiceOptions;

    public ServerWebSocketContainer(String ... paths) {
        this.paths = paths;
    }

    public ServerWebSocketContainer setHandshakeHandler(HandshakeHandler handshakeHandler) {
        this.handshakeHandler = handshakeHandler;
        return this;
    }

    public ServerWebSocketContainer setInterceptors(HandshakeInterceptor[] interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public ServerWebSocketContainer withSockJs(SockJsServiceOptions ... sockJsServiceOptions) {
        if (ObjectUtils.isEmpty((Object[])sockJsServiceOptions)) {
            this.sockJsServiceOptions = new SockJsServiceOptions();
        } else {
            Assert.state((sockJsServiceOptions.length == 1 ? 1 : 0) != 0, (String)"Only one 'sockJsServiceOptions' is applicable.");
            this.sockJsServiceOptions = sockJsServiceOptions[0];
        }
        return this;
    }

    public void setSockJsServiceOptions(SockJsServiceOptions sockJsServiceOptions) {
        this.sockJsServiceOptions = sockJsServiceOptions;
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        WebSocketHandlerRegistration registration = registry.addHandler(this.webSocketHandler, this.paths).setHandshakeHandler(this.handshakeHandler).addInterceptors(this.interceptors);
        if (this.sockJsServiceOptions != null) {
            SockJsServiceRegistration sockJsServiceRegistration = registration.withSockJS();
            if (this.sockJsServiceOptions.webSocketEnabled != null) {
                sockJsServiceRegistration.setWebSocketEnabled(this.sockJsServiceOptions.webSocketEnabled.booleanValue());
            }
            if (this.sockJsServiceOptions.clientLibraryUrl != null) {
                sockJsServiceRegistration.setClientLibraryUrl(this.sockJsServiceOptions.clientLibraryUrl);
            }
            if (this.sockJsServiceOptions.disconnectDelay != null) {
                sockJsServiceRegistration.setDisconnectDelay(this.sockJsServiceOptions.disconnectDelay.longValue());
            }
            if (this.sockJsServiceOptions.heartbeatTime != null) {
                sockJsServiceRegistration.setHeartbeatTime(this.sockJsServiceOptions.heartbeatTime.longValue());
            }
            if (this.sockJsServiceOptions.httpMessageCacheSize != null) {
                sockJsServiceRegistration.setHttpMessageCacheSize(this.sockJsServiceOptions.httpMessageCacheSize.intValue());
            }
            if (this.sockJsServiceOptions.heartbeatTime != null) {
                sockJsServiceRegistration.setHeartbeatTime(this.sockJsServiceOptions.heartbeatTime.longValue());
            }
            if (this.sockJsServiceOptions.sessionCookieNeeded != null) {
                sockJsServiceRegistration.setSessionCookieNeeded(this.sockJsServiceOptions.sessionCookieNeeded.booleanValue());
            }
            if (this.sockJsServiceOptions.streamBytesLimit != null) {
                sockJsServiceRegistration.setStreamBytesLimit(this.sockJsServiceOptions.streamBytesLimit.intValue());
            }
            if (this.sockJsServiceOptions.transportHandlers != null) {
                sockJsServiceRegistration.setTransportHandlers(this.sockJsServiceOptions.transportHandlers);
            }
            if (this.sockJsServiceOptions.taskScheduler != null) {
                sockJsServiceRegistration.setTaskScheduler(this.sockJsServiceOptions.taskScheduler);
            }
            if (this.sockJsServiceOptions.messageCodec != null) {
                sockJsServiceRegistration.setMessageCodec(this.sockJsServiceOptions.messageCodec);
            }
        }
    }

    public static class SockJsServiceOptions {
        private TaskScheduler taskScheduler;
        private String clientLibraryUrl;
        private Integer streamBytesLimit;
        private Boolean sessionCookieNeeded;
        private Long heartbeatTime;
        private Long disconnectDelay;
        private Integer httpMessageCacheSize;
        private Boolean webSocketEnabled;
        private TransportHandler[] transportHandlers;
        private SockJsMessageCodec messageCodec;

        public SockJsServiceOptions setTaskScheduler(TaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
            return this;
        }

        public SockJsServiceOptions setClientLibraryUrl(String clientLibraryUrl) {
            this.clientLibraryUrl = clientLibraryUrl;
            return this;
        }

        public SockJsServiceOptions setStreamBytesLimit(int streamBytesLimit) {
            this.streamBytesLimit = streamBytesLimit;
            return this;
        }

        public SockJsServiceOptions setSessionCookieNeeded(boolean sessionCookieNeeded) {
            this.sessionCookieNeeded = sessionCookieNeeded;
            return this;
        }

        public SockJsServiceOptions setHeartbeatTime(long heartbeatTime) {
            this.heartbeatTime = heartbeatTime;
            return this;
        }

        public SockJsServiceOptions setDisconnectDelay(long disconnectDelay) {
            this.disconnectDelay = disconnectDelay;
            return this;
        }

        public SockJsServiceOptions setHttpMessageCacheSize(int httpMessageCacheSize) {
            this.httpMessageCacheSize = httpMessageCacheSize;
            return this;
        }

        public SockJsServiceOptions setWebSocketEnabled(boolean webSocketEnabled) {
            this.webSocketEnabled = webSocketEnabled;
            return this;
        }

        public SockJsServiceOptions setTransportHandlers(TransportHandler ... transportHandlers) {
            this.transportHandlers = transportHandlers;
            return this;
        }

        public SockJsServiceOptions setMessageCodec(SockJsMessageCodec messageCodec) {
            this.messageCodec = messageCodec;
            return this;
        }
    }
}

