/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;
import org.springframework.integration.syslog.inbound.SyslogReceivingChannelAdapterSupport;
import org.springframework.messaging.MessageChannel;

public class UdpSyslogReceivingChannelAdapter
extends SyslogReceivingChannelAdapterSupport {
    private volatile UnicastReceivingChannelAdapter udpAdapter;
    private volatile boolean udpAdapterSet;

    public void setUdpAdapter(UnicastReceivingChannelAdapter udpAdapter) {
        this.udpAdapter = udpAdapter;
        this.udpAdapterSet = true;
    }

    @Override
    protected int getPort() {
        if (this.udpAdapter == null) {
            return super.getPort();
        }
        return this.udpAdapter.getPort();
    }

    public String getComponentType() {
        return "syslog:inbound-channel-adapter(udp)";
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.udpAdapter == null) {
            this.udpAdapter = new UnicastReceivingChannelAdapter(this.getPort());
            this.udpAdapter.setBeanFactory(this.getBeanFactory());
        } else {
            this.logger.info((Object)"The 'UdpSyslogReceivingChannelAdapter' overrides an 'outputChannel' of the provided 'UnicastReceivingChannelAdapter' to support Syslog conversion for the incoming UDP packets");
        }
        this.udpAdapter.setOutputChannel((MessageChannel)new FixedSubscriberChannel(this::convertAndSend));
        if (!this.udpAdapterSet) {
            this.udpAdapter.afterPropertiesSet();
        }
    }

    protected void doStart() {
        this.udpAdapter.start();
    }

    protected void doStop() {
        this.udpAdapter.stop();
    }
}

