/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.core.serializer.Deserializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLfSerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;
import org.springframework.integration.syslog.RFC5424SyslogParser;
import org.springframework.util.Assert;

public class RFC6587SyslogDeserializer
implements Deserializer<Map<String, ?>> {
    private final Deserializer<byte[]> delimitedDeserializer;
    private RFC5424SyslogParser parser = new RFC5424SyslogParser();

    public RFC6587SyslogDeserializer() {
        this.delimitedDeserializer = new ByteArrayLfSerializer();
    }

    public RFC6587SyslogDeserializer(Deserializer<byte[]> delimitedDeserializer) {
        this.delimitedDeserializer = delimitedDeserializer;
    }

    public void setParser(RFC5424SyslogParser parser) {
        this.parser = parser;
    }

    public Map<String, ?> deserialize(InputStream inputStream) throws IOException {
        String line;
        DataInputStream stream = new DataInputStream(inputStream);
        int octetCount = 0;
        boolean shortRead = false;
        int peek = stream.read();
        if (this.isDigit(peek)) {
            octetCount = this.calculateLength(stream, peek);
            Assert.state((octetCount > 0 ? 1 : 0) != 0, (String)"Expected length > 0");
            byte[] bytes = new byte[octetCount];
            try {
                stream.readFully(bytes);
            }
            catch (EOFException e) {
                shortRead = true;
            }
            line = new String(bytes, this.getCharset());
        } else if (peek == 60) {
            byte[] bytes = (byte[])this.delimitedDeserializer.deserialize(inputStream);
            line = "<" + new String(bytes, this.getCharset());
        } else {
            if (peek < 0) {
                throw new SoftEndOfStreamException();
            }
            throw new IllegalStateException("Expected a digit or '<', got 0x" + Integer.toHexString(peek));
        }
        return this.parser.parse(line, octetCount, shortRead);
    }

    private boolean isDigit(int peek) {
        return peek >= 48 && peek <= 57;
    }

    private int calculateLength(DataInputStream stream, int peek) throws IOException {
        int c;
        int length = peek & 0xF;
        while (this.isDigit(c = stream.read())) {
            length = length * 10 + (c & 0xF);
        }
        return length;
    }

    protected String getCharset() {
        return "UTF-8";
    }
}

