/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.integration.syslog.SyslogHeaders;
import org.springframework.util.Assert;

public class RFC5424SyslogParser {
    protected static final char NILVALUE = '-';
    protected static final char SPACE = ' ';
    protected final boolean retainOriginal;

    public RFC5424SyslogParser() {
        this(false);
    }

    public RFC5424SyslogParser(boolean retainOriginal) {
        this.retainOriginal = retainOriginal;
    }

    public Map<String, ?> parse(String line, int octetCount, boolean shortRead) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Reader r = new Reader(line);
        try {
            String message;
            if (shortRead) {
                int n;
                for (n = line.length() - 1; n >= 0 && line.charAt(n) == '\u0000'; --n) {
                }
                line = line.substring(0, n);
                throw new IllegalStateException("Insufficient data; expected " + octetCount + " got " + (n + 1));
            }
            r.expect('<');
            int pri = r.readInt();
            r.expect('>');
            int version = r.readInt();
            r.expect(' ');
            Object timestamp = this.getTimestamp(r);
            String host = r.getIdentifier();
            String app = r.getIdentifier();
            String procId = r.getIdentifier();
            String msgId = r.getIdentifier();
            Object structuredData = this.getStructuredData(r);
            if (r.is(' ')) {
                r.getc();
                message = r.rest();
            } else {
                message = "";
            }
            int severity = pri & 7;
            int facility = pri >> 3;
            map.put(SyslogHeaders.FACILITY, facility);
            map.put(SyslogHeaders.SEVERITY, severity);
            map.put(SyslogHeaders.SEVERITY_TEXT, Severity.parseInt(severity).label());
            if (timestamp != null) {
                map.put(SyslogHeaders.TIMESTAMP, timestamp);
            }
            if (host != null) {
                map.put(SyslogHeaders.HOST, host);
            }
            if (app != null) {
                map.put(SyslogHeaders.APP_NAME, app);
            }
            if (procId != null) {
                map.put(SyslogHeaders.PROCID, procId);
            }
            if (msgId != null) {
                map.put(SyslogHeaders.MSGID, msgId);
            }
            map.put(SyslogHeaders.VERSION, version);
            if (structuredData != null) {
                map.put(SyslogHeaders.STRUCTURED_DATA, structuredData);
            }
            map.put(SyslogHeaders.MESSAGE, message);
            map.put(SyslogHeaders.DECODE_ERRORS, "false");
            if (this.retainOriginal) {
                map.put(SyslogHeaders.UNDECODED, line);
            }
        }
        catch (IllegalStateException e) {
            map.put(SyslogHeaders.DECODE_ERRORS, "true");
            map.put(SyslogHeaders.ERRORS, e.getMessage());
            map.put(SyslogHeaders.UNDECODED, line);
        }
        catch (StringIndexOutOfBoundsException sob) {
            map.put(SyslogHeaders.DECODE_ERRORS, "true");
            map.put(SyslogHeaders.ERRORS, "Unexpected end of message: " + sob.getMessage());
            map.put(SyslogHeaders.UNDECODED, line);
        }
        return map;
    }

    protected Object getTimestamp(Reader r) {
        int c = r.getc();
        if (c == 45) {
            return null;
        }
        if (!Character.isDigit(c)) {
            throw new IllegalStateException("Year expected @" + r.idx);
        }
        StringBuilder dateBuilder = new StringBuilder();
        dateBuilder.append((char)c);
        while ((c = r.getc()) != 32) {
            dateBuilder.append((char)c);
        }
        return dateBuilder.toString();
    }

    private Object getStructuredData(Reader r) {
        if (r.is('-')) {
            r.getc();
            return null;
        }
        return this.parseStructuredDataElements(r);
    }

    protected Object parseStructuredDataElements(Reader r) {
        ArrayList<String> fragments = new ArrayList<String>();
        while (r.is('[')) {
            r.mark();
            r.skipTo(']');
            fragments.add(r.getMarkedSegment());
        }
        return fragments;
    }

    protected static enum Severity {
        DEBUG(7, "DEBUG"),
        INFO(6, "INFO"),
        NOTICE(5, "NOTICE"),
        WARN(4, "WARN"),
        ERROR(3, "ERRORS"),
        CRITICAL(2, "CRITICAL"),
        ALERT(1, "ALERT"),
        EMERGENCY(0, "EMERGENCY"),
        UNDEFINED(-1, "UNDEFINED");

        private final int level;
        private final String label;

        private Severity(int level, String label) {
            this.level = level;
            this.label = label;
        }

        public int level() {
            return this.level;
        }

        public String label() {
            return this.label;
        }

        public static Severity parseInt(int syslogSeverity) {
            if (syslogSeverity == 7) {
                return DEBUG;
            }
            if (syslogSeverity == 6) {
                return INFO;
            }
            if (syslogSeverity == 5) {
                return NOTICE;
            }
            if (syslogSeverity == 4) {
                return WARN;
            }
            if (syslogSeverity == 3) {
                return ERROR;
            }
            if (syslogSeverity == 2) {
                return CRITICAL;
            }
            if (syslogSeverity == 1) {
                return ALERT;
            }
            if (syslogSeverity == 0) {
                return EMERGENCY;
            }
            return UNDEFINED;
        }
    }

    protected class Reader {
        private final String line;
        public int idx;
        private int mark;

        public Reader(String l) {
            this.line = l;
        }

        public void mark() {
            this.mark = this.idx;
        }

        public String getMarkedSegment() {
            Assert.state((this.mark <= this.idx ? 1 : 0) != 0, (String)"mark is greater than this.idx");
            return this.line.substring(this.mark, this.idx);
        }

        public int current() {
            return this.line.charAt(this.idx);
        }

        public int prev() {
            return this.line.charAt(this.idx - 1);
        }

        public int getc() {
            return this.line.charAt(this.idx++);
        }

        public int peek() {
            return this.line.charAt(this.idx + 1);
        }

        public void ungetc() {
            --this.idx;
        }

        public int getInt() {
            int c = this.getc();
            if (!Character.isDigit(c)) {
                this.ungetc();
                return -1;
            }
            return c - 48;
        }

        public int readInt() {
            int val = 0;
            while (this.isDigit()) {
                val = val * 10 + this.getInt();
            }
            return val;
        }

        public double readFraction() {
            int val = 0;
            int order = 0;
            while (this.isDigit()) {
                val = val * 10 + this.getInt();
                order *= 10;
            }
            return (double)val / (double)order;
        }

        public boolean is(char c) {
            return this.line.charAt(this.idx) == c;
        }

        public boolean was(char c) {
            return this.line.charAt(this.idx - 1) == c;
        }

        public boolean isDigit() {
            return Character.isDigit(this.line.charAt(this.idx));
        }

        public void expect(char c) {
            if (this.line.charAt(this.idx++) != c) {
                throw new IllegalStateException("Expected '" + c + "' @" + this.idx);
            }
        }

        public void skipTo(char searchChar) {
            while (!this.is(searchChar) || this.was('\\')) {
                this.getc();
            }
            this.getc();
        }

        public String rest() {
            return this.line.substring(this.idx);
        }

        public String getIdentifier() {
            int c;
            StringBuilder sb = new StringBuilder();
            while ((c = this.getc()) >= 33 && c <= 127) {
                sb.append((char)c);
            }
            return sb.toString();
        }
    }
}

