/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.jspecify.annotations.Nullable;

@Deprecated(forRemoval=true, since="7.0")
public class CharacterStreamWritingMessageHandler
extends org.springframework.integration.stream.outbound.CharacterStreamWritingMessageHandler {
    public CharacterStreamWritingMessageHandler(Writer writer) {
        this(writer, -1);
    }

    public CharacterStreamWritingMessageHandler(Writer writer, int bufferSize) {
        super(writer, bufferSize);
    }

    public static CharacterStreamWritingMessageHandler stdout() {
        return CharacterStreamWritingMessageHandler.stdout(null);
    }

    public static CharacterStreamWritingMessageHandler stdout(@Nullable String charsetName) {
        return CharacterStreamWritingMessageHandler.createTargetForStream(System.out, charsetName);
    }

    public static CharacterStreamWritingMessageHandler stderr() {
        return CharacterStreamWritingMessageHandler.stderr(null);
    }

    public static CharacterStreamWritingMessageHandler stderr(@Nullable String charsetName) {
        return CharacterStreamWritingMessageHandler.createTargetForStream(System.err, charsetName);
    }

    private static CharacterStreamWritingMessageHandler createTargetForStream(OutputStream stream, @Nullable String charsetName) {
        if (charsetName == null) {
            return new CharacterStreamWritingMessageHandler(new OutputStreamWriter(stream));
        }
        try {
            return new CharacterStreamWritingMessageHandler(new OutputStreamWriter(stream, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: " + charsetName, e);
        }
    }
}

