/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp.support;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.log.LogAccessor;
import org.springframework.http.MediaType;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.stomp.support.IntegrationStompHeaders;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class StompHeaderMapper
implements HeaderMapper<StompHeaders> {
    private static final LogAccessor LOGGER = new LogAccessor(StompHeaderMapper.class);
    public static final String STOMP_INBOUND_HEADER_NAME_PATTERN = "STOMP_INBOUND_HEADERS";
    public static final String STOMP_OUTBOUND_HEADER_NAME_PATTERN = "STOMP_OUTBOUND_HEADERS";
    private static final String[] STOMP_INBOUND_HEADER_NAMES = new String[]{"content-length", "content-type", "message-id", "receipt-id", "subscription"};
    private static final List<String> STOMP_INBOUND_HEADER_NAMES_LIST = Arrays.asList(STOMP_INBOUND_HEADER_NAMES);
    private static final String[] STOMP_OUTBOUND_HEADER_NAMES = new String[]{"content-length", "content-type", "destination", "receipt", "stomp_destination", "stomp_receipt"};
    private static final List<String> STOMP_OUTBOUND_HEADER_NAMES_LIST = Arrays.asList(STOMP_OUTBOUND_HEADER_NAMES);
    private String[] inboundHeaderNames = STOMP_INBOUND_HEADER_NAMES;
    private String[] outboundHeaderNames = STOMP_OUTBOUND_HEADER_NAMES;

    public void setInboundHeaderNames(String[] inboundHeaderNames) {
        Assert.notNull((Object)inboundHeaderNames, (String)"'inboundHeaderNames' must not be null.");
        Assert.noNullElements((Object[])inboundHeaderNames, (String)"'inboundHeaderNames' must not contains null elements.");
        Object[] copy = Arrays.copyOf(inboundHeaderNames, inboundHeaderNames.length);
        Arrays.sort(copy);
        if (!Arrays.equals(STOMP_INBOUND_HEADER_NAMES, inboundHeaderNames)) {
            this.inboundHeaderNames = copy;
        }
    }

    public void setOutboundHeaderNames(String[] outboundHeaderNames) {
        Assert.notNull((Object)outboundHeaderNames, (String)"'outboundHeaderNames' must not be null.");
        Assert.noNullElements((Object[])outboundHeaderNames, (String)"'outboundHeaderNames' must not contains null elements.");
        Object[] copy = Arrays.copyOf(outboundHeaderNames, outboundHeaderNames.length);
        Arrays.sort(copy);
        if (!Arrays.equals(STOMP_OUTBOUND_HEADER_NAMES, outboundHeaderNames)) {
            this.outboundHeaderNames = copy;
        }
    }

    public void fromHeaders(MessageHeaders headers, StompHeaders target) {
        for (Map.Entry entry : headers.entrySet()) {
            MultiValueMap multiValueMap;
            String name = (String)entry.getKey();
            if (StompHeaderMapper.shouldMapHeader(name, this.outboundHeaderNames)) {
                Object value = entry.getValue();
                if (value == null) continue;
                this.setStompHeader(target, name, value);
                continue;
            }
            if (!"nativeHeaders".equals(name) || (multiValueMap = (MultiValueMap)headers.get((Object)"nativeHeaders", MultiValueMap.class)) == null) continue;
            for (Map.Entry entry1 : multiValueMap.entrySet()) {
                String value;
                name = (String)entry1.getKey();
                if (!StompHeaderMapper.shouldMapHeader(name, this.outboundHeaderNames) || !StringUtils.hasText((String)(value = (String)((List)entry1.getValue()).get(0)))) continue;
                this.setStompHeader(target, name, value);
            }
        }
    }

    private void setStompHeader(StompHeaders target, String name, Object value) {
        switch (name) {
            case "content-length": {
                StompHeaderMapper.setContentLength(target, value);
                break;
            }
            case "content-type": 
            case "contentType": {
                StompHeaderMapper.setContentType(target, name, value);
                break;
            }
            case "destination": 
            case "stomp_destination": {
                StompHeaderMapper.setDestination(target, value);
                break;
            }
            case "receipt": 
            case "stomp_receipt": {
                StompHeaderMapper.setReceipt(target, value);
                break;
            }
            default: {
                if (value instanceof String) {
                    target.set(name, (String)value);
                    break;
                }
                Class<?> clazz = value != null ? value.getClass() : null;
                throw new IllegalArgumentException("Expected String value for any generic STOMP header value, but received: " + String.valueOf(clazz));
            }
        }
    }

    private static void setContentLength(StompHeaders target, Object value) {
        if (value instanceof Number) {
            target.setContentLength(((Number)value).longValue());
        } else if (value instanceof String) {
            target.setContentLength(Long.parseLong((String)value));
        } else {
            Class<?> clazz = value != null ? value.getClass() : null;
            throw new IllegalArgumentException("Expected Number or String value for 'content-length' header value, but received: " + String.valueOf(clazz));
        }
    }

    private static void setContentType(StompHeaders target, String name, Object value) {
        MimeType contentType = target.getContentType();
        if (contentType == null || "content-type".equals(name)) {
            if (value instanceof MediaType) {
                target.setContentType((MimeType)((MediaType)value));
            } else if (value instanceof String) {
                target.setContentType((MimeType)MediaType.parseMediaType((String)((String)value)));
            } else {
                Class<?> clazz = value != null ? value.getClass() : null;
                throw new IllegalArgumentException("Expected MediaType or String value for 'content-type' header value, but received: " + String.valueOf(clazz));
            }
        }
    }

    private static void setReceipt(StompHeaders target, Object value) {
        if (!(value instanceof String)) {
            Class<?> clazz = value != null ? value.getClass() : null;
            throw new IllegalArgumentException("Expected String value for 'receipt' header value, but received: " + String.valueOf(clazz));
        }
        target.setReceipt((String)value);
    }

    private static void setDestination(StompHeaders target, Object value) {
        if (!(value instanceof String)) {
            Class<?> clazz = value != null ? value.getClass() : null;
            throw new IllegalArgumentException("Expected String value for 'destination' header value, but received: " + String.valueOf(clazz));
        }
        target.setDestination((String)value);
    }

    public Map<String, Object> toHeaders(StompHeaders source) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        for (String name : source.keySet()) {
            if (!StompHeaderMapper.shouldMapHeader(name, this.inboundHeaderNames)) continue;
            if ("content-type".equals(name)) {
                target.put("contentType", source.getContentType());
                continue;
            }
            Object key = name;
            if (IntegrationStompHeaders.HEADERS.contains(name)) {
                key = "stomp_" + name;
            }
            target.put((String)key, source.getFirst(name));
        }
        return target;
    }

    private static boolean shouldMapHeader(String headerName, String[] patterns) {
        if (patterns != null && patterns.length > 0) {
            for (String pattern : patterns) {
                if (PatternMatchUtils.simpleMatch((String)pattern, (String)headerName)) {
                    LOGGER.debug(() -> MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                    return true;
                }
                if (STOMP_INBOUND_HEADER_NAME_PATTERN.equals(pattern) && STOMP_INBOUND_HEADER_NAMES_LIST.contains(headerName)) {
                    LOGGER.debug(() -> MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                    return true;
                }
                if (!STOMP_OUTBOUND_HEADER_NAME_PATTERN.equals(pattern) || !STOMP_OUTBOUND_HEADER_NAMES_LIST.contains(headerName) && !"contentType".equals(headerName)) continue;
                LOGGER.debug(() -> MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                return true;
            }
        }
        LOGGER.debug(() -> MessageFormat.format("headerName=[{0}] WILL NOT be mapped", headerName));
        return false;
    }
}

