/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.outbound;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sshd.sftp.client.SftpClient;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.ClientCallbackWithoutResult;
import org.springframework.integration.file.remote.MessageSessionCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.sftp.session.SftpFileInfo;
import org.springframework.integration.sftp.session.SftpRemoteFileTemplate;

public class SftpOutboundGateway
extends AbstractRemoteFileOutboundGateway<SftpClient.DirEntry> {
    public SftpOutboundGateway(SessionFactory<SftpClient.DirEntry> sessionFactory, MessageSessionCallback<SftpClient.DirEntry, ?> messageSessionCallback) {
        this(new SftpRemoteFileTemplate(sessionFactory), messageSessionCallback);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public SftpOutboundGateway(RemoteFileTemplate<SftpClient.DirEntry> remoteFileTemplate, MessageSessionCallback<SftpClient.DirEntry, ?> messageSessionCallback) {
        super(remoteFileTemplate, messageSessionCallback);
    }

    public SftpOutboundGateway(SessionFactory<SftpClient.DirEntry> sessionFactory, String command, @Nullable String expression) {
        this(new SftpRemoteFileTemplate(sessionFactory), command, expression);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public SftpOutboundGateway(RemoteFileTemplate<SftpClient.DirEntry> remoteFileTemplate, String command, @Nullable String expression) {
        super(remoteFileTemplate, command, expression);
    }

    protected boolean isDirectory(SftpClient.DirEntry file) {
        return file.getAttributes().isDirectory();
    }

    protected boolean isLink(SftpClient.DirEntry file) {
        return file.getAttributes().isSymbolicLink();
    }

    protected String getFilename(SftpClient.DirEntry file) {
        return file.getFilename();
    }

    protected String getFilename(AbstractFileInfo<SftpClient.DirEntry> file) {
        return file.getFilename();
    }

    protected List<AbstractFileInfo<SftpClient.DirEntry>> asFileInfoList(Collection<SftpClient.DirEntry> files) {
        return files.stream().map(SftpFileInfo::new).collect(Collectors.toList());
    }

    protected long getModified(SftpClient.DirEntry file) {
        return file.getAttributes().getModifyTime().toMillis();
    }

    protected SftpClient.DirEntry enhanceNameWithSubDirectory(SftpClient.DirEntry file, String directory) {
        return new SftpClient.DirEntry(directory + file.getFilename(), directory + file.getFilename(), file.getAttributes());
    }

    public String getComponentType() {
        return "sftp:outbound-gateway";
    }

    public boolean isChmodCapable() {
        return true;
    }

    protected void doChmod(RemoteFileOperations<SftpClient.DirEntry> remoteFileOperations, String path, int chmod) {
        remoteFileOperations.executeWithClient((ClientCallback)((ClientCallbackWithoutResult)client -> {
            try {
                SftpClient.Attributes attributes = client.stat(path);
                attributes.setPermissions(chmod);
                client.setStat(path, attributes);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to execute 'chmod " + Integer.toOctalString(chmod) + " " + path + "'", ex);
            }
        }));
    }
}

