/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.sftp.session.JSchSessionWrapper;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class SftpSession
implements org.springframework.integration.file.remote.session.Session<ChannelSftp.LsEntry> {
    private static final Log LOGGER = LogFactory.getLog(SftpSession.class);
    private static final String SESSION_IS_NOT_CONNECTED = "session is not connected";
    private static final Duration DEFAULT_CHANNEL_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    private final Session jschSession;
    private final JSchSessionWrapper wrapper;
    private int channelConnectTimeout = (int)DEFAULT_CHANNEL_CONNECT_TIMEOUT.toMillis();
    private volatile ChannelSftp channel;
    private volatile boolean closed;

    public SftpSession(Session jschSession) {
        Assert.notNull((Object)jschSession, (String)"jschSession must not be null");
        this.jschSession = jschSession;
        this.wrapper = null;
    }

    public SftpSession(JSchSessionWrapper wrapper) {
        Assert.notNull((Object)wrapper, (String)"wrapper must not be null");
        this.jschSession = wrapper.getSession();
        this.wrapper = wrapper;
    }

    public void setChannelConnectTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"'timeout' cannot be null");
        this.channelConnectTimeout = (int)timeout.toMillis();
    }

    public boolean remove(String path) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)SESSION_IS_NOT_CONNECTED);
        try {
            this.channel.rm(path);
            return true;
        }
        catch (SftpException e) {
            throw new IOException("Failed to remove file.", e);
        }
    }

    public ChannelSftp.LsEntry[] list(String path) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)SESSION_IS_NOT_CONNECTED);
        try {
            Vector lsEntries = this.channel.ls(path);
            if (lsEntries != null) {
                ChannelSftp.LsEntry[] entries = new ChannelSftp.LsEntry[lsEntries.size()];
                for (int i = 0; i < lsEntries.size(); ++i) {
                    Object next = lsEntries.get(i);
                    Assert.state((boolean)(next instanceof ChannelSftp.LsEntry), (String)"expected only LsEntry instances from channel.ls()");
                    entries[i] = (ChannelSftp.LsEntry)next;
                }
                return entries;
            }
        }
        catch (SftpException e) {
            throw new IOException("Failed to list files", e);
        }
        return new ChannelSftp.LsEntry[0];
    }

    public String[] listNames(String path) throws IOException {
        ChannelSftp.LsEntry[] entries = this.list(path);
        ArrayList<String> names = new ArrayList<String>();
        for (ChannelSftp.LsEntry entry : entries) {
            String fileName = entry.getFilename();
            SftpATTRS attrs = entry.getAttrs();
            if (attrs.isDir() || attrs.isLink()) continue;
            names.add(fileName);
        }
        return names.toArray(new String[0]);
    }

    public void read(String source, OutputStream os) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)SESSION_IS_NOT_CONNECTED);
        try {
            InputStream is = this.channel.get(source);
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (SftpException e) {
            throw new IOException("failed to read file " + source, e);
        }
    }

    public InputStream readRaw(String source) throws IOException {
        try {
            return this.channel.get(source);
        }
        catch (SftpException e) {
            throw new IOException("failed to read file " + source, e);
        }
    }

    public boolean finalizeRaw() {
        return true;
    }

    public void write(InputStream inputStream, String destination) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)SESSION_IS_NOT_CONNECTED);
        try {
            this.channel.put(inputStream, destination);
        }
        catch (SftpException e) {
            throw new IOException("failed to write file", e);
        }
    }

    public void append(InputStream inputStream, String destination) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)SESSION_IS_NOT_CONNECTED);
        try {
            this.channel.put(inputStream, destination, 2);
        }
        catch (SftpException e) {
            throw new IOException("failed to write file", e);
        }
    }

    public void close() {
        this.closed = true;
        if (this.wrapper != null) {
            if (this.channel != null) {
                this.channel.disconnect();
            }
            this.wrapper.close();
        } else if (this.jschSession.isConnected()) {
            this.jschSession.disconnect();
        }
    }

    public boolean isOpen() {
        return !this.closed && this.jschSession.isConnected();
    }

    public void rename(String pathFrom, String pathTo) throws IOException {
        try {
            this.channel.rename(pathFrom, pathTo);
        }
        catch (SftpException sftpex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Initial File rename failed, possibly because file already exists. Will attempt to delete file: " + pathTo + " and execute rename again."));
            }
            try {
                this.remove(pathTo);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Delete file: " + pathTo + " succeeded. Will attempt rename again"));
                }
            }
            catch (IOException ioex) {
                IOException exception = new IOException("Failed to delete file " + pathTo, sftpex);
                exception.addSuppressed(ioex);
                throw exception;
            }
            try {
                this.channel.rename(pathFrom, pathTo);
            }
            catch (SftpException sftpex2) {
                IOException exception = new IOException("failed to rename from " + pathFrom + " to " + pathTo, sftpex);
                exception.addSuppressed(sftpex2);
                throw exception;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("File: " + pathFrom + " was successfully renamed to " + pathTo));
        }
    }

    public boolean mkdir(String remoteDirectory) throws IOException {
        block2: {
            try {
                this.channel.mkdir(remoteDirectory);
            }
            catch (SftpException ex) {
                if (ex.id == 4 && this.exists(remoteDirectory)) break block2;
                throw new IOException("failed to create remote directory '" + remoteDirectory + "'.", ex);
            }
        }
        return true;
    }

    public boolean rmdir(String remoteDirectory) throws IOException {
        try {
            this.channel.rmdir(remoteDirectory);
        }
        catch (SftpException e) {
            throw new IOException("failed to remove remote directory '" + remoteDirectory + "'.", e);
        }
        return true;
    }

    public boolean exists(String path) {
        try {
            this.channel.lstat(path);
            return true;
        }
        catch (SftpException ex) {
            if (ex.id == 2) {
                return false;
            }
            throw new UncheckedIOException("Cannot check 'lstat' for path " + path, new IOException(ex));
        }
    }

    void connect() {
        try {
            if (!this.jschSession.isConnected()) {
                this.jschSession.connect();
            }
            this.channel = (ChannelSftp)this.jschSession.openChannel("sftp");
            if (this.channel != null && !this.channel.isConnected()) {
                this.channel.connect(this.channelConnectTimeout);
            }
        }
        catch (JSchException e) {
            this.close();
            throw new IllegalStateException("failed to connect", e);
        }
    }

    public ChannelSftp getClientInstance() {
        return this.channel;
    }

    public String getHostPort() {
        return this.jschSession.getHost() + ':' + this.jschSession.getPort();
    }

    public boolean test() {
        return this.isOpen() && this.doTest();
    }

    private boolean doTest() {
        try {
            this.channel.lstat(this.channel.getHome());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

