/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.dsl;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.util.Comparator;
import org.springframework.integration.file.dsl.RemoteFileInboundChannelAdapterSpec;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.sftp.filters.SftpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.sftp.filters.SftpRegexPatternFileListFilter;
import org.springframework.integration.sftp.filters.SftpSimplePatternFileListFilter;
import org.springframework.integration.sftp.inbound.SftpInboundFileSynchronizer;
import org.springframework.integration.sftp.inbound.SftpInboundFileSynchronizingMessageSource;

public class SftpInboundChannelAdapterSpec
extends RemoteFileInboundChannelAdapterSpec<ChannelSftp.LsEntry, SftpInboundChannelAdapterSpec, SftpInboundFileSynchronizingMessageSource> {
    SftpInboundChannelAdapterSpec(SessionFactory<ChannelSftp.LsEntry> sessionFactory, Comparator<File> comparator) {
        super((AbstractInboundFileSynchronizer)new SftpInboundFileSynchronizer(sessionFactory));
        this.target = new SftpInboundFileSynchronizingMessageSource((AbstractInboundFileSynchronizer<ChannelSftp.LsEntry>)this.synchronizer, comparator);
    }

    public SftpInboundChannelAdapterSpec patternFilter(String pattern) {
        return (SftpInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<ChannelSftp.LsEntry>)new SftpSimplePatternFileListFilter(pattern)));
    }

    public SftpInboundChannelAdapterSpec regexFilter(String regex) {
        return (SftpInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<ChannelSftp.LsEntry>)new SftpRegexPatternFileListFilter(regex)));
    }

    private CompositeFileListFilter<ChannelSftp.LsEntry> composeFilters(FileListFilter<ChannelSftp.LsEntry> fileListFilter) {
        CompositeFileListFilter compositeFileListFilter = new CompositeFileListFilter();
        compositeFileListFilter.addFilters(new FileListFilter[]{fileListFilter, new SftpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "sftpMessageSource")});
        return compositeFileListFilter;
    }
}

