/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.config;

import java.util.List;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.scripting.DefaultScriptVariableGenerator;
import org.springframework.integration.scripting.RefreshableResourceScriptSource;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractScriptParser
extends AbstractSingleBeanDefinitionParser {
    protected static final String LOCATION_ATTRIBUTE = "location";
    protected static final String REFRESH_CHECK_DELAY_ATTRIBUTE = "refresh-check-delay";

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        RuntimeBeanReference scriptVariableGeneratorDef;
        String scriptLocation = element.getAttribute(LOCATION_ATTRIBUTE);
        String scriptText = DomUtils.getTextValue((Element)element);
        if (StringUtils.hasText((String)scriptLocation) == StringUtils.hasText((String)scriptText)) {
            parserContext.getReaderContext().error("Either the 'location' attribute or inline script text must be provided, but not both.", (Object)element);
            return;
        }
        List variableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"variable");
        String scriptVariableGeneratorName = element.getAttribute("script-variable-generator");
        if (StringUtils.hasText((String)scriptVariableGeneratorName) && variableElements.size() > 0) {
            parserContext.getReaderContext().error("'script-variable-generator' and 'variable' sub-elements are mutually exclusive.", (Object)element);
            return;
        }
        if (StringUtils.hasText((String)scriptLocation)) {
            builder.addConstructorArgValue(this.resolveScriptLocation(element, scriptLocation));
        } else {
            builder.addConstructorArgValue((Object)new StaticScriptSource(scriptText));
        }
        if (!StringUtils.hasText((String)scriptVariableGeneratorName)) {
            BeanDefinitionBuilder scriptVariableGeneratorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultScriptVariableGenerator.class);
            ManagedMap<String, Object> variableMap = this.buildVariablesMap(element, parserContext, variableElements);
            if (!CollectionUtils.isEmpty(variableMap)) {
                scriptVariableGeneratorBuilder.addConstructorArgValue(variableMap);
            }
            scriptVariableGeneratorDef = scriptVariableGeneratorBuilder.getBeanDefinition();
        } else {
            scriptVariableGeneratorDef = new RuntimeBeanReference(scriptVariableGeneratorName);
        }
        builder.addConstructorArgValue((Object)scriptVariableGeneratorDef);
        this.postProcess(builder, element, parserContext);
    }

    protected void postProcess(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
    }

    private Object resolveScriptLocation(Element element, String scriptLocation) {
        String refreshDelayText = element.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        String beanClassName = RefreshableResourceScriptSource.class.getName();
        BeanDefinitionBuilder resourceScriptSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)beanClassName);
        resourceScriptSourceBuilder.addConstructorArgValue((Object)scriptLocation);
        if (StringUtils.hasText((String)refreshDelayText)) {
            resourceScriptSourceBuilder.addConstructorArgValue((Object)refreshDelayText);
        } else {
            resourceScriptSourceBuilder.addConstructorArgValue((Object)-1L);
        }
        return resourceScriptSourceBuilder.getBeanDefinition();
    }

    private ManagedMap<String, Object> buildVariablesMap(final Element element, final ParserContext parserContext, List<Element> variableElements) {
        ManagedMap<String, Object> variableMap = new ManagedMap<String, Object>(){

            public Object put(String key, Object value) {
                if (this.containsKey(key)) {
                    parserContext.getReaderContext().error("Duplicated variable: " + key, (Object)element);
                }
                return super.put((Object)key, value);
            }
        };
        for (Element childElement : variableElements) {
            String variableName = childElement.getAttribute("name");
            String variableValue = childElement.getAttribute("value");
            String variableRef = childElement.getAttribute("ref");
            if (StringUtils.hasText((String)variableValue) == StringUtils.hasText((String)variableRef)) {
                parserContext.getReaderContext().error("Exactly one of the 'ref' attribute or 'value' attribute,  is required for element " + IntegrationNamespaceUtils.createElementDescription((Element)element) + ".", (Object)element);
            }
            if (StringUtils.hasText((String)variableValue)) {
                variableMap.put((Object)variableName, (Object)variableValue);
                continue;
            }
            variableMap.put((Object)variableName, (Object)new RuntimeBeanReference(variableRef));
        }
        String variables = element.getAttribute("variables");
        if (StringUtils.hasText((String)variables)) {
            String[] variablePairs;
            for (String variablePair : variablePairs = StringUtils.commaDelimitedListToStringArray((String)variables)) {
                String[] variableValue = variablePair.split("=");
                if (variableValue.length != 2) {
                    parserContext.getReaderContext().error("Variable declarations in the 'variable' attribute must have the form 'var=value'; found : '" + variablePair + "'", (Object)element);
                }
                String variable = variableValue[0].trim();
                String value = variableValue[1];
                if (variable.endsWith("-ref")) {
                    variable = variable.substring(0, variable.indexOf("-ref"));
                    variableMap.put((Object)variable, (Object)new RuntimeBeanReference(value));
                    continue;
                }
                variableMap.put((Object)variable, (Object)value);
            }
        }
        return variableMap;
    }
}

