/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.outbound;

import com.mongodb.client.MongoCollection;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.mongodb.outbound.MessageCollectionCallback;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MongoDbOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private @Nullable MongoDatabaseFactory mongoDbFactory;
    private @Nullable MongoConverter mongoConverter;
    private MongoOperations mongoTemplate;
    private EvaluationContext evaluationContext;
    private @Nullable Expression queryExpression;
    private @Nullable MessageCollectionCallback<?> collectionCallback;
    private boolean expectSingleResult = false;
    private Class<?> entityClass = Document.class;
    private Expression collectionNameExpression;

    public MongoDbOutboundGateway(MongoDatabaseFactory mongoDbFactory) {
        this(mongoDbFactory, (MongoConverter)new MappingMongoConverter((DbRefResolver)new DefaultDbRefResolver(mongoDbFactory), (MappingContext)new MongoMappingContext()));
    }

    public MongoDbOutboundGateway(MongoDatabaseFactory mongoDbFactory, MongoConverter mongoConverter) {
        Assert.notNull((Object)mongoDbFactory, (String)"mongoDatabaseFactory must not be null.");
        Assert.notNull((Object)mongoConverter, (String)"mongoConverter must not be null.");
        this.mongoDbFactory = mongoDbFactory;
        this.mongoConverter = mongoConverter;
    }

    public MongoDbOutboundGateway(MongoOperations mongoTemplate) {
        Assert.notNull((Object)mongoTemplate, (String)"mongoTemplate must not be null.");
        this.mongoTemplate = mongoTemplate;
    }

    public void setQueryExpression(Expression queryExpression) {
        Assert.notNull((Object)queryExpression, (String)"queryExpression must not be null.");
        this.queryExpression = queryExpression;
    }

    public void setQueryExpressionString(String queryExpressionString) {
        Assert.notNull((Object)queryExpressionString, (String)"queryExpressionString must not be null.");
        this.queryExpression = EXPRESSION_PARSER.parseExpression(queryExpressionString);
    }

    public void setMessageCollectionCallback(MessageCollectionCallback<?> collectionCallback) {
        Assert.notNull(collectionCallback, (String)"'collectionCallback' must not be null.");
        this.collectionCallback = collectionCallback;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public void setEntityClass(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass must not be null.");
        this.entityClass = entityClass;
    }

    public void setCollectionNameExpression(Expression collectionNameExpression) {
        Assert.notNull((Object)collectionNameExpression, (String)"collectionNameExpression must not be null.");
        this.collectionNameExpression = collectionNameExpression;
    }

    public void setCollectionNameExpressionString(String collectionNameExpressionString) {
        Assert.notNull((Object)collectionNameExpressionString, (String)"collectionNameExpressionString must not be null.");
        this.collectionNameExpression = EXPRESSION_PARSER.parseExpression(collectionNameExpressionString);
    }

    public void setMongoConverter(MongoConverter mongoConverter) {
        Assert.notNull((Object)mongoConverter, (String)"mongoConverter cannot be null");
        Assert.isNull((Object)this.mongoTemplate, (String)"'mongoConverter' can not be set when instance was constructed with MongoTemplate");
        this.mongoConverter = mongoConverter;
    }

    protected void doInit() {
        Assert.state((this.queryExpression != null || this.collectionCallback != null ? 1 : 0) != 0, (String)"no query or collectionCallback is specified");
        Assert.state((this.collectionNameExpression != null ? 1 : 0) != 0, (String)"no collection name specified");
        if (this.queryExpression != null && this.collectionCallback != null) {
            throw new IllegalStateException("query and collectionCallback are mutually exclusive");
        }
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        TypeLocator typeLocator = this.evaluationContext.getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            ((StandardTypeLocator)typeLocator).registerImport(Query.class.getPackage().getName());
        }
        if (this.mongoTemplate == null) {
            Assert.state((this.mongoDbFactory != null ? 1 : 0) != 0, (String)"'mongoDbFactory' must not be null if 'mongoTemplate' is null.");
            this.mongoTemplate = new MongoTemplate(this.mongoDbFactory, this.mongoConverter);
        }
    }

    protected @Nullable Object handleRequestMessage(Message<?> requestMessage) {
        String collectionName = (String)this.collectionNameExpression.getValue(this.evaluationContext, requestMessage, String.class);
        Assert.notNull((Object)collectionName, (String)"'collectionNameExpression' cannot evaluate to null");
        MessageCollectionCallback<?> collectionCallbackToUse = this.collectionCallback;
        if (collectionCallbackToUse != null) {
            return this.mongoTemplate.execute(collectionName, collection -> collectionCallbackToUse.doInCollection((MongoCollection<Document>)collection, requestMessage));
        }
        Query query = this.buildQuery(requestMessage);
        if (this.expectSingleResult) {
            return this.mongoTemplate.findOne(query, this.entityClass, collectionName);
        }
        return this.mongoTemplate.find(query, this.entityClass, collectionName);
    }

    private Query buildQuery(Message<?> requestMessage) {
        BasicQuery query;
        Object expressionValue = this.getRequiredQueryExpression().getValue(this.evaluationContext, requestMessage, Object.class);
        if (expressionValue instanceof String) {
            query = new BasicQuery((String)expressionValue);
        } else if (expressionValue instanceof Query) {
            query = (Query)expressionValue;
        } else {
            throw new IllegalStateException("'queryExpression' must evaluate to String or org.springframework.data.mongodb.core.query.Query");
        }
        return query;
    }

    private Expression getRequiredQueryExpression() {
        return this.queryExpression;
    }
}

