/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.dsl;

import java.util.function.Supplier;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.expression.SupplierExpression;
import org.springframework.integration.mongodb.inbound.ReactiveMongoDbMessageSource;

public class ReactiveMongoDbMessageSourceSpec
extends MessageSourceSpec<ReactiveMongoDbMessageSourceSpec, ReactiveMongoDbMessageSource> {
    protected ReactiveMongoDbMessageSourceSpec(ReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory, Expression queryExpression) {
        this.target = new ReactiveMongoDbMessageSource(reactiveMongoDatabaseFactory, queryExpression);
    }

    protected ReactiveMongoDbMessageSourceSpec(ReactiveMongoOperations reactiveMongoTemplate, Expression queryExpression) {
        this.target = new ReactiveMongoDbMessageSource(reactiveMongoTemplate, queryExpression);
    }

    public ReactiveMongoDbMessageSourceSpec entityClass(Class<?> entityClass) {
        ((ReactiveMongoDbMessageSource)((Object)this.target)).setEntityClass(entityClass);
        return this;
    }

    public ReactiveMongoDbMessageSourceSpec expectSingleResult(boolean expectSingleResult) {
        ((ReactiveMongoDbMessageSource)((Object)this.target)).setExpectSingleResult(expectSingleResult);
        return this;
    }

    public ReactiveMongoDbMessageSourceSpec collectionName(String collectionName) {
        return this.collectionNameExpression((Expression)new LiteralExpression(collectionName));
    }

    public ReactiveMongoDbMessageSourceSpec collectionNameExpression(String collectionNameExpression) {
        return this.collectionNameExpression(PARSER.parseExpression(collectionNameExpression));
    }

    public ReactiveMongoDbMessageSourceSpec collectionNameSupplier(Supplier<String> collectionNameSupplier) {
        return this.collectionNameExpression((Expression)new SupplierExpression(collectionNameSupplier));
    }

    public ReactiveMongoDbMessageSourceSpec collectionNameExpression(Expression collectionNameExpression) {
        ((ReactiveMongoDbMessageSource)((Object)this.target)).setCollectionNameExpression(collectionNameExpression);
        return this;
    }

    public ReactiveMongoDbMessageSourceSpec mongoConverter(MongoConverter mongoConverter) {
        ((ReactiveMongoDbMessageSource)((Object)this.target)).setMongoConverter(mongoConverter);
        return this;
    }
}

